/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.route.engine.type.complex.ShardingCartesianRoutingEngine;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRoutingEngine;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.apache.shardingsphere.underlying.route.context.RouteResult;

public final class ShardingComplexRoutingEngine
implements ShardingRouteEngine {
    private final Collection<String> logicTables;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingConditions shardingConditions;
    private final ConfigurationProperties properties;

    @Override
    public RouteResult route(ShardingRule shardingRule) {
        ArrayList<RouteResult> result = new ArrayList<RouteResult>(this.logicTables.size());
        TreeSet bindingTableNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (String each : this.logicTables) {
            Optional tableRule = shardingRule.findTableRule(each);
            if (!tableRule.isPresent()) continue;
            if (!bindingTableNames.contains(each)) {
                result.add(new ShardingStandardRoutingEngine(((TableRule)tableRule.get()).getLogicTable(), this.sqlStatementContext, this.shardingConditions, this.properties).route(shardingRule));
            }
            shardingRule.findBindingTableRule(each).ifPresent(bindingTableRule -> bindingTableNames.addAll(bindingTableRule.getTableRules().stream().map(TableRule::getLogicTable).collect(Collectors.toList())));
        }
        if (result.isEmpty()) {
            throw new ShardingSphereException("Cannot find table rule and default data source with logic tables: '%s'", new Object[]{this.logicTables});
        }
        if (1 == result.size()) {
            return (RouteResult)result.iterator().next();
        }
        return new ShardingCartesianRoutingEngine(result).route(shardingRule);
    }

    @Generated
    public ShardingComplexRoutingEngine(Collection<String> logicTables, SQLStatementContext sqlStatementContext, ShardingConditions shardingConditions, ConfigurationProperties properties) {
        this.logicTables = logicTables;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingConditions = shardingConditions;
        this.properties = properties;
    }
}

