/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.standard;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.api.hint.HintManager;
import org.apache.shardingsphere.core.rule.BindingTableRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.rule.TableRule;
import org.apache.shardingsphere.core.strategy.route.ShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.hint.HintShardingStrategy;
import org.apache.shardingsphere.core.strategy.route.value.ListRouteValue;
import org.apache.shardingsphere.core.strategy.route.value.RouteValue;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingCondition;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.DeleteStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.UpdateStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.TableAvailable;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.apache.shardingsphere.underlying.common.rule.DataNode;
import org.apache.shardingsphere.underlying.route.context.RouteMapper;
import org.apache.shardingsphere.underlying.route.context.RouteResult;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;

public final class ShardingStandardRoutingEngine
implements ShardingRouteEngine {
    private final String logicTableName;
    private final SQLStatementContext sqlStatementContext;
    private final ShardingConditions shardingConditions;
    private final ConfigurationProperties properties;
    private final Collection<Collection<DataNode>> originalDataNodes = new LinkedList<Collection<DataNode>>();

    @Override
    public RouteResult route(ShardingRule shardingRule) {
        if (this.isDMLForModify(this.sqlStatementContext) && 1 != ((TableAvailable)this.sqlStatementContext).getAllTables().size()) {
            throw new ShardingSphereException("Cannot support Multiple-Table for '%s'.", new Object[]{this.sqlStatementContext.getSqlStatement()});
        }
        return this.generateRouteResult(this.getDataNodes(shardingRule, shardingRule.getTableRule(this.logicTableName)));
    }

    private boolean isDMLForModify(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext || sqlStatementContext instanceof UpdateStatementContext || sqlStatementContext instanceof DeleteStatementContext;
    }

    private RouteResult generateRouteResult(Collection<DataNode> routedDataNodes) {
        RouteResult result = new RouteResult();
        result.getOriginalDataNodes().addAll(this.originalDataNodes);
        for (DataNode each : routedDataNodes) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), Collections.singletonList(new RouteMapper(this.logicTableName, each.getTableName()))));
        }
        return result;
    }

    private Collection<DataNode> getDataNodes(ShardingRule shardingRule, TableRule tableRule) {
        if (this.isRoutingByHint(shardingRule, tableRule)) {
            return this.routeByHint(shardingRule, tableRule);
        }
        if (this.isRoutingByShardingConditions(shardingRule, tableRule)) {
            return this.routeByShardingConditions(shardingRule, tableRule);
        }
        return this.routeByMixedConditions(shardingRule, tableRule);
    }

    private boolean isRoutingByHint(ShardingRule shardingRule, TableRule tableRule) {
        return shardingRule.getDatabaseShardingStrategy(tableRule) instanceof HintShardingStrategy && shardingRule.getTableShardingStrategy(tableRule) instanceof HintShardingStrategy;
    }

    private Collection<DataNode> routeByHint(ShardingRule shardingRule, TableRule tableRule) {
        return this.route0(shardingRule, tableRule, this.getDatabaseShardingValuesFromHint(), this.getTableShardingValuesFromHint());
    }

    private boolean isRoutingByShardingConditions(ShardingRule shardingRule, TableRule tableRule) {
        return !(shardingRule.getDatabaseShardingStrategy(tableRule) instanceof HintShardingStrategy) && !(shardingRule.getTableShardingStrategy(tableRule) instanceof HintShardingStrategy);
    }

    private Collection<DataNode> routeByShardingConditions(ShardingRule shardingRule, TableRule tableRule) {
        return this.shardingConditions.getConditions().isEmpty() ? this.route0(shardingRule, tableRule, Collections.emptyList(), Collections.emptyList()) : this.routeByShardingConditionsWithCondition(shardingRule, tableRule);
    }

    private Collection<DataNode> routeByShardingConditionsWithCondition(ShardingRule shardingRule, TableRule tableRule) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (ShardingCondition each : this.shardingConditions.getConditions()) {
            Collection<DataNode> dataNodes = this.route0(shardingRule, tableRule, this.getShardingValuesFromShardingConditions(shardingRule, shardingRule.getDatabaseShardingStrategy(tableRule).getShardingColumns(), each), this.getShardingValuesFromShardingConditions(shardingRule, shardingRule.getTableShardingStrategy(tableRule).getShardingColumns(), each));
            result.addAll(dataNodes);
            this.originalDataNodes.add(dataNodes);
        }
        return result;
    }

    private Collection<DataNode> routeByMixedConditions(ShardingRule shardingRule, TableRule tableRule) {
        return this.shardingConditions.getConditions().isEmpty() ? this.routeByMixedConditionsWithHint(shardingRule, tableRule) : this.routeByMixedConditionsWithCondition(shardingRule, tableRule);
    }

    private Collection<DataNode> routeByMixedConditionsWithCondition(ShardingRule shardingRule, TableRule tableRule) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (ShardingCondition each : this.shardingConditions.getConditions()) {
            Collection<DataNode> dataNodes = this.route0(shardingRule, tableRule, this.getDatabaseShardingValues(shardingRule, tableRule, each), this.getTableShardingValues(shardingRule, tableRule, each));
            result.addAll(dataNodes);
            this.originalDataNodes.add(dataNodes);
        }
        return result;
    }

    private Collection<DataNode> routeByMixedConditionsWithHint(ShardingRule shardingRule, TableRule tableRule) {
        if (shardingRule.getDatabaseShardingStrategy(tableRule) instanceof HintShardingStrategy) {
            return this.route0(shardingRule, tableRule, this.getDatabaseShardingValuesFromHint(), Collections.emptyList());
        }
        return this.route0(shardingRule, tableRule, Collections.emptyList(), this.getTableShardingValuesFromHint());
    }

    private List<RouteValue> getDatabaseShardingValues(ShardingRule shardingRule, TableRule tableRule, ShardingCondition shardingCondition) {
        ShardingStrategy dataBaseShardingStrategy = shardingRule.getDatabaseShardingStrategy(tableRule);
        return this.isGettingShardingValuesFromHint(dataBaseShardingStrategy) ? this.getDatabaseShardingValuesFromHint() : this.getShardingValuesFromShardingConditions(shardingRule, dataBaseShardingStrategy.getShardingColumns(), shardingCondition);
    }

    private List<RouteValue> getTableShardingValues(ShardingRule shardingRule, TableRule tableRule, ShardingCondition shardingCondition) {
        ShardingStrategy tableShardingStrategy = shardingRule.getTableShardingStrategy(tableRule);
        return this.isGettingShardingValuesFromHint(tableShardingStrategy) ? this.getTableShardingValuesFromHint() : this.getShardingValuesFromShardingConditions(shardingRule, tableShardingStrategy.getShardingColumns(), shardingCondition);
    }

    private boolean isGettingShardingValuesFromHint(ShardingStrategy shardingStrategy) {
        return shardingStrategy instanceof HintShardingStrategy;
    }

    private List<RouteValue> getDatabaseShardingValuesFromHint() {
        return this.getRouteValues(HintManager.isDatabaseShardingOnly() ? HintManager.getDatabaseShardingValues() : HintManager.getDatabaseShardingValues((String)this.logicTableName));
    }

    private List<RouteValue> getTableShardingValuesFromHint() {
        return this.getRouteValues(HintManager.getTableShardingValues((String)this.logicTableName));
    }

    private List<RouteValue> getRouteValues(Collection<Comparable<?>> shardingValue) {
        return shardingValue.isEmpty() ? Collections.emptyList() : Collections.singletonList(new ListRouteValue("", this.logicTableName, shardingValue));
    }

    private List<RouteValue> getShardingValuesFromShardingConditions(ShardingRule shardingRule, Collection<String> shardingColumns, ShardingCondition shardingCondition) {
        ArrayList<RouteValue> result = new ArrayList<RouteValue>(shardingColumns.size());
        for (RouteValue each : shardingCondition.getRouteValues()) {
            Optional bindingTableRule = shardingRule.findBindingTableRule(this.logicTableName);
            if (!this.logicTableName.equals(each.getTableName()) && (!bindingTableRule.isPresent() || !((BindingTableRule)bindingTableRule.get()).hasLogicTable(this.logicTableName)) || !shardingColumns.contains(each.getColumnName())) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<DataNode> route0(ShardingRule shardingRule, TableRule tableRule, List<RouteValue> databaseShardingValues, List<RouteValue> tableShardingValues) {
        Collection<String> routedDataSources = this.routeDataSources(shardingRule, tableRule, databaseShardingValues);
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedDataSources) {
            result.addAll(this.routeTables(shardingRule, tableRule, each, tableShardingValues));
        }
        return result;
    }

    private Collection<String> routeDataSources(ShardingRule shardingRule, TableRule tableRule, List<RouteValue> databaseShardingValues) {
        if (databaseShardingValues.isEmpty()) {
            return tableRule.getActualDatasourceNames();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(shardingRule.getDatabaseShardingStrategy(tableRule).doSharding(tableRule.getActualDatasourceNames(), databaseShardingValues, this.properties));
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        Preconditions.checkState((boolean)tableRule.getActualDatasourceNames().containsAll(result), (String)"Some routed data sources do not belong to configured data sources. routed data sources: `%s`, configured data sources: `%s`", (Object[])new Object[]{result, tableRule.getActualDatasourceNames()});
        return result;
    }

    private Collection<DataNode> routeTables(ShardingRule shardingRule, TableRule tableRule, String routedDataSource, List<RouteValue> tableShardingValues) {
        Collection availableTargetTables = tableRule.getActualTableNames(routedDataSource);
        LinkedHashSet routedTables = new LinkedHashSet(tableShardingValues.isEmpty() ? availableTargetTables : shardingRule.getTableShardingStrategy(tableRule).doSharding(availableTargetTables, tableShardingValues, this.properties));
        Preconditions.checkState((!routedTables.isEmpty() ? 1 : 0) != 0, (Object)"no table route info");
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedTables) {
            result.add(new DataNode(routedDataSource, each));
        }
        return result;
    }

    @Generated
    public ShardingStandardRoutingEngine(String logicTableName, SQLStatementContext sqlStatementContext, ShardingConditions shardingConditions, ConfigurationProperties properties) {
        this.logicTableName = logicTableName;
        this.sqlStatementContext = sqlStatementContext;
        this.shardingConditions = shardingConditions;
        this.properties = properties;
    }
}

