/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.qiniu.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import cn.hutool.json.JSONUtil;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsDateUtils;
import org.dromara.sms4j.qiniu.config.QiNiuConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QiNiuUtils {
    private static final Logger log = LoggerFactory.getLogger(QiNiuUtils.class);
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String getSignature(String method, String url, QiNiuConfig qiNiuConfig, String body, String signDate) {
        URI reqUrl = URI.create(url);
        StringBuilder dataToSign = new StringBuilder();
        dataToSign.append(method.toUpperCase()).append(" ").append(reqUrl.getPath());
        dataToSign.append("\nHost: ").append(reqUrl.getHost());
        dataToSign.append("\n").append("Content-Type").append(": ").append("application/json");
        dataToSign.append("\n").append("X-Qiniu-Date").append(": ").append(signDate);
        dataToSign.append("\n\n");
        if (ObjectUtil.isNotEmpty((Object)body)) {
            dataToSign.append(body);
        }
        HMac hMac = new HMac(HmacAlgorithm.HmacSHA1, qiNiuConfig.getAccessKeySecret().getBytes(StandardCharsets.UTF_8));
        byte[] signData = hMac.digest(dataToSign.toString().getBytes(StandardCharsets.UTF_8));
        String encodedSignature = Base64.getEncoder().encodeToString(signData);
        return "Qiniu " + qiNiuConfig.getAccessKeyId() + ":" + encodedSignature;
    }

    public static Map<String, String> getHeaderAndSign(String url, HashMap<String, Object> hashMap, QiNiuConfig qiNiuConfig) {
        String signature;
        String signDate = SmsDateUtils.pureDateUtcGmt((Date)new Date());
        try {
            signature = QiNiuUtils.getSignature("POST", url, qiNiuConfig, JSONUtil.toJsonStr(hashMap), signDate);
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new SmsBlendException(e.getMessage());
        }
        HashMap<String, String> header = new HashMap<String, String>(3);
        header.put("Authorization", signature);
        header.put("X-Qiniu-Date", signDate);
        header.put("Content-Type", "application/json");
        return header;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QiNiuUtils)) {
            return false;
        }
        QiNiuUtils other = (QiNiuUtils)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof QiNiuUtils;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "QiNiuUtils()";
    }
}

