/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.dromara.x.file.storage.core.Downloader;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.aspect.DeleteAspectChain;
import org.dromara.x.file.storage.core.aspect.ExistsAspectChain;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.InvokeAspectChain;
import org.dromara.x.file.storage.core.aspect.IsSupportAclAspectChain;
import org.dromara.x.file.storage.core.aspect.IsSupportListFilesAspectChain;
import org.dromara.x.file.storage.core.aspect.IsSupportMetadataAspectChain;
import org.dromara.x.file.storage.core.aspect.IsSupportMultipartUploadAspectChain;
import org.dromara.x.file.storage.core.aspect.IsSupportPresignedUrlAspectChain;
import org.dromara.x.file.storage.core.aspect.IsSupportSameCopyAspectChain;
import org.dromara.x.file.storage.core.aspect.IsSupportSameMoveAspectChain;
import org.dromara.x.file.storage.core.aspect.SetFileAclAspectChain;
import org.dromara.x.file.storage.core.aspect.SetThFileAclAspectChain;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.file.FileWrapperAdapter;
import org.dromara.x.file.storage.core.file.HttpServletRequestFileWrapper;
import org.dromara.x.file.storage.core.file.MultipartFormDataReader;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;
import org.dromara.x.file.storage.core.recorder.FileRecorder;
import org.dromara.x.file.storage.core.tika.ContentTypeDetect;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.upload.UploadPretreatment;
import org.dromara.x.file.storage.core.util.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStorageService {
    private static final Logger log = LoggerFactory.getLogger(FileStorageService.class);
    private FileStorageService self;
    private FileStorageProperties properties;
    private FileRecorder fileRecorder;
    private CopyOnWriteArrayList<FileStorage> fileStorageList;
    private CopyOnWriteArrayList<FileStorageAspect> aspectList;
    private CopyOnWriteArrayList<FileWrapperAdapter> fileWrapperAdapterList;
    private ContentTypeDetect contentTypeDetect;

    @Deprecated
    public String getDefaultPlatform() {
        return this.properties.getDefaultPlatform();
    }

    @Deprecated
    public String getThumbnailSuffix() {
        return this.properties.getThumbnailSuffix();
    }

    public <T extends FileStorage> T getFileStorage() {
        return this.self.getFileStorage(this.properties.getDefaultPlatform());
    }

    public <T extends FileStorage> T getFileStorage(String platform) {
        for (FileStorage fileStorage : this.fileStorageList) {
            if (!fileStorage.getPlatform().equals(platform)) continue;
            return (T)((FileStorage)Tools.cast(fileStorage));
        }
        return null;
    }

    public <T extends FileStorage> T getFileStorageVerify(FileInfo fileInfo) {
        return this.self.getFileStorageVerify(fileInfo.getPlatform());
    }

    public <T extends FileStorage> T getFileStorageVerify(String platform) {
        T fileStorage = this.self.getFileStorage(platform);
        if (fileStorage == null) {
            throw new FileStorageRuntimeException(StrUtil.format((CharSequence)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b58\u50a8\u5e73\u53f0\uff01platform:{}", (Object[])new Object[]{platform}));
        }
        return fileStorage;
    }

    @Deprecated
    public FileInfo upload(UploadPretreatment pre) {
        return pre.upload();
    }

    public FileInfo getFileInfoByUrl(String url) {
        return this.fileRecorder.getByUrl(url);
    }

    public boolean delete(String url) {
        return this.self.delete(this.getFileInfoByUrl(url));
    }

    public boolean delete(String url, Predicate<FileInfo> predicate) {
        return this.self.delete(this.getFileInfoByUrl(url), predicate);
    }

    public boolean delete(FileInfo fileInfo) {
        return this.self.delete(fileInfo, null);
    }

    public boolean delete(FileInfo fileInfo, Predicate<FileInfo> predicate) {
        if (fileInfo == null) {
            return true;
        }
        if (predicate != null && !predicate.test(fileInfo)) {
            return false;
        }
        Object fileStorage = this.self.getFileStorage(fileInfo.getPlatform());
        if (fileStorage == null) {
            throw new FileStorageRuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b58\u50a8\u5e73\u53f0\uff01");
        }
        return this.self.delete(fileInfo, (FileStorage)fileStorage, this.fileRecorder, (List<FileStorageAspect>)this.aspectList);
    }

    public boolean delete(FileInfo fileInfo, FileStorage fileStorage, FileRecorder fileRecorder, List<FileStorageAspect> aspectList) {
        return new DeleteAspectChain(aspectList, (_fileInfo, _fileStorage, _fileRecorder) -> {
            if (_fileStorage.delete(_fileInfo)) {
                return _fileRecorder.delete(_fileInfo.getUrl());
            }
            return false;
        }).next(fileInfo, fileStorage, fileRecorder);
    }

    public boolean exists(String url) {
        return this.self.exists(this.getFileInfoByUrl(url));
    }

    public boolean exists(FileInfo fileInfo) {
        if (fileInfo == null) {
            return false;
        }
        return new ExistsAspectChain(this.aspectList, (_fileInfo, _fileStorage) -> _fileStorage.exists(_fileInfo)).next(fileInfo, (FileStorage)this.getFileStorageVerify(fileInfo));
    }

    public Downloader download(FileInfo fileInfo) {
        return new Downloader(fileInfo, (List<FileStorageAspect>)this.aspectList, (FileStorage)this.getFileStorageVerify(fileInfo), 1);
    }

    public Downloader download(String url) {
        return this.self.download(this.getFileInfoByUrl(url));
    }

    public Downloader downloadTh(FileInfo fileInfo) {
        return new Downloader(fileInfo, (List<FileStorageAspect>)this.aspectList, (FileStorage)this.getFileStorageVerify(fileInfo), 2);
    }

    public Downloader downloadTh(String url) {
        return this.self.downloadTh(this.getFileInfoByUrl(url));
    }

    public boolean isSupportPresignedUrl() {
        return this.self.isSupportPresignedUrl(this.properties.getDefaultPlatform());
    }

    public boolean isSupportPresignedUrl(String platform) {
        Object storage = this.self.getFileStorageVerify(platform);
        return this.self.isSupportPresignedUrl((FileStorage)storage);
    }

    public boolean isSupportPresignedUrl(FileStorage fileStorage) {
        if (fileStorage == null) {
            return false;
        }
        return new IsSupportPresignedUrlAspectChain(this.aspectList, FileStorage::isSupportPresignedUrl).next(fileStorage);
    }

    public GeneratePresignedUrlPretreatment generatePresignedUrl() {
        return new GeneratePresignedUrlPretreatment().setFileStorageService(this.self).setPlatform(this.properties.getDefaultPlatform());
    }

    public String generatePresignedUrl(FileInfo fileInfo, Date expiration) {
        if (fileInfo == null) {
            return null;
        }
        GeneratePresignedUrlResult result = this.generatePresignedUrl().setExpiration(expiration).setPath(fileInfo.getPath()).setFilename(fileInfo.getFilename()).setMethod("GET").generatePresignedUrl();
        return result == null ? null : result.getUrl();
    }

    public String generateThPresignedUrl(FileInfo fileInfo, Date expiration) {
        if (fileInfo == null) {
            return null;
        }
        GeneratePresignedUrlResult result = this.generatePresignedUrl().setExpiration(expiration).setPath(fileInfo.getPath()).setFilename(fileInfo.getThFilename()).setMethod("GET").generatePresignedUrl();
        return result == null ? null : result.getUrl();
    }

    public boolean isSupportAcl() {
        return this.self.isSupportAcl(this.properties.getDefaultPlatform());
    }

    public boolean isSupportAcl(String platform) {
        Object storage = this.self.getFileStorageVerify(platform);
        return this.self.isSupportAcl((FileStorage)storage);
    }

    public boolean isSupportAcl(FileStorage fileStorage) {
        if (fileStorage == null) {
            return false;
        }
        return new IsSupportAclAspectChain(this.aspectList, FileStorage::isSupportAcl).next(fileStorage);
    }

    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        if (fileInfo == null) {
            return false;
        }
        return new SetFileAclAspectChain(this.aspectList, (_fileInfo, _acl, _fileStorage) -> _fileStorage.setFileAcl(_fileInfo, _acl)).next(fileInfo, acl, (FileStorage)this.self.getFileStorageVerify(fileInfo));
    }

    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        if (fileInfo == null) {
            return false;
        }
        return new SetThFileAclAspectChain(this.aspectList, (_fileInfo, _acl, _fileStorage) -> _fileStorage.setThFileAcl(_fileInfo, _acl)).next(fileInfo, acl, (FileStorage)this.self.getFileStorageVerify(fileInfo));
    }

    public boolean isSupportMetadata() {
        return this.self.isSupportMetadata(this.properties.getDefaultPlatform());
    }

    public boolean isSupportMetadata(String platform) {
        Object storage = this.self.getFileStorageVerify(platform);
        return this.self.isSupportMetadata((FileStorage)storage);
    }

    public boolean isSupportMetadata(FileStorage fileStorage) {
        if (fileStorage == null) {
            return false;
        }
        return new IsSupportMetadataAspectChain(this.aspectList, FileStorage::isSupportMetadata).next(fileStorage);
    }

    public UploadPretreatment of() {
        UploadPretreatment pre = new UploadPretreatment();
        pre.setFileStorageService(this.self);
        pre.setPlatform(this.properties.getDefaultPlatform());
        pre.setThumbnailSuffix(this.properties.getThumbnailSuffix());
        pre.setNotSupportMetadataThrowException(this.properties.getUploadNotSupportMetadataThrowException());
        pre.setNotSupportAclThrowException(this.properties.getUploadNotSupportAclThrowException());
        return pre;
    }

    public UploadPretreatment of(Object source) {
        return this.self.of(source, null, null);
    }

    public UploadPretreatment of(Object source, String name) {
        return this.self.of(source, name, null);
    }

    public UploadPretreatment of(Object source, String name, String contentType) {
        return this.self.of(source, name, contentType, null);
    }

    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return this.self.isSupportMultipartUpload(this.properties.getDefaultPlatform());
    }

    public MultipartUploadSupportInfo isSupportMultipartUpload(String platform) {
        Object storage = this.self.getFileStorageVerify(platform);
        return this.self.isSupportMultipartUpload((FileStorage)storage);
    }

    public MultipartUploadSupportInfo isSupportMultipartUpload(FileStorage fileStorage) {
        if (fileStorage == null) {
            return MultipartUploadSupportInfo.notSupport();
        }
        return new IsSupportMultipartUploadAspectChain(this.aspectList, FileStorage::isSupportMultipartUpload).next(fileStorage);
    }

    public InitiateMultipartUploadPretreatment initiateMultipartUpload() {
        InitiateMultipartUploadPretreatment pre = new InitiateMultipartUploadPretreatment();
        pre.setFileStorageService(this.self);
        pre.setPlatform(this.properties.getDefaultPlatform());
        pre.setNotSupportMetadataThrowException(this.properties.getUploadNotSupportMetadataThrowException());
        pre.setNotSupportAclThrowException(this.properties.getUploadNotSupportAclThrowException());
        return pre;
    }

    public UploadPartPretreatment uploadPart(FileInfo fileInfo, int partNumber, Object source) {
        return this.self.uploadPart(fileInfo, partNumber, source, null);
    }

    public UploadPartPretreatment uploadPart(FileInfo fileInfo, int partNumber, Object source, Long size) {
        UploadPartPretreatment pre = new UploadPartPretreatment();
        pre.setFileStorageService(this.self);
        pre.setFileInfo(fileInfo);
        pre.setPartNumber(partNumber);
        if (source instanceof FileWrapper) {
            pre.setPartFileWrapper((FileWrapper)source);
        } else {
            pre.setPartFileWrapper(this.self.wrapper(source, null, "application/octet-stream", size));
        }
        return pre;
    }

    public CompleteMultipartUploadPretreatment completeMultipartUpload(FileInfo fileInfo) {
        CompleteMultipartUploadPretreatment pre = new CompleteMultipartUploadPretreatment();
        pre.setFileStorageService(this.self);
        pre.setFileInfo(fileInfo);
        return pre;
    }

    public AbortMultipartUploadPretreatment abortMultipartUpload(FileInfo fileInfo) {
        AbortMultipartUploadPretreatment pre = new AbortMultipartUploadPretreatment();
        pre.setFileStorageService(this.self);
        pre.setFileInfo(fileInfo);
        return pre;
    }

    public ListPartsPretreatment listParts(FileInfo fileInfo) {
        ListPartsPretreatment pre = new ListPartsPretreatment();
        pre.setFileStorageService(this.self);
        pre.setFileInfo(fileInfo);
        return pre;
    }

    public ListFilesSupportInfo isSupportListFiles() {
        return this.self.isSupportListFiles(this.properties.getDefaultPlatform());
    }

    public ListFilesSupportInfo isSupportListFiles(String platform) {
        Object storage = this.self.getFileStorageVerify(platform);
        return this.self.isSupportListFiles((FileStorage)storage);
    }

    public ListFilesSupportInfo isSupportListFiles(FileStorage fileStorage) {
        if (fileStorage == null) {
            return ListFilesSupportInfo.notSupport();
        }
        return new IsSupportListFilesAspectChain(this.aspectList, FileStorage::isSupportListFiles).next(fileStorage);
    }

    public ListFilesPretreatment listFiles() {
        ListFilesPretreatment pre = new ListFilesPretreatment();
        pre.setPlatform(this.properties.getDefaultPlatform());
        pre.setFileStorageService(this.self);
        return pre;
    }

    public GetFilePretreatment getFile() {
        return new GetFilePretreatment().setPlatform(this.properties.getDefaultPlatform()).setFileStorageService(this.self);
    }

    public RemoteFileInfo getFile(FileInfo fileInfo) {
        return this.getFile().setPlatform(fileInfo.getPlatform()).setPath(fileInfo.getPath() != null, fileInfo.getPath()).setFilename(fileInfo.getFilename() != null, fileInfo.getFilename()).setUrl(fileInfo.getUrl() != null, fileInfo.getUrl()).getFile();
    }

    public RemoteFileInfo getThFile(FileInfo fileInfo) {
        return this.getFile().setPlatform(fileInfo.getPlatform()).setPath(fileInfo.getPath() != null, fileInfo.getPath()).setFilename(fileInfo.getThFilename() != null, fileInfo.getThFilename()).setUrl(fileInfo.getThUrl() != null, fileInfo.getThUrl()).getFile();
    }

    public UploadPretreatment of(Object source, String name, String contentType, Long size) {
        MultipartFormDataReader.MultipartFormData data;
        FileWrapper wrapper = this.self.wrapper(source, name, contentType, size);
        UploadPretreatment up = this.self.of().setFileWrapper(wrapper);
        if (wrapper instanceof HttpServletRequestFileWrapper && (data = ((HttpServletRequestFileWrapper)wrapper).getMultipartFormData()).getThFileBytes() != null) {
            FileWrapper thWrapper = this.self.wrapper(data.getThFileBytes(), data.getThFileOriginalFilename(), data.getThFileContentType());
            up.thumbnailOf(thWrapper);
        }
        return up;
    }

    public FileWrapper wrapper(Object source) {
        return this.self.wrapper(source, null);
    }

    public FileWrapper wrapper(Object source, String name) {
        return this.self.wrapper(source, name, null);
    }

    public FileWrapper wrapper(Object source, String name, String contentType) {
        return this.self.wrapper(source, name, contentType, null);
    }

    public FileWrapper wrapper(Object source, String name, String contentType, Long size) {
        if (source == null) {
            throw new FileStorageRuntimeException("\u8981\u5305\u88c5\u7684\u6587\u4ef6\u4e0d\u80fd\u662f null");
        }
        try {
            for (FileWrapperAdapter adapter : this.fileWrapperAdapterList) {
                if (!adapter.isSupport(source)) continue;
                return adapter.getFileWrapper(source, name, contentType, size);
            }
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u5305\u88c5\u5931\u8d25", e);
        }
        throw new FileStorageRuntimeException("\u4e0d\u652f\u6301\u6b64\u6587\u4ef6");
    }

    public boolean isSupportSameCopy() {
        return this.self.isSupportSameCopy(this.properties.getDefaultPlatform());
    }

    public boolean isSupportSameCopy(String platform) {
        Object storage = this.self.getFileStorageVerify(platform);
        return this.self.isSupportSameCopy((FileStorage)storage);
    }

    public boolean isSupportSameCopy(FileStorage fileStorage) {
        if (fileStorage == null) {
            return false;
        }
        return new IsSupportSameCopyAspectChain(this.aspectList, FileStorage::isSupportSameCopy).next(fileStorage);
    }

    public CopyPretreatment copy(FileInfo fileInfo) {
        return new CopyPretreatment(fileInfo, this.self).setNotSupportMetadataThrowException(this.properties.getCopyNotSupportMetadataThrowException()).setNotSupportAclThrowException(this.properties.getCopyNotSupportAclThrowException());
    }

    public CopyPretreatment copy(String url) {
        return this.self.copy(this.self.getFileInfoByUrl(url));
    }

    public boolean isSupportSameMove() {
        return this.self.isSupportSameMove(this.properties.getDefaultPlatform());
    }

    public boolean isSupportSameMove(String platform) {
        Object storage = this.self.getFileStorageVerify(platform);
        return this.self.isSupportSameMove((FileStorage)storage);
    }

    public boolean isSupportSameMove(FileStorage fileStorage) {
        if (fileStorage == null) {
            return false;
        }
        return new IsSupportSameMoveAspectChain(this.aspectList, FileStorage::isSupportSameMove).next(fileStorage);
    }

    public MovePretreatment move(FileInfo fileInfo) {
        return new MovePretreatment(fileInfo, this.self).setNotSupportMetadataThrowException(this.properties.getMoveNotSupportMetadataThrowException()).setNotSupportAclThrowException(this.properties.getMoveNotSupportAclThrowException());
    }

    public MovePretreatment move(String url) {
        return this.self.move(this.self.getFileInfoByUrl(url));
    }

    public <T> T invoke(String platform, String method, Object ... args) {
        return this.self.invoke((FileStorage)this.self.getFileStorageVerify(platform), method, args);
    }

    public <T> T invoke(FileStorage platform, String method, Object ... args) {
        return new InvokeAspectChain(this.aspectList, ReflectUtil::invoke).next(platform, method, args);
    }

    public void destroy() {
        for (FileStorage fileStorage : this.fileStorageList) {
            try {
                fileStorage.close();
                log.info("\u9500\u6bc1\u5b58\u50a8\u5e73\u53f0 {} \u6210\u529f", (Object)fileStorage.getPlatform());
            }
            catch (Exception e) {
                log.error("\u9500\u6bc1\u5b58\u50a8\u5e73\u53f0 {} \u5931\u8d25\uff0c{}", new Object[]{fileStorage.getPlatform(), e.getMessage(), e});
            }
        }
    }

    public FileStorageService getSelf() {
        return this.self;
    }

    public FileStorageProperties getProperties() {
        return this.properties;
    }

    public FileRecorder getFileRecorder() {
        return this.fileRecorder;
    }

    public CopyOnWriteArrayList<FileStorage> getFileStorageList() {
        return this.fileStorageList;
    }

    public CopyOnWriteArrayList<FileStorageAspect> getAspectList() {
        return this.aspectList;
    }

    public CopyOnWriteArrayList<FileWrapperAdapter> getFileWrapperAdapterList() {
        return this.fileWrapperAdapterList;
    }

    public ContentTypeDetect getContentTypeDetect() {
        return this.contentTypeDetect;
    }

    public void setSelf(FileStorageService self) {
        this.self = self;
    }

    public void setProperties(FileStorageProperties properties) {
        this.properties = properties;
    }

    public void setFileRecorder(FileRecorder fileRecorder) {
        this.fileRecorder = fileRecorder;
    }

    public void setFileStorageList(CopyOnWriteArrayList<FileStorage> fileStorageList) {
        this.fileStorageList = fileStorageList;
    }

    public void setAspectList(CopyOnWriteArrayList<FileStorageAspect> aspectList) {
        this.aspectList = aspectList;
    }

    public void setFileWrapperAdapterList(CopyOnWriteArrayList<FileWrapperAdapter> fileWrapperAdapterList) {
        this.fileWrapperAdapterList = fileWrapperAdapterList;
    }

    public void setContentTypeDetect(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }
}

