/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.function.Consumer;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.hash.HashCalculatorManager;

public class InputStreamPlus
extends FilterInputStream {
    protected boolean readFlag;
    protected boolean finishFlag;
    protected long progressSize;
    protected final Long allSize;
    protected final ProgressListener listener;
    protected final HashCalculatorManager hashCalculatorManager;
    protected int markFlag;

    public InputStreamPlus(InputStream in, final Consumer<Long> listener) {
        this(in, new ProgressListener(){

            @Override
            public void start() {
            }

            @Override
            public void progress(long progressSize, Long allSize) {
                listener.accept(progressSize);
            }

            @Override
            public void finish() {
            }
        }, null);
    }

    public InputStreamPlus(InputStream in, ProgressListener listener, Long allSize) {
        this(in, listener, allSize, null);
    }

    public InputStreamPlus(InputStream in, ProgressListener listener, Long allSize, HashCalculatorManager hashCalculatorManager) {
        super(in);
        this.listener = listener;
        this.allSize = allSize;
        this.hashCalculatorManager = hashCalculatorManager;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        this.onProgress(skip);
        return skip;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.onProgress(b == -1 ? -1L : 1L);
        if (this.markFlag == 0 && this.hashCalculatorManager != null && b > -1) {
            this.hashCalculatorManager.update(new byte[]{(byte)b});
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.onStart();
        int bytes = super.read(b, off, len);
        if (this.markFlag == 0 && this.hashCalculatorManager != null && bytes > 0) {
            this.hashCalculatorManager.update(Arrays.copyOfRange(b, off, off + bytes));
        }
        this.onProgress(bytes);
        return bytes;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        ++this.markFlag;
    }

    @Override
    public synchronized void reset() throws IOException {
        super.reset();
        --this.markFlag;
    }

    private void onStart() {
        if (this.markFlag > 0) {
            return;
        }
        if (this.readFlag) {
            return;
        }
        this.readFlag = true;
        if (this.listener != null) {
            this.listener.start();
        }
    }

    protected void onProgress(long size) {
        if (this.markFlag > 0) {
            return;
        }
        if (size > 0L) {
            this.progressSize += size;
            if (this.listener != null) {
                this.listener.progress(this.progressSize, this.allSize);
            }
        } else if (size < 0L) {
            this.onFinish();
        }
    }

    private void onFinish() {
        if (this.markFlag > 0) {
            return;
        }
        if (this.finishFlag) {
            return;
        }
        this.finishFlag = true;
        if (this.listener != null) {
            this.listener.finish();
        }
    }

    public boolean isReadFlag() {
        return this.readFlag;
    }

    public boolean isFinishFlag() {
        return this.finishFlag;
    }

    public long getProgressSize() {
        return this.progressSize;
    }

    public Long getAllSize() {
        return this.allSize;
    }

    public ProgressListener getListener() {
        return this.listener;
    }

    public HashCalculatorManager getHashCalculatorManager() {
        return this.hashCalculatorManager;
    }

    public int getMarkFlag() {
        return this.markFlag;
    }
}

