/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.aspect;

import java.util.Iterator;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.InvokeAspectChainCallback;
import org.dromara.x.file.storage.core.platform.FileStorage;

public class InvokeAspectChain {
    private InvokeAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public InvokeAspectChain(Iterable<FileStorageAspect> aspects, InvokeAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public <T> T next(FileStorage fileStorage, String method, Object[] args) {
        if (this.aspectIterator.hasNext()) {
            return this.aspectIterator.next().invoke(this, fileStorage, method, args);
        }
        return this.callback.run(fileStorage, method, args);
    }

    public InvokeAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(InvokeAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

