/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.aspect;

import java.util.Iterator;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.UploadAspectChainCallback;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;

public class UploadAspectChain {
    private UploadAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public UploadAspectChain(Iterable<FileStorageAspect> aspects, UploadAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public FileInfo next(FileInfo fileInfo, UploadPretreatment pre, FileStorage fileStorage, FileRecorder fileRecorder) {
        if (this.aspectIterator.hasNext()) {
            return this.aspectIterator.next().uploadAround(this, fileInfo, pre, fileStorage, fileRecorder);
        }
        return this.callback.run(fileInfo, pre, fileStorage, fileRecorder);
    }

    public UploadAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(UploadAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

