/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.exception;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;

public class Check {
    public static void uploadNotSupportAcl(String platform, FileInfo fileInfo, UploadPretreatment pre) {
        if (fileInfo.getFileAcl() != null && pre.getNotSupportAclThrowException().booleanValue()) {
            throw ExceptionFactory.uploadNotSupportAcl(fileInfo, platform);
        }
    }

    public static void uploadNotSupportAcl(String platform, FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        if (fileInfo.getFileAcl() != null && pre.getNotSupportAclThrowException().booleanValue()) {
            throw ExceptionFactory.uploadNotSupportAcl(fileInfo, platform);
        }
    }

    public static void uploadNotSupportMetadata(String platform, FileInfo fileInfo, UploadPretreatment pre) {
        if ((CollUtil.isNotEmpty(fileInfo.getMetadata()) || CollUtil.isNotEmpty(fileInfo.getUserMetadata())) && pre.getNotSupportMetadataThrowException().booleanValue()) {
            throw ExceptionFactory.uploadNotSupportMetadata(fileInfo, platform);
        }
    }

    public static void uploadNotSupportMetadata(String platform, FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        if ((CollUtil.isNotEmpty(fileInfo.getMetadata()) || CollUtil.isNotEmpty(fileInfo.getUserMetadata())) && pre.getNotSupportMetadataThrowException().booleanValue()) {
            throw ExceptionFactory.uploadNotSupportMetadata(fileInfo, platform);
        }
    }

    public static void uploadRequireFileSize(String platform, FileInfo fileInfo) {
        if (fileInfo.getSize() == null) {
            throw ExceptionFactory.uploadRequireFileSize(fileInfo, platform);
        }
    }

    public static void initiateMultipartUploadRequireFileSize(String platform, FileInfo fileInfo) {
        if (fileInfo.getSize() == null) {
            throw ExceptionFactory.initiateMultipartUploadRequireFileSize(fileInfo, platform);
        }
    }

    public static void downloadThBlankThFilename(String platform, FileInfo fileInfo) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            throw ExceptionFactory.downloadThNotFound(fileInfo, platform);
        }
    }

    public static void sameCopyNotSupportAcl(String platform, FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        if (srcFileInfo.getFileAcl() != null && pre.getNotSupportAclThrowException().booleanValue()) {
            throw ExceptionFactory.sameCopyNotSupportAcl(srcFileInfo, destFileInfo, platform);
        }
    }

    public static void sameCopyNotSupportMetadata(String platform, FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        if ((CollUtil.isNotEmpty(srcFileInfo.getMetadata()) || CollUtil.isNotEmpty(srcFileInfo.getUserMetadata())) && pre.getNotSupportMetadataThrowException().booleanValue()) {
            throw ExceptionFactory.sameCopyNotSupportMetadata(srcFileInfo, destFileInfo, platform);
        }
    }

    public static void sameCopyBasePath(String platform, String basePath, FileInfo srcFileInfo, FileInfo destFileInfo) {
        if (!basePath.equals(srcFileInfo.getBasePath())) {
            throw ExceptionFactory.sameCopyBasePath(basePath, srcFileInfo, destFileInfo, platform);
        }
    }

    public static void sameMoveNotSupportAcl(String platform, FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
        if (srcFileInfo.getFileAcl() != null && pre.getNotSupportAclThrowException().booleanValue()) {
            throw ExceptionFactory.sameMoveNotSupportAcl(srcFileInfo, destFileInfo, platform);
        }
    }

    public static void sameMoveNotSupportMetadata(String platform, FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
        if ((CollUtil.isNotEmpty(srcFileInfo.getMetadata()) || CollUtil.isNotEmpty(srcFileInfo.getUserMetadata())) && pre.getNotSupportMetadataThrowException().booleanValue()) {
            throw ExceptionFactory.sameMoveNotSupportMetadata(srcFileInfo, destFileInfo, platform);
        }
    }

    public static void sameMoveBasePath(String platform, String basePath, FileInfo srcFileInfo, FileInfo destFileInfo) {
        if (!basePath.equals(srcFileInfo.getBasePath())) {
            throw ExceptionFactory.sameMoveBasePath(basePath, srcFileInfo, destFileInfo, platform);
        }
    }

    public static void uploadPart(FileInfo fileInfo) {
        if (fileInfo == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u4e0a\u4f20\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 fileInfo \u53c2\u6570");
        }
        if (fileInfo.getPlatform() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u4e0a\u4f20\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 platform \u53c2\u6570");
        }
        if (fileInfo.getBasePath() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u4e0a\u4f20\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 basePath \u53c2\u6570");
        }
        if (fileInfo.getPath() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u4e0a\u4f20\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 path \u53c2\u6570");
        }
        if (fileInfo.getFilename() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u4e0a\u4f20\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 filename \u53c2\u6570");
        }
        if (fileInfo.getUploadId() == null) {
            throw new RuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u4e0a\u4f20\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 uploadId \u53c2\u6570");
        }
    }

    public static void completeMultipartUpload(FileInfo fileInfo) {
        if (fileInfo == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5b8c\u6210\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 fileInfo \u53c2\u6570");
        }
        if (fileInfo.getPlatform() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5b8c\u6210\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 platform \u53c2\u6570");
        }
        if (fileInfo.getBasePath() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5b8c\u6210\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 basePath \u53c2\u6570");
        }
        if (fileInfo.getPath() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5b8c\u6210\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 path \u53c2\u6570");
        }
        if (fileInfo.getFilename() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5b8c\u6210\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 filename \u53c2\u6570");
        }
        if (fileInfo.getId() == null && fileInfo.getUrl() == null) {
            throw new RuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5b8c\u6210\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 id \u6216 url \u53c2\u6570");
        }
        if (fileInfo.getUploadId() == null) {
            throw new RuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5b8c\u6210\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 uploadId \u53c2\u6570");
        }
    }

    public static void abortMultipartUpload(FileInfo fileInfo) {
        if (fileInfo == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 fileInfo \u53c2\u6570");
        }
        if (fileInfo.getPlatform() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 platform \u53c2\u6570");
        }
        if (fileInfo.getBasePath() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 basePath \u53c2\u6570");
        }
        if (fileInfo.getPath() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 path \u53c2\u6570");
        }
        if (fileInfo.getFilename() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 filename \u53c2\u6570");
        }
        if (fileInfo.getUrl() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 url \u53c2\u6570");
        }
        if (fileInfo.getUploadId() == null) {
            throw new RuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 uploadId \u53c2\u6570");
        }
    }

    public static void listParts(FileInfo fileInfo) {
        if (fileInfo == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5217\u4e3e\u5df2\u4e0a\u4f20\u7684\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 fileInfo \u53c2\u6570");
        }
        if (fileInfo.getPlatform() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5217\u4e3e\u5df2\u4e0a\u4f20\u7684\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 platform \u53c2\u6570");
        }
        if (fileInfo.getBasePath() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5217\u4e3e\u5df2\u4e0a\u4f20\u7684\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 basePath \u53c2\u6570");
        }
        if (fileInfo.getPath() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5217\u4e3e\u5df2\u4e0a\u4f20\u7684\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 path \u53c2\u6570");
        }
        if (fileInfo.getFilename() == null) {
            throw new FileStorageRuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5217\u4e3e\u5df2\u4e0a\u4f20\u7684\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 filename \u53c2\u6570");
        }
        if (fileInfo.getUploadId() == null) {
            throw new RuntimeException("\u624b\u52a8\u5206\u7247\u4e0a\u4f20-\u5217\u4e3e\u5df2\u4e0a\u4f20\u7684\u5206\u7247\u5931\u8d25\uff0c\u8bf7\u5728 FileInfo \u4e2d\u4f20\u5165 uploadId \u53c2\u6570");
        }
    }

    public static void listFiles(ListFilesPretreatment pre) {
        if (pre.getPlatform() == null) {
            throw new FileStorageRuntimeException("\u5217\u4e3e\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 platform \u53c2\u6570");
        }
        if (pre.getPath() == null) {
            throw new FileStorageRuntimeException("\u5217\u4e3e\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 path \u53c2\u6570");
        }
        if (pre.getFilenamePrefix() == null) {
            throw new FileStorageRuntimeException("\u5217\u4e3e\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 filenamePrefix \u53c2\u6570");
        }
    }

    public static void getFile(GetFilePretreatment pre) {
        if (pre.getPlatform() == null) {
            throw new FileStorageRuntimeException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 platform \u53c2\u6570");
        }
        if (pre.getPath() == null) {
            throw new FileStorageRuntimeException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 path \u53c2\u6570");
        }
        if (pre.getFilename() == null) {
            throw new FileStorageRuntimeException("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f20\u5165 filename \u53c2\u6570");
        }
    }

    public static void generatePresignedUrl(GeneratePresignedUrlPretreatment pre) {
        if (pre.getPlatform() == null) {
            throw new FileStorageRuntimeException("\u751f\u6210\u9884\u7b7e\u540d URL \u5931\u8d25\uff0c\u8bf7\u4f20\u5165 platform \u53c2\u6570");
        }
        if (pre.getExpiration() == null) {
            throw new FileStorageRuntimeException("\u751f\u6210\u9884\u7b7e\u540d URL \u5931\u8d25\uff0c\u8bf7\u4f20\u5165 expiration \u53c2\u6570");
        }
        if (pre.getMethod() == null) {
            throw new FileStorageRuntimeException("\u751f\u6210\u9884\u7b7e\u540d URL \u5931\u8d25\uff0c\u8bf7\u4f20\u5165 method \u53c2\u6570");
        }
    }
}

