/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.exception;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Map;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;

public class ExceptionFactory {
    public static final String UPLOAD_MESSAGE_FORMAT = "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a{}\uff0cfilename\uff1a{}";
    public static final String UPLOAD_NOT_SUPPORT_ACL_MESSAGE_FORMAT = "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u4e0d\u652f\u6301 ALC\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String UPLOAD_NOT_SUPPORT_METADATA_MESSAGE_FORMAT = "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u4e0d\u652f\u6301 Metadata\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String UPLOAD_REQUIRE_SIZE_MESSAGE_FORMAT = "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u9700\u8981\u4f20\u5165\u6587\u4ef6\u5927\u5c0f\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String INITIATE_MULTIPART_UPLOAD_MESSAGE_FORMAT = "\u624b\u52a8\u6587\u4ef6\u5206\u7247\u4e0a\u4f20-\u521d\u59cb\u5316\u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String INITIATE_MULTIPART_UPLOAD_REQUIRE_SIZE_MESSAGE_FORMAT = "\u624b\u52a8\u6587\u4ef6\u5206\u7247\u4e0a\u4f20-\u521d\u59cb\u5316\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u9700\u8981\u4f20\u5165\u6587\u4ef6\u5927\u5c0f\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String INITIATE_MULTIPART_UPLOAD_RECORDER_SAVE_MESSAGE_FORMAT = "\u624b\u52a8\u6587\u4ef6\u5206\u7247\u4e0a\u4f20-\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6587\u4ef6\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String UPLOAD_PART_MESSAGE_FORMAT = "\u624b\u52a8\u6587\u4ef6\u5206\u7247\u4e0a\u4f20-\u4e0a\u4f20\u5206\u7247\u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String COMPLETE_MULTIPART_UPLOAD_MESSAGE_FORMAT = "\u624b\u52a8\u6587\u4ef6\u5206\u7247\u4e0a\u4f20-\u5b8c\u6210\u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String ABORT_MULTIPART_UPLOAD_MESSAGE_FORMAT = "\u624b\u52a8\u6587\u4ef6\u5206\u7247\u4e0a\u4f20-\u53d6\u6d88\u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String LIST_PARTS_MESSAGE_FORMAT = "\u624b\u52a8\u6587\u4ef6\u5206\u7247\u4e0a\u4f20-\u5217\u4e3e\u5df2\u4e0a\u4f20\u7684\u5206\u7247\u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String LIST_FILES_MESSAGE_FORMAT = "\u5217\u4e3e\u6587\u4ef6\u5931\u8d25\uff01platform\uff1a{}\uff0cbasePath\uff1a{}\uff0cpath\uff1a{}\uff0cfilenamePrefix\uff1a{}\uff0cmaxFiles\uff1a{}\uff0cmarker\uff1a{}";
    public static final String GET_FILE_MESSAGE_FORMAT = "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\uff01platform\uff1a{}\uff0cbasePath\uff1a{}\uff0cpath\uff1a{}\uff0cfilename\uff1a{}\uff0curl\uff1a{}";
    public static final String UNRECOGNIZED_ACL_MESSAGE_FORMAT = "\u65e0\u6cd5\u8bc6\u522b\u6b64 ACL\uff01platform\uff1a{}\uff0cACL\uff1a{}";
    public static final String GENERATE_PRESIGNED_URL_MESSAGE_FORMAT = "\u751f\u6210\u9884\u7b7e\u540d URL \u5931\u8d25\uff01{}";
    public static final String GENERATE_TH_PRESIGNED_URL_MESSAGE_FORMAT = "\u5bf9\u7f29\u7565\u56fe\u6587\u4ef6\u751f\u6210\u53ef\u4ee5\u7b7e\u540d\u8bbf\u95ee\u7684 URL \u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}";
    public static final String SET_FILE_ACL_MESSAGE_FORMAT = "\u8bbe\u7f6e\u6587\u4ef6\u7684 ACL \u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}\uff0cACL\uff1a{}";
    public static final String SET_TH_FILE_ACL_MESSAGE_FORMAT = "\u8bbe\u7f6e\u7f29\u7565\u56fe\u6587\u4ef6\u7684 ACL \u5931\u8d25\uff01platform\uff1a{}\uff0cfileInfo\uff1a{}\uff0cACL\uff1a{}";
    public static final String DELETE_MESSAGE_FORMAT = "\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff01platform\uff1a{}\uff0cfilename\uff1a{}";
    public static final String EXISTS_MESSAGE_FORMAT = "\u67e5\u8be2\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01platform\uff1a{}\uff0cfilename\uff1a{}";
    public static final String DOWNLOAD_MESSAGE_FORMAT = "\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a{},fileInfo\uff1a{}";
    public static final String DOWNLOAD_TH_MESSAGE_FORMAT = "\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a{},fileInfo\uff1a{}";
    public static final String DOWNLOAD_TH_NOT_FOUND_MESSAGE_FORMAT = "\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01platform\uff1a{},fileInfo\uff1a{}";
    public static final String SAME_COPY_NOT_SUPPORT_ACL_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u4e0d\u652f\u6301 ALC\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_COPY_NOT_SUPPORT_METADATA_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u4e0d\u652f\u6301 Metadata\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_COPY_BASE_PATH_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6 basePath\uff1a{} \u4e0e\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u7684 basePath\uff1a{} \u4e0d\u540c\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_COPY_NOT_FOUND_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u6e90\u6587\u4ef6\u4fe1\u606f\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_COPY_CREATE_PATH_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u65e0\u6cd5\u521b\u5efa\u76ee\u6807\u8def\u5f84\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_COPY_TH_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff0c\u7f29\u7565\u56fe\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_COPY_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_MOVE_NOT_SUPPORT_ACL_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u4e0d\u652f\u6301 ALC\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_MOVE_NOT_SUPPORT_METADATA_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u4e0d\u652f\u6301 Metadata\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_MOVE_BASE_PATH_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u6e90\u6587\u4ef6 basePath\uff1a{} \u4e0e\u5f53\u524d\u5b58\u50a8\u5e73\u53f0\u7684 basePath\uff1a{} \u4e0d\u540c\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_MOVE_NOT_FOUND_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u6e90\u6587\u4ef6\u4fe1\u606f\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_MOVE_CREATE_PATH_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u65e0\u6cd5\u521b\u5efa\u76ee\u6807\u8def\u5f84\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_MOVE_TH_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff0c\u7f29\u7565\u56fe\u6587\u4ef6\u79fb\u52a8\u5931\u8d25\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";
    public static final String SAME_MOVE_MESSAGE_FORMAT = "\u540c\u5b58\u50a8\u5e73\u53f0\u79fb\u52a8\u6587\u4ef6\u5931\u8d25\uff01platform\uff1a{}\uff0csrcFileInfo\uff1a{}\uff0cdestFileInfo\uff1a{}";

    public static FileStorageRuntimeException upload(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)UPLOAD_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo.getOriginalFilename()}), e);
    }

    public static FileStorageRuntimeException uploadNotSupportAcl(FileInfo fileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)UPLOAD_NOT_SUPPORT_ACL_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}));
    }

    public static FileStorageRuntimeException uploadNotSupportMetadata(FileInfo fileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)UPLOAD_NOT_SUPPORT_METADATA_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}));
    }

    public static FileStorageRuntimeException uploadRequireFileSize(FileInfo fileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)UPLOAD_REQUIRE_SIZE_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}));
    }

    public static FileStorageRuntimeException initiateMultipartUpload(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)INITIATE_MULTIPART_UPLOAD_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException initiateMultipartUploadRequireFileSize(FileInfo fileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)UPLOAD_REQUIRE_SIZE_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}));
    }

    public static FileStorageRuntimeException initiateMultipartUploadRecorderSave(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)INITIATE_MULTIPART_UPLOAD_RECORDER_SAVE_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException uploadPart(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)UPLOAD_PART_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException completeMultipartUpload(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)COMPLETE_MULTIPART_UPLOAD_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException abortMultipartUpload(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)ABORT_MULTIPART_UPLOAD_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException listParts(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)LIST_PARTS_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException listFiles(ListFilesPretreatment pre, String basePath, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)LIST_FILES_MESSAGE_FORMAT, (Object[])new Object[]{pre.getPlatform(), basePath, pre.getPath(), pre.getFilenamePrefix(), pre.getMaxFiles(), pre.getMarker()}), e);
    }

    public static FileStorageRuntimeException getFile(GetFilePretreatment pre, String basePath, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)GET_FILE_MESSAGE_FORMAT, (Object[])new Object[]{pre.getPlatform(), basePath, pre.getPath(), pre.getFilename(), pre.getUrl()}), e);
    }

    public static FileStorageRuntimeException unrecognizedAcl(Object acl, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)UNRECOGNIZED_ACL_MESSAGE_FORMAT, (Object[])new Object[]{platform, acl}));
    }

    public static FileStorageRuntimeException generatePresignedUrl(GeneratePresignedUrlPretreatment pre, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)GENERATE_PRESIGNED_URL_MESSAGE_FORMAT, (Map)BeanUtil.beanToMap((Object)pre, (String[])new String[]{"fileStorageService"})), e);
    }

    public static FileStorageRuntimeException generatePresignedUrl(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)GENERATE_PRESIGNED_URL_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException generateThPresignedUrl(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)GENERATE_TH_PRESIGNED_URL_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException setFileAcl(FileInfo fileInfo, Object acl, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SET_FILE_ACL_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo, acl}), e);
    }

    public static FileStorageRuntimeException setThFileAcl(FileInfo fileInfo, Object acl, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SET_TH_FILE_ACL_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo, acl}), e);
    }

    public static FileStorageRuntimeException delete(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)DELETE_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo.getOriginalFilename()}), e);
    }

    public static FileStorageRuntimeException exists(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)EXISTS_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo.getOriginalFilename()}), e);
    }

    public static FileStorageRuntimeException download(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)DOWNLOAD_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException downloadTh(FileInfo fileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)DOWNLOAD_TH_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}), e);
    }

    public static FileStorageRuntimeException downloadThNotFound(FileInfo fileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)DOWNLOAD_TH_NOT_FOUND_MESSAGE_FORMAT, (Object[])new Object[]{platform, fileInfo}));
    }

    public static FileStorageRuntimeException sameCopyNotSupportAcl(FileInfo srcFileInfo, FileInfo destFileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_COPY_NOT_SUPPORT_ACL_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}));
    }

    public static FileStorageRuntimeException sameCopyNotSupportMetadata(FileInfo srcFileInfo, FileInfo destFileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_COPY_NOT_SUPPORT_METADATA_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}));
    }

    public static FileStorageRuntimeException sameCopyBasePath(String basePath, FileInfo srcFileInfo, FileInfo destFileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_COPY_BASE_PATH_MESSAGE_FORMAT, (Object[])new Object[]{srcFileInfo.getBasePath(), basePath, platform, srcFileInfo, destFileInfo}));
    }

    public static FileStorageRuntimeException sameCopyNotFound(FileInfo srcFileInfo, FileInfo destFileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_COPY_NOT_FOUND_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}), e);
    }

    public static FileStorageRuntimeException sameCopyCreatePath(FileInfo srcFileInfo, FileInfo destFileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_COPY_CREATE_PATH_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}), e);
    }

    public static FileStorageRuntimeException sameCopyTh(FileInfo srcFileInfo, FileInfo destFileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_COPY_TH_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}), e);
    }

    public static FileStorageRuntimeException sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_COPY_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}), e);
    }

    public static FileStorageRuntimeException sameMoveNotSupportAcl(FileInfo srcFileInfo, FileInfo destFileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_MOVE_NOT_SUPPORT_ACL_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}));
    }

    public static FileStorageRuntimeException sameMoveNotSupportMetadata(FileInfo srcFileInfo, FileInfo destFileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_MOVE_NOT_SUPPORT_METADATA_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}));
    }

    public static FileStorageRuntimeException sameMoveBasePath(String basePath, FileInfo srcFileInfo, FileInfo destFileInfo, String platform) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_MOVE_BASE_PATH_MESSAGE_FORMAT, (Object[])new Object[]{srcFileInfo.getBasePath(), basePath, platform, srcFileInfo, destFileInfo}));
    }

    public static FileStorageRuntimeException sameMoveNotFound(FileInfo srcFileInfo, FileInfo destFileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_MOVE_NOT_FOUND_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}), e);
    }

    public static FileStorageRuntimeException sameMoveCreatePath(FileInfo srcFileInfo, FileInfo destFileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_MOVE_CREATE_PATH_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}), e);
    }

    public static FileStorageRuntimeException sameMoveTh(FileInfo srcFileInfo, FileInfo destFileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_MOVE_TH_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}), e);
    }

    public static FileStorageRuntimeException sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, String platform, Exception e) {
        return new FileStorageRuntimeException(StrUtil.format((CharSequence)SAME_MOVE_MESSAGE_FORMAT, (Object[])new Object[]{platform, srcFileInfo, destFileInfo}), e);
    }
}

