/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.file;

import java.io.IOException;
import java.io.InputStream;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.file.FileWrapperAdapter;
import org.dromara.x.file.storage.core.file.InputStreamFileWrapper;
import org.dromara.x.file.storage.core.tika.ContentTypeDetect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamFileWrapperAdapter
implements FileWrapperAdapter {
    private static final Logger log = LoggerFactory.getLogger(InputStreamFileWrapperAdapter.class);
    private ContentTypeDetect contentTypeDetect;

    @Override
    public boolean isSupport(Object source) {
        return source instanceof InputStream || source instanceof InputStreamFileWrapper;
    }

    @Override
    public FileWrapper getFileWrapper(Object source, String name, String contentType, Long size) throws IOException {
        if (source instanceof InputStreamFileWrapper) {
            return this.updateFileWrapper((InputStreamFileWrapper)source, name, contentType, size);
        }
        InputStream inputStream = (InputStream)source;
        if (name == null) {
            name = "";
        }
        InputStreamFileWrapper wrapper = new InputStreamFileWrapper(inputStream, name, contentType, size);
        if (contentType == null) {
            wrapper.getInputStreamMaskReset(in -> wrapper.setContentType(this.contentTypeDetect.detect((InputStream)in, wrapper.getName())));
        }
        return wrapper;
    }

    public ContentTypeDetect getContentTypeDetect() {
        return this.contentTypeDetect;
    }

    public void setContentTypeDetect(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }

    public InputStreamFileWrapperAdapter() {
    }

    public InputStreamFileWrapperAdapter(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }
}

