/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.file.FileWrapperAdapter;
import org.dromara.x.file.storage.core.file.HttpServletRequestFileWrapper;
import org.dromara.x.file.storage.core.file.MultipartFormDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxHttpServletRequestFileWrapperAdapter
implements FileWrapperAdapter {
    private static final Logger log = LoggerFactory.getLogger(JavaxHttpServletRequestFileWrapperAdapter.class);

    @Override
    public boolean isSupport(Object source) {
        if (source instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)source;
            String contentType = request.getContentType();
            return contentType != null && contentType.toLowerCase().trim().startsWith("multipart/form-data");
        }
        return source instanceof HttpServletRequestFileWrapper;
    }

    @Override
    public FileWrapper getFileWrapper(Object source, String name, String contentType, Long size) throws IOException {
        if (source instanceof HttpServletRequestFileWrapper) {
            return this.updateFileWrapper((HttpServletRequestFileWrapper)source, name, contentType, size);
        }
        HttpServletRequest request = (HttpServletRequest)source;
        Charset charset = Charset.forName(request.getCharacterEncoding());
        MultipartFormDataReader.MultipartFormData data = MultipartFormDataReader.read(request.getContentType(), (InputStream)request.getInputStream(), charset, request.getContentLengthLong());
        if (name == null) {
            name = data.getFileOriginalFilename();
        }
        if (contentType == null) {
            contentType = data.getFileContentType();
        }
        if (size == null) {
            size = data.getFileSize();
        }
        return new HttpServletRequestFileWrapper(data.getInputStream(), name, contentType, size, data);
    }
}

