/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.get;

import java.util.HashMap;
import java.util.List;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.GetFileAspectChain;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.platform.FileStorage;

public class GetFileActuator {
    private final FileStorageService fileStorageService;
    private final GetFilePretreatment pre;

    public GetFileActuator(GetFilePretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public RemoteFileInfo execute() {
        return this.execute((FileStorage)this.fileStorageService.getFileStorageVerify(this.pre.getPlatform()), (List<FileStorageAspect>)this.fileStorageService.getAspectList());
    }

    public RemoteFileInfo execute(FileStorage fileStorage, List<FileStorageAspect> aspectList) {
        Check.getFile(this.pre);
        return new GetFileAspectChain(aspectList, (_pre, _fileStorage) -> {
            RemoteFileInfo info = _fileStorage.getFile(_pre);
            if (info != null) {
                if (info.getMetadata() == null) {
                    info.setMetadata(new HashMap<String, Object>());
                }
                if (info.getUserMetadata() == null) {
                    info.setUserMetadata(new HashMap<String, Object>());
                }
            }
            return info;
        }).next(this.pre, fileStorage);
    }
}

