/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.get;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.ListFilesAspectChain;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.platform.FileStorage;

public class ListFilesActuator {
    private final FileStorageService fileStorageService;
    private final ListFilesPretreatment pre;

    public ListFilesActuator(ListFilesPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public ListFilesResult execute() {
        return this.execute((FileStorage)this.fileStorageService.getFileStorageVerify(this.pre.getPlatform()), (List<FileStorageAspect>)this.fileStorageService.getAspectList());
    }

    public ListFilesResult execute(FileStorage fileStorage, List<FileStorageAspect> aspectList) {
        Check.listFiles(this.pre);
        return new ListFilesAspectChain(aspectList, (_pre, _fileStorage) -> {
            ListFilesResult result;
            _pre = new ListFilesPretreatment(_pre);
            ListFilesSupportInfo supportInfo = this.fileStorageService.isSupportListFiles(_fileStorage);
            Integer supportMaxFiles = supportInfo.getSupportMaxFiles();
            if (_pre.getMaxFiles() == null || _pre.getMaxFiles() < 1) {
                _pre.setMaxFiles(supportMaxFiles);
            }
            if (supportMaxFiles == null || _pre.getMaxFiles() <= supportMaxFiles) {
                result = _fileStorage.listFiles(_pre);
            } else {
                ListFilesResult tempList;
                result = new ListFilesResult();
                result.setDirList(new ArrayList<RemoteDirInfo>());
                result.setFileList(new ArrayList<RemoteFileInfo>());
                result.setPlatform(_pre.getPlatform());
                result.setPath(_pre.getPath());
                result.setFilenamePrefix(_pre.getFilenamePrefix());
                result.setMaxFiles(_pre.getMaxFiles());
                result.setMarker(_pre.getMarker());
                Integer residueFileNum = _pre.getMaxFiles();
                String marker = _pre.getMarker();
                do {
                    ListFilesPretreatment tempPre = new ListFilesPretreatment(_pre);
                    tempPre.setMaxFiles(residueFileNum <= supportMaxFiles ? residueFileNum : supportMaxFiles);
                    tempPre.setMarker(marker);
                    tempList = _fileStorage.listFiles(tempPre);
                    result.getFileList().addAll(tempList.getFileList());
                    result.getDirList().addAll(tempList.getDirList());
                    result.setBasePath(tempList.getBasePath());
                    residueFileNum = residueFileNum - supportMaxFiles;
                    marker = tempList.getNextMarker();
                } while (residueFileNum > 0 && tempList.getIsTruncated().booleanValue());
                result.setNextMarker(tempList.getNextMarker());
                result.setIsTruncated(tempList.getIsTruncated());
            }
            for (RemoteFileInfo info : result.getFileList()) {
                if (info.getMetadata() == null) {
                    info.setMetadata(new HashMap<String, Object>());
                }
                if (info.getUserMetadata() != null) continue;
                info.setUserMetadata(new HashMap<String, Object>());
            }
            return result;
        }).next(this.pre, fileStorage);
    }
}

