/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.util.StrUtil;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class AmazonS3FileStorageClientFactory
implements FileStorageClientFactory<AmazonS3> {
    private String platform;
    private String accessKey;
    private String secretKey;
    private String region;
    private String endPoint;
    private volatile AmazonS3 client;

    public AmazonS3FileStorageClientFactory(FileStorageProperties.AmazonS3Config config) {
        this.platform = config.getPlatform();
        this.accessKey = config.getAccessKey();
        this.secretKey = config.getSecretKey();
        this.region = config.getRegion();
        this.endPoint = config.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonS3 getClient() {
        if (this.client == null) {
            AmazonS3FileStorageClientFactory amazonS3FileStorageClientFactory = this;
            synchronized (amazonS3FileStorageClientFactory) {
                if (this.client == null) {
                    AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey)));
                    if (StrUtil.isNotBlank((CharSequence)this.endPoint)) {
                        builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endPoint, this.region));
                    } else if (StrUtil.isNotBlank((CharSequence)this.region)) {
                        builder.withRegion(this.region);
                    }
                    this.client = (AmazonS3)builder.build();
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setClient(AmazonS3 client) {
        this.client = client;
    }

    public AmazonS3FileStorageClientFactory() {
    }
}

