/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.SyncPoller;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.implementation.models.BlobItemPropertiesInternal;
import com.azure.storage.blob.implementation.models.ListBlobsHierarchySegmentResponse;
import com.azure.storage.blob.models.BlobCopyInfo;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import com.azure.storage.blob.options.BlockBlobCommitBlockListOptions;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.PathAccessControlEntry;
import com.azure.storage.file.datalake.models.PathPermissions;
import com.azure.storage.file.datalake.models.RolePermissions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.platform.AzureBlobStorageFileStorageClientFactory;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.KebabCaseInsensitiveMap;
import org.dromara.x.file.storage.core.util.Tools;
import reactor.core.publisher.Mono;

public class AzureBlobStorageFileStorage
implements FileStorage {
    private String platform;
    private String containerName;
    private String domain;
    private String basePath;
    private String defaultAcl;
    private Long multipartThreshold;
    private Long multipartPartSize;
    private Integer maxConcurrency;
    private CaseInsensitiveMap<String, String> methodToPermissionMap;
    private FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> clientFactory;

    public AzureBlobStorageFileStorage(FileStorageProperties.AzureBlobStorageConfig config, FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> clientFactory) {
        this.platform = config.getPlatform();
        this.containerName = config.getContainerName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.defaultAcl = config.getDefaultAcl();
        this.multipartThreshold = config.getMultipartThreshold();
        this.multipartPartSize = config.getMultipartPartSize();
        this.maxConcurrency = config.getMaxConcurrency();
        this.methodToPermissionMap = new CaseInsensitiveMap(config.getMethodToPermissionMap());
        this.clientFactory = clientFactory;
    }

    public AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient getClient() {
        return this.clientFactory.getClient();
    }

    public BlobContainerClient getBlobClient() {
        return this.getClient().getBlobServiceClient().getBlobContainerClient(this.containerName);
    }

    public BlobClient getBlobClient(String fileKey) {
        if (StrUtil.isBlank((CharSequence)fileKey)) {
            return null;
        }
        return this.getBlobClient().getBlobClient(fileKey);
    }

    public DataLakeFileClient getDataLakeFileClient(String fileKey) {
        return this.getClient().getDataLakeServiceClient().getFileSystemClient(this.containerName).getFileClient(fileKey);
    }

    public String getUrl(String fileKey) {
        return this.domain + this.containerName + "/" + fileKey;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block16: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.getUrl(newFileKey));
            AclWrapper acl = this.getAcl(fileInfo.getFileAcl());
            ProgressListener listener = pre.getProgressListener();
            BlobClient blobClient = this.getBlobClient(newFileKey);
            BlobClient thBlobClient = null;
            InputStreamPlus in = pre.getInputStreamPlus(false);
            try {
                byte[] thumbnailBytes;
                BlobParallelUploadOptions options = new BlobParallelUploadOptions((InputStream)in);
                options.setMetadata(fileInfo.getUserMetadata());
                options.setHeaders(this.getBlobHttpHeaders(fileInfo.getContentType(), fileInfo.getMetadata()));
                options.setParallelTransferOptions(new ParallelTransferOptions().setBlockSizeLong(this.multipartPartSize).setMaxConcurrency(this.maxConcurrency).setMaxSingleUploadSizeLong(this.multipartThreshold));
                if (listener != null) {
                    options.getParallelTransferOptions().setProgressListener(progressSize -> listener.progress(progressSize, fileInfo.getSize()));
                }
                ProgressListener.quickStart(listener, fileInfo.getSize());
                blobClient.uploadWithResponse(options, null, Context.NONE);
                this.setFileAcl(newFileKey, acl);
                ProgressListener.quickFinish(listener);
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.getUrl(newThFileKey));
                    AclWrapper thAcl = this.getAcl(fileInfo.getThFileAcl());
                    BlobParallelUploadOptions thOptions = new BlobParallelUploadOptions((InputStream)new ByteArrayInputStream(thumbnailBytes));
                    thOptions.setMetadata(fileInfo.getThUserMetadata());
                    thOptions.setHeaders(this.getBlobHttpHeaders(fileInfo.getThContentType(), fileInfo.getThMetadata()));
                    thBlobClient = this.getBlobClient(newThFileKey);
                    thBlobClient.uploadWithResponse(thOptions, null, Context.NONE);
                    this.setFileAcl(newFileKey, thAcl);
                }
                bl = true;
                if (in == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        blobClient.deleteIfExists();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (thBlobClient != null) {
                        try {
                            thBlobClient.deleteIfExists();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll().setListPartsSupportMaxParts(50000);
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.getUrl(newFileKey));
        BlockBlobClient blobClient = this.getBlobClient(this.getFileKey(fileInfo)).getBlockBlobClient();
        try {
            String uploadId = IdUtil.objectId();
            fileInfo.setUploadId(uploadId);
            String blockIdBase64 = Base64.encode((CharSequence)String.format("%06d", 0));
            byte[] bytes = fileInfo.getUploadId().getBytes(StandardCharsets.UTF_8);
            blobClient.stageBlock(blockIdBase64, (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block9: {
            FileInfo fileInfo = pre.getFileInfo();
            BlockBlobClient blobClient = this.getBlobClient(this.getFileKey(fileInfo)).getBlockBlobClient();
            FileWrapper partFileWrapper = pre.getPartFileWrapper();
            Long partSize = partFileWrapper.getSize();
            pre.setHashCalculatorMd5();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                if (partSize == null) {
                    partSize = partFileWrapper.getInputStreamMaskResetReturn(Tools::getSize);
                }
                String blockIdBase64 = Base64.encode((CharSequence)String.format("%06d", pre.getPartNumber()));
                blobClient.stageBlock(blockIdBase64, (InputStream)in, partSize.longValue());
                String etag = pre.getHashCalculatorManager().getHashInfo().getMd5();
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(etag);
                filePartInfo2.setPartNumber(pre.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        AclWrapper acl = this.getAcl(fileInfo.getFileAcl());
        BlockBlobClient client = this.getBlobClient(newFileKey).getBlockBlobClient();
        try {
            List partList = pre.getPartInfoList().stream().sorted(Comparator.comparingInt(FilePartInfo::getPartNumber)).map(p -> Base64.encode((CharSequence)String.format("%06d", p.getPartNumber()))).collect(Collectors.toList());
            BlockBlobCommitBlockListOptions options = new BlockBlobCommitBlockListOptions(partList);
            options.setMetadata(fileInfo.getUserMetadata());
            options.setHeaders(this.getBlobHttpHeaders(fileInfo.getContentType(), fileInfo.getMetadata()));
            this.setFileAcl(newFileKey, acl);
            client.commitBlockListWithResponse(options, null, Context.NONE).getValue();
            if (fileInfo.getSize() == null) {
                fileInfo.setSize(client.getProperties().getBlobSize());
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        try {
            this.getBlobClient(this.getFileKey(fileInfo)).getBlockBlobClient().deleteIfExists();
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        BlockBlobClient client = this.getBlobClient(this.getFileKey(fileInfo)).getBlockBlobClient();
        try {
            BlockList blockList = client.listBlocks(BlockListType.UNCOMMITTED);
            List<FilePartInfo> partList = blockList.getUncommittedBlocks().stream().map(p -> {
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setPartSize(p.getSizeLong());
                filePartInfo.setPartNumber(Integer.parseInt(Base64.decodeStr((CharSequence)p.getName())));
                return filePartInfo;
            }).filter(p -> p.getPartNumber() > pre.getPartNumberMarker()).filter(v -> v.getPartNumber() > 0).sorted(Comparator.comparingInt(FilePartInfo::getPartNumber)).collect(Collectors.toList());
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setMaxParts(pre.getMaxParts());
            list.setPartNumberMarker(pre.getPartNumberMarker());
            if (partList.size() > pre.getMaxParts()) {
                list.setIsTruncated(true);
                partList = partList.subList(0, pre.getMaxParts());
                list.setNextPartNumberMarker(partList.get(partList.size() - 1).getPartNumber());
            } else {
                list.setIsTruncated(false);
            }
            list.setList(partList);
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll().setSupportMaxFiles(5000);
    }

    public ListBlobsHierarchySegmentResponse listFiles(BlobContainerClient client, String marker, String delimiter, ListBlobsOptions options, Duration timeout) throws ExecutionException, InterruptedException {
        BlobContainerAsyncClient asyncClient = (BlobContainerAsyncClient)ReflectUtil.getFieldValue((Object)client, (String)"client");
        Method method = ReflectUtil.getMethodByName(asyncClient.getClass(), (String)"listBlobsHierarchySegment");
        Mono result = (Mono)ReflectUtil.invoke((Object)asyncClient, (Method)method, (Object[])new Object[]{marker, delimiter, options, timeout});
        return (ListBlobsHierarchySegmentResponse)Objects.requireNonNull((ResponseBase)result.block()).getValue();
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        BlobContainerClient client = this.getBlobClient();
        try {
            ListBlobsOptions options = new ListBlobsOptions().setPrefix(this.basePath + pre.getPath() + pre.getFilenamePrefix()).setMaxResultsPerPage(pre.getMaxFiles()).setDetails(new BlobListDetails().setRetrieveMetadata(true));
            ListBlobsHierarchySegmentResponse result = this.listFiles(client, pre.getMarker(), "/", options, null);
            ListFilesResult list = new ListFilesResult();
            list.setDirList(result.getSegment().getBlobPrefixes().stream().map(item -> {
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(FileNameUtil.getName((String)item.getName().getContent()));
                dir.setOriginal(item);
                return dir;
            }).collect(Collectors.toList()));
            list.setFileList(result.getSegment().getBlobItems().stream().map(item -> {
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(FileNameUtil.getName((String)item.getName().getContent()));
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                BlobItemPropertiesInternal properties = item.getProperties();
                info.setSize(properties.getContentLength());
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setContentDisposition(properties.getContentDisposition());
                info.setETag(properties.getETag());
                info.setContentType(properties.getContentType());
                info.setContentMd5(Base64.encode((byte[])properties.getContentMd5()));
                info.setLastModified((Date)DateUtil.date((TemporalAccessor)properties.getLastModified()));
                try {
                    info.setMetadata(BeanUtil.beanToMap((Object)properties, (boolean)false, (boolean)true));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (item.getMetadata() != null) {
                    info.setUserMetadata(new HashMap<String, Object>(item.getMetadata()));
                }
                info.setOriginal(item);
                return info;
            }).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(result.getMaxResults());
            list.setIsTruncated(StrUtil.isNotBlank((CharSequence)result.getNextMarker()));
            list.setMarker(result.getMarker());
            list.setNextMarker(result.getNextMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        try {
            BlobProperties file;
            BlobClient client = this.getBlobClient(fileKey);
            try {
                file = client.getProperties();
            }
            catch (Exception e) {
                return null;
            }
            if (file == null) {
                return null;
            }
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(FileNameUtil.getName((String)client.getBlobName()));
            info.setUrl(this.domain + fileKey);
            info.setSize(file.getBlobSize());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setETag(file.getETag());
            info.setContentDisposition(file.getContentDisposition());
            info.setContentType(file.getContentType());
            info.setContentMd5(Base64.encode((byte[])file.getContentMd5()));
            info.setLastModified((Date)DateUtil.date((TemporalAccessor)file.getLastModified()));
            try {
                info.setMetadata(BeanUtil.beanToMap((Object)ReflectUtil.getFieldValue((Object)ReflectUtil.getFieldValue((Object)file, (String)"internalProperties"), (String)"headers"), (boolean)false, (boolean)true));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file.getMetadata() != null) {
                info.setUserMetadata(new HashMap<String, Object>(file.getMetadata()));
            }
            info.setOriginal(file);
            return info;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
    }

    @Override
    public boolean isSupportAcl() {
        return true;
    }

    public AclWrapper getAcl(Object acl) {
        if (acl instanceof PathPermissions) {
            return new AclWrapper((PathPermissions)acl);
        }
        if (acl instanceof String || acl == null) {
            String sAcl = (String)acl;
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                sAcl = this.defaultAcl;
            }
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                return null;
            }
            if ("private".equalsIgnoreCase(sAcl)) {
                return new AclWrapper(new PathPermissions().setGroup(new RolePermissions().setReadPermission(true)).setOwner(new RolePermissions().setReadPermission(true).setWritePermission(true)));
            }
            if ("public-read".equalsIgnoreCase(sAcl)) {
                return new AclWrapper(new PathPermissions().setGroup(new RolePermissions().setReadPermission(true)).setOwner(new RolePermissions().setReadPermission(true).setWritePermission(true)).setOther(new RolePermissions().setReadPermission(true)));
            }
            if ("public-read-write".equalsIgnoreCase(sAcl)) {
                return new AclWrapper(new PathPermissions().setGroup(new RolePermissions().setReadPermission(true).setWritePermission(true)).setOwner(new RolePermissions().setReadPermission(true).setWritePermission(true)).setOther(new RolePermissions().setReadPermission(true).setWritePermission(true)));
            }
        } else {
            if (acl instanceof PathAccessControlEntry) {
                return new AclWrapper(Collections.singletonList((PathAccessControlEntry)acl));
            }
            if (acl instanceof Collection) {
                List<PathAccessControlEntry> aclList = ((Collection)acl).stream().map(item -> {
                    if (item instanceof PathAccessControlEntry) {
                        return (PathAccessControlEntry)item;
                    }
                    throw new FileStorageRuntimeException("\u4e0d\u652f\u6301\u7684ACL\uff1a" + item);
                }).collect(Collectors.toList());
                return new AclWrapper(aclList);
            }
        }
        throw ExceptionFactory.unrecognizedAcl(acl, this.platform);
    }

    public void setFileAcl(String fileKey, AclWrapper acl) {
        if (acl == null) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)fileKey)) {
            return;
        }
        DataLakeFileClient fileClient = this.getDataLakeFileClient(fileKey);
        if (acl.getPermissions() != null) {
            fileClient.setPermissions(acl.getPermissions(), null, null);
        } else if (acl.getAclList() != null) {
            fileClient.setAccessControlList(acl.getAclList(), null, null);
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        AclWrapper oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            this.setFileAcl(this.getFileKey(fileInfo), oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        AclWrapper oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            this.setFileAcl(this.getThFileKey(fileInfo), oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setThFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    public BlobHttpHeaders getBlobHttpHeaders(String contentType, Map<String, String> metadata) {
        BlobHttpHeaders headers = new BlobHttpHeaders();
        if (StrUtil.isNotBlank((CharSequence)contentType)) {
            headers.setContentType(contentType);
        }
        if (CollUtil.isNotEmpty(metadata)) {
            CopyOptions copyOptions = CopyOptions.create().ignoreCase().setFieldNameEditor(name -> NamingCase.toCamelCase((CharSequence)name, (char)'-'));
            BeanUtil.copyProperties(metadata, (Object)headers, (CopyOptions)copyOptions);
        }
        return headers;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        try {
            if (fileInfo.getThFilename() != null) {
                this.getBlobClient(this.getThFileKey(fileInfo)).deleteIfExists();
            }
            this.getBlobClient(this.getFileKey(fileInfo)).deleteIfExists();
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.getBlobClient(this.getFileKey(fileInfo)).exists();
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        BlobClient blobClient = this.getBlobClient(this.getFileKey(fileInfo));
        try (BlobInputStream in = blobClient.openInputStream();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        BlobClient blobClient = this.getBlobClient(this.getThFileKey(fileInfo));
        try (BlobInputStream in = blobClient.openInputStream();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    public BlobSasPermission getBlobSasPermission(Object object) {
        if (object instanceof BlobSasPermission) {
            return (BlobSasPermission)object;
        }
        if (object instanceof String) {
            String permission = (String)this.methodToPermissionMap.get(object);
            if (permission == null) {
                permission = object.toString();
            }
            return BlobSasPermission.parse((String)permission);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u7684\u6743\u9650");
    }

    @Override
    public GeneratePresignedUrlResult generatePresignedUrl(GeneratePresignedUrlPretreatment pre) {
        try {
            Map<String, String> queryParams;
            String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
            HashMap<String, String> headers = new HashMap<String, String>(pre.getHeaders());
            headers.putAll(pre.getUserMetadata().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("x-ms-meta-") ? (String)e.getKey() : "x-ms-meta-" + (String)e.getKey(), Map.Entry::getValue)));
            BlobClient blobClient = this.getBlobClient(fileKey);
            BlobSasPermission permission = this.getBlobSasPermission(pre.getMethod());
            OffsetDateTime expiration = pre.getExpiration().toInstant().atZone(ZoneOffset.UTC).toOffsetDateTime();
            BlobServiceSasSignatureValues values = new BlobServiceSasSignatureValues(expiration, permission);
            KebabCaseInsensitiveMap<String, String> responseHeaders = new KebabCaseInsensitiveMap<String, String>(pre.getResponseHeaders());
            values.setCacheControl((String)responseHeaders.get("Cache-Control"));
            values.setContentDisposition((String)responseHeaders.get("Content-Disposition"));
            values.setContentEncoding((String)responseHeaders.get("Content-Encoding"));
            values.setContentLanguage((String)responseHeaders.get("Content-Language"));
            values.setContentType((String)responseHeaders.get("Content-Type"));
            if (pre.getStartTime() != null) {
                values.setStartTime(pre.getStartTime().toInstant().atZone(ZoneOffset.UTC).toOffsetDateTime());
            }
            if (CollUtil.isNotEmpty(queryParams = pre.getQueryParams())) {
                if (queryParams.get("protocol") != null) {
                    values.setProtocol(SasProtocol.parse((String)queryParams.get("protocol")));
                }
                if (queryParams.get("sasIpRange") != null) {
                    values.setSasIpRange(SasIpRange.parse((String)queryParams.get("sasIpRange")));
                }
                try {
                    values.setSnapshotId(queryParams.get("snapshotId"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                values.setIdentifier(queryParams.get("identifier"));
                values.setPreauthorizedAgentObjectId(queryParams.get("preauthorizedAgentObjectId"));
                values.setCorrelationId(queryParams.get("correlationId"));
            }
            StringBuilder url = new StringBuilder();
            url.append(blobClient.getBlobUrl()).append("?");
            if (CollUtil.isNotEmpty(queryParams)) {
                url.append(UrlQuery.of(queryParams).build(StandardCharsets.UTF_8)).append("&");
            }
            url.append(blobClient.generateSas(values));
            GeneratePresignedUrlResult result = new GeneratePresignedUrlResult(this.platform, this.basePath, pre);
            result.setUrl(url.toString());
            HashMap<String, String> resHeaders = new HashMap<String, String>(headers);
            resHeaders.put("x-ms-blob-type", "BlockBlob");
            result.setHeaders(resHeaders);
            return result;
        }
        catch (Exception e2) {
            throw ExceptionFactory.generatePresignedUrl(pre, e2);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    public void awaitCopy(SyncPoller<BlobCopyInfo, Void> copySyncPoller) {
        PollResponse copyInfo;
        CopyStatusType copyStatus;
        while ((copyStatus = ((BlobCopyInfo)(copyInfo = copySyncPoller.poll()).getValue()).getCopyStatus()) == CopyStatusType.PENDING) {
        }
        if (copyStatus != CopyStatusType.SUCCESS) {
            throw new RuntimeException(copyStatus.toString());
        }
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        Check.sameCopyNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        String destFileKey = this.getFileKey(destFileInfo);
        String destThFileKey = this.getThFileKey(destFileInfo);
        BlobClient srcClient = this.getBlobClient(this.getFileKey(srcFileInfo));
        BlobClient destClient = this.getBlobClient(destFileKey);
        BlobClient srcThClient = this.getBlobClient(this.getThFileKey(srcFileInfo));
        BlobClient destThClient = this.getBlobClient(destThFileKey);
        if (!Boolean.TRUE.equals(srcClient.exists())) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, null);
        }
        if (destThClient != null) {
            destFileInfo.setThUrl(this.getUrl(destThFileKey));
            try {
                this.awaitCopy((SyncPoller<BlobCopyInfo, Void>)destThClient.beginCopy(srcThClient.getBlobUrl(), Duration.ofSeconds(1L)));
                this.setFileAcl(destThFileKey, this.getAcl(srcFileInfo.getThFileAcl()));
            }
            catch (Exception e) {
                try {
                    destThClient.deleteIfExists();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        destFileInfo.setUrl(this.getUrl(destFileKey));
        try {
            long size = srcClient.getProperties().getBlobSize();
            ProgressListener.quickStart(pre.getProgressListener(), size);
            this.awaitCopy((SyncPoller<BlobCopyInfo, Void>)destClient.beginCopy(srcClient.getBlobUrl(), Duration.ofSeconds(1L)));
            this.setFileAcl(destFileKey, this.getAcl(srcFileInfo.getFileAcl()));
            ProgressListener.quickFinish(pre.getProgressListener(), size);
        }
        catch (Exception e) {
            if (destThClient != null) {
                try {
                    destThClient.deleteIfExists();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                destClient.deleteIfExists();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    private BlobServiceSasSignatureValues getBlobServiceSasSignatureValues(Date expiration) {
        BlobSasPermission blobPermission = new BlobSasPermission().setReadPermission(true);
        OffsetDateTime offsetDateTime = expiration.toInstant().atZone(ZoneOffset.UTC).toOffsetDateTime();
        return new BlobServiceSasSignatureValues(offsetDateTime, blobPermission);
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getDefaultAcl() {
        return this.defaultAcl;
    }

    public Long getMultipartThreshold() {
        return this.multipartThreshold;
    }

    public Long getMultipartPartSize() {
        return this.multipartPartSize;
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public CaseInsensitiveMap<String, String> getMethodToPermissionMap() {
        return this.methodToPermissionMap;
    }

    public FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setDefaultAcl(String defaultAcl) {
        this.defaultAcl = defaultAcl;
    }

    public void setMultipartThreshold(Long multipartThreshold) {
        this.multipartThreshold = multipartThreshold;
    }

    public void setMultipartPartSize(Long multipartPartSize) {
        this.multipartPartSize = multipartPartSize;
    }

    public void setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    public void setMethodToPermissionMap(CaseInsensitiveMap<String, String> methodToPermissionMap) {
        this.methodToPermissionMap = methodToPermissionMap;
    }

    public void setClientFactory(FileStorageClientFactory<AzureBlobStorageFileStorageClientFactory.AzureBlobStorageClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public AzureBlobStorageFileStorage() {
    }

    public static class AclWrapper {
        private List<PathAccessControlEntry> aclList;
        private PathPermissions permissions;

        public AclWrapper(List<PathAccessControlEntry> aclList) {
            this.aclList = aclList;
        }

        public AclWrapper(PathPermissions permissions) {
            this.permissions = permissions;
        }

        public List<PathAccessControlEntry> getAclList() {
            return this.aclList;
        }

        public PathPermissions getPermissions() {
            return this.permissions;
        }

        public void setAclList(List<PathAccessControlEntry> aclList) {
            this.aclList = aclList;
        }

        public void setPermissions(PathPermissions permissions) {
            this.permissions = permissions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AclWrapper)) {
                return false;
            }
            AclWrapper other = (AclWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<PathAccessControlEntry> this$aclList = this.getAclList();
            List<PathAccessControlEntry> other$aclList = other.getAclList();
            if (this$aclList == null ? other$aclList != null : !((Object)this$aclList).equals(other$aclList)) {
                return false;
            }
            PathPermissions this$permissions = this.getPermissions();
            PathPermissions other$permissions = other.getPermissions();
            return !(this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AclWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<PathAccessControlEntry> $aclList = this.getAclList();
            result = result * 59 + ($aclList == null ? 43 : ((Object)$aclList).hashCode());
            PathPermissions $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
            return result;
        }

        public String toString() {
            return "AzureBlobStorageFileStorage.AclWrapper(aclList=" + this.aclList + ", permissions=" + this.permissions + ")";
        }
    }
}

