/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.map.MapProxy;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.csource.common.MyException;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.UploadCallback;
import org.csource.fastdfs.UploadStream;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.util.KebabCaseInsensitiveMap;
import org.dromara.x.file.storage.core.util.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastDfsFileStorage
implements FileStorage {
    private static final Logger log = LoggerFactory.getLogger(FastDfsFileStorage.class);
    private FileStorageProperties.FastDfsConfig config;
    private FileStorageClientFactory<StorageClient> clientFactory;

    public FastDfsFileStorage(FileStorageProperties.FastDfsConfig config, FileStorageClientFactory<StorageClient> clientFactory) {
        this.config = config;
        this.clientFactory = clientFactory;
    }

    @Override
    public String getPlatform() {
        return this.config.getPlatform();
    }

    @Override
    public void setPlatform(String platform) {
        this.config.setPlatform(platform);
    }

    public StorageClient getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block26: {
            Check.uploadNotSupportAcl(this.getPlatform(), fileInfo, pre);
            fileInfo.setBasePath(this.config.getBasePath());
            FileWrapper fileWrapper = pre.getFileWrapper();
            NameValuePair[] metadata = this.getObjectMetadata(fileInfo);
            ProgressListener listener = pre.getProgressListener();
            StorageClient client = this.getClient();
            boolean useMultipartUpload = fileInfo.getSize() == null || fileInfo.getSize() >= (long)this.config.getMultipartThreshold();
            boolean hasListener = !useMultipartUpload;
            String[] fileUpload = null;
            InputStreamPlus in = pre.getInputStreamPlus(hasListener);
            try {
                byte[] thumbnailBytes;
                if (useMultipartUpload) {
                    byte[] bytes;
                    int i = 0;
                    AtomicLong progressSize = new AtomicLong();
                    ProgressListener.quickStart(listener, fileInfo.getSize());
                    while ((bytes = IoUtil.readBytes((InputStream)in, (int)this.config.getMultipartPartSize())) != null && bytes.length != 0) {
                        UploadStream uploadStream = new UploadStream((InputStream)new InputStreamPlus(new ByteArrayInputStream(bytes), currentSize -> ProgressListener.quickProgress(listener, progressSize.get() + currentSize, fileInfo.getSize())), (long)bytes.length);
                        if (++i == 1) {
                            fileUpload = client.upload_appender_file(this.config.getGroupName(), (long)bytes.length, (UploadCallback)uploadStream, fileInfo.getExt(), metadata);
                            if (fileUpload == null) {
                                throw new RuntimeException("FastDFS \u4e0a\u4f20\u5931\u8d25");
                            }
                        } else {
                            int code = client.append_file(fileUpload[0], fileUpload[1], (long)bytes.length, (UploadCallback)uploadStream);
                            if (code != 0) {
                                throw new RuntimeException("errno " + code);
                            }
                        }
                        progressSize.addAndGet(bytes.length);
                    }
                    ProgressListener.quickFinish(listener);
                } else {
                    Long size = fileWrapper.getSize();
                    fileUpload = client.upload_file(this.config.getGroupName(), size.longValue(), (UploadCallback)new UploadStream((InputStream)in, size.longValue()), fileInfo.getExt(), metadata);
                }
                if (fileUpload == null) {
                    throw new RuntimeException("FastDFS \u4e0a\u4f20\u5931\u8d25");
                }
                this.setGroupAndFilename(fileInfo, fileUpload);
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String[] thumbnailUpload;
                    String prefixName = null;
                    if (fileInfo.getThFilename().startsWith(fileInfo.getFilename())) {
                        try {
                            prefixName = FileNameUtil.mainName((String)fileInfo.getThFilename().substring(FileNameUtil.mainName((String)fileInfo.getFilename()).length()));
                        }
                        catch (Exception bytes) {
                            // empty catch block
                        }
                    }
                    if (StrUtil.isBlank(prefixName) && !(prefixName = FileNameUtil.extName((String)fileInfo.getFilename()) + ".th").startsWith(".")) {
                        prefixName = "." + prefixName;
                    }
                    if ((thumbnailUpload = client.upload_file(fileUpload[0], fileUpload[1], prefixName, thumbnailBytes, FileNameUtil.extName((String)fileInfo.getThFilename()), this.getThObjectMetadata(fileInfo))) == null) {
                        throw new RuntimeException("FastDFS \u4e0a\u4f20\u5931\u8d25");
                    }
                    this.setThGroupAndFilename(fileInfo, thumbnailUpload);
                }
                bl = true;
                if (in == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (fileUpload != null) {
                        try {
                            client.delete_file((String)fileUpload[0], (String)fileUpload[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw ExceptionFactory.upload(fileInfo, this.getPlatform(), e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        StorageClient client = this.getClient();
        try {
            org.csource.fastdfs.FileInfo file;
            String[] arr = this.getGroupAndFilename(new FileInfo().setPath(pre.getPath()).setFilename(pre.getFilename()).setUrl(pre.getUrl()));
            try {
                file = client.get_file_info(arr[0], arr[1]);
                if (file == null) {
                    return null;
                }
            }
            catch (Exception e2) {
                return null;
            }
            NameValuePair[] metadata = null;
            try {
                metadata = client.get_metadata(arr[0], arr[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (metadata == null) {
                metadata = new NameValuePair[]{};
            }
            KebabCaseInsensitiveMap<String, String> headers = new KebabCaseInsensitiveMap<String, String>(Arrays.stream(metadata).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue)));
            MapProxy headersProxy = MapProxy.create(headers);
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.config.getBasePath());
            this.setGroupAndFilename(info, arr);
            info.setSize(file.getFileSize());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setContentDisposition(headersProxy.getStr((Object)"Content-Disposition"));
            info.setContentType(headersProxy.getStr((Object)"Content-Type"));
            info.setContentMd5(headersProxy.getStr((Object)"Content-MD5"));
            info.setLastModified(file.getCreateTimestamp());
            info.setMetadata(headers.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("x-amz-meta-")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            info.setUserMetadata(headers.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("x-amz-meta-")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            info.setOriginal(new FastDfsFileInfo(file, metadata));
            return info;
        }
        catch (Exception e3) {
            throw ExceptionFactory.getFile(pre, this.config.getBasePath(), e3);
        }
    }

    public NameValuePair[] getObjectMetadata(FileInfo fileInfo) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (fileInfo.getMetadata() != null) {
            map.putAll(fileInfo.getMetadata());
        }
        if (fileInfo.getUserMetadata() != null) {
            fileInfo.getUserMetadata().forEach((key, value) -> map.put("x-amz-meta-" + key, (String)value));
        }
        return (NameValuePair[])map.entrySet().stream().map(e -> new NameValuePair((String)e.getKey(), (String)e.getValue())).toArray(NameValuePair[]::new);
    }

    public NameValuePair[] getThObjectMetadata(FileInfo fileInfo) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (fileInfo.getThMetadata() != null) {
            map.putAll(fileInfo.getThMetadata());
        }
        if (fileInfo.getThUserMetadata() != null) {
            fileInfo.getThUserMetadata().forEach((key, value) -> map.put("x-amz-meta-" + key, (String)value));
        }
        return (NameValuePair[])map.entrySet().stream().map(e -> new NameValuePair((String)e.getKey(), (String)e.getValue())).toArray(NameValuePair[]::new);
    }

    public void delete(StorageClient client, String group, String filename) throws MyException, IOException {
        int code = client.delete_file(group, filename);
        if (code != 0 && code != 2) {
            throw new RuntimeException("errno " + code);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        StorageClient client = this.getClient();
        try {
            String[] thArr = this.getThGroupAndFilename(fileInfo);
            if (thArr != null) {
                this.delete(client, thArr[0], thArr[1]);
            }
            String[] arr = this.getGroupAndFilename(fileInfo);
            this.delete(client, arr[0], arr[1]);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.getPlatform(), e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            String[] arr = this.getGroupAndFilename(fileInfo);
            org.csource.fastdfs.FileInfo remoteFileInfo = this.getClient().get_file_info(arr[0], arr[1]);
            return remoteFileInfo != null;
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.getPlatform(), e);
        }
    }

    public void download(StorageClient client, String group, String filename, Consumer<InputStream> consumer, Function<Exception, RuntimeException> exceptionConsumer) {
        try (PipedInputStream pis = new PipedInputStream();){
            PipedOutputStream pos = new PipedOutputStream(pis);
            ThreadUtil.execAsync(() -> {
                try {
                    client.download_file(group, filename, (fileSize, data, bytes) -> {
                        try {
                            pos.write(data, 0, bytes);
                        }
                        catch (Exception e) {
                            throw (RuntimeException)exceptionConsumer.apply(e);
                        }
                        return 0;
                    });
                }
                catch (Exception e) {
                    throw (RuntimeException)exceptionConsumer.apply(e);
                }
                finally {
                    IoUtil.close((Closeable)pos);
                }
            });
            consumer.accept(pis);
        }
        catch (Exception e) {
            throw exceptionConsumer.apply(e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        String[] arr = this.getGroupAndFilename(fileInfo);
        if (arr == null) {
            throw ExceptionFactory.download(fileInfo, this.getPlatform(), new NullPointerException());
        }
        this.download(this.clientFactory.getClient(), arr[0], arr[1], consumer, e -> ExceptionFactory.download(fileInfo, this.getPlatform(), e));
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        String[] arr = this.getThGroupAndFilename(fileInfo);
        if (arr == null) {
            throw ExceptionFactory.downloadThNotFound(fileInfo, this.getPlatform());
        }
        this.download(this.clientFactory.getClient(), arr[0], arr[1], consumer, e -> ExceptionFactory.downloadTh(fileInfo, this.getPlatform(), e));
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    public void setGroupAndFilename(FileInfo fileInfo, String[] arr) {
        fileInfo.setUrl(this.config.getDomain() + arr[0] + "/" + arr[1]);
        if (this.config.getRunMod() == FileStorageProperties.FastDfsConfig.RunMod.COVER) {
            Path path = Paths.get(arr[0], arr[1]);
            fileInfo.setPath(path.getParent().toString().replace("\\", "/") + "/");
            fileInfo.setFilename(path.getFileName().toString());
        }
    }

    public void setThGroupAndFilename(FileInfo fileInfo, String[] arr) {
        fileInfo.setThUrl(this.config.getDomain() + arr[0] + "/" + arr[1]);
        if (this.config.getRunMod() == FileStorageProperties.FastDfsConfig.RunMod.COVER) {
            Path path = Paths.get(arr[0], arr[1]);
            fileInfo.setPath(path.getParent().toString().replace("\\", "/") + "/");
            fileInfo.setThFilename(path.getFileName().toString());
        }
    }

    public void setGroupAndFilename(RemoteFileInfo info, String[] arr) {
        info.setUrl(this.config.getDomain() + arr[0] + "/" + arr[1]);
        Path path = Paths.get(arr[0], arr[1]);
        info.setPath(path.getParent().toString().replace("\\", "/") + "/");
        info.setFilename(path.getFileName().toString());
    }

    public String[] getGroupAndFilename(FileInfo fileInfo) {
        if (this.config.getRunMod() == FileStorageProperties.FastDfsConfig.RunMod.COVER) {
            String url = this.config.getDomain() + Tools.getNotNull(fileInfo.getPath(), "") + Tools.getNotNull(fileInfo.getFilename(), "");
            return this.getGroupAndFilenameByUrl(url);
        }
        if (this.config.getRunMod() == FileStorageProperties.FastDfsConfig.RunMod.URL) {
            return this.getGroupAndFilenameByUrl(fileInfo.getUrl());
        }
        return null;
    }

    public String[] getThGroupAndFilename(FileInfo fileInfo) {
        if (this.config.getRunMod() == FileStorageProperties.FastDfsConfig.RunMod.COVER) {
            if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
                return null;
            }
            String url = this.config.getDomain() + Tools.getNotNull(fileInfo.getPath(), "") + Tools.getNotNull(fileInfo.getThFilename(), "");
            return this.getGroupAndFilenameByUrl(url);
        }
        if (this.config.getRunMod() == FileStorageProperties.FastDfsConfig.RunMod.URL) {
            if (StrUtil.isBlank((CharSequence)fileInfo.getThUrl())) {
                return null;
            }
            return this.getGroupAndFilenameByUrl(fileInfo.getThUrl());
        }
        return null;
    }

    public String[] getGroupAndFilenameByUrl(String url) {
        if (StrUtil.isBlank((CharSequence)url)) {
            return null;
        }
        if (!url.startsWith(this.config.getDomain())) {
            return null;
        }
        try {
            String sub = url.substring(this.config.getDomain().length());
            int index = sub.indexOf("/");
            String group = sub.substring(0, index);
            String filename = sub.substring(index + 1);
            return new String[]{group, filename};
        }
        catch (Exception e) {
            return null;
        }
    }

    public FileStorageProperties.FastDfsConfig getConfig() {
        return this.config;
    }

    public FileStorageClientFactory<StorageClient> getClientFactory() {
        return this.clientFactory;
    }

    public void setConfig(FileStorageProperties.FastDfsConfig config) {
        this.config = config;
    }

    public void setClientFactory(FileStorageClientFactory<StorageClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public FastDfsFileStorage() {
    }

    public static class FastDfsFileInfo {
        private org.csource.fastdfs.FileInfo fileInfo;
        private NameValuePair[] metadata;

        public org.csource.fastdfs.FileInfo getFileInfo() {
            return this.fileInfo;
        }

        public NameValuePair[] getMetadata() {
            return this.metadata;
        }

        public FastDfsFileInfo setFileInfo(org.csource.fastdfs.FileInfo fileInfo) {
            this.fileInfo = fileInfo;
            return this;
        }

        public FastDfsFileInfo setMetadata(NameValuePair[] metadata) {
            this.metadata = metadata;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FastDfsFileInfo)) {
                return false;
            }
            FastDfsFileInfo other = (FastDfsFileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            org.csource.fastdfs.FileInfo this$fileInfo = this.getFileInfo();
            org.csource.fastdfs.FileInfo other$fileInfo = other.getFileInfo();
            if (this$fileInfo == null ? other$fileInfo != null : !this$fileInfo.equals(other$fileInfo)) {
                return false;
            }
            return Arrays.deepEquals(this.getMetadata(), other.getMetadata());
        }

        protected boolean canEqual(Object other) {
            return other instanceof FastDfsFileInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            org.csource.fastdfs.FileInfo $fileInfo = this.getFileInfo();
            result = result * 59 + ($fileInfo == null ? 43 : $fileInfo.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getMetadata());
            return result;
        }

        public String toString() {
            return "FastDfsFileStorage.FastDfsFileInfo(fileInfo=" + this.fileInfo + ", metadata=" + Arrays.deepToString(this.metadata) + ")";
        }

        public FastDfsFileInfo() {
        }

        public FastDfsFileInfo(org.csource.fastdfs.FileInfo fileInfo, NameValuePair[] metadata) {
            this.fileInfo = fileInfo;
            this.metadata = metadata;
        }
    }
}

