/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.Ftp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class FtpFileStorage
implements FileStorage {
    private String platform;
    private String domain;
    private String basePath;
    private String storagePath;
    private FileStorageClientFactory<Ftp> clientFactory;

    public FtpFileStorage(FileStorageProperties.FtpConfig config, FileStorageClientFactory<Ftp> clientFactory) {
        this.platform = config.getPlatform();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.storagePath = config.getStoragePath();
        this.clientFactory = clientFactory;
    }

    public Ftp getClient() {
        return this.clientFactory.getClient();
    }

    public void returnClient(Ftp client) {
        this.clientFactory.returnClient(client);
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    public String getAbsolutePath(String path) {
        return this.storagePath + path;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
        Check.uploadNotSupportMetadata(this.platform, fileInfo, pre);
        Ftp client = this.getClient();
        try {
            boolean bl;
            block15: {
                InputStreamPlus in = pre.getInputStreamPlus();
                try {
                    byte[] thumbnailBytes;
                    client.upload(this.getAbsolutePath(this.basePath + fileInfo.getPath()), fileInfo.getFilename(), (InputStream)in);
                    if (fileInfo.getSize() == null) {
                        fileInfo.setSize(in.getProgressSize());
                    }
                    if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                        String newThFileKey = this.getThFileKey(fileInfo);
                        fileInfo.setThUrl(this.domain + newThFileKey);
                        client.upload(this.getAbsolutePath(this.basePath + fileInfo.getPath()), fileInfo.getThFilename(), (InputStream)new ByteArrayInputStream(thumbnailBytes));
                    }
                    bl = true;
                    if (in == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        try {
                            client.delFile(this.getAbsolutePath(newFileKey));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw ExceptionFactory.upload(fileInfo, this.platform, e);
                    }
                }
                in.close();
            }
            return bl;
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll().setSupportMaxFiles(Integer.MAX_VALUE);
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        Ftp client = this.getClient();
        try {
            String path = this.getAbsolutePath(this.basePath + pre.getPath());
            List fileList = Arrays.stream(client.isDir(path) ? client.lsFiles(path) : new FTPFile[]{}).filter(f -> f.isFile() || f.isDirectory()).filter(f -> !".".equals(f.getName()) && !"..".equals(f.getName())).collect(Collectors.toList());
            FileStorage.ListFilesMatchResult<FTPFile> matchResult = this.listFilesMatch(fileList, FTPFile::getName, pre, true);
            ListFilesResult list = new ListFilesResult();
            list.setDirList(matchResult.getList().stream().filter(FTPFile::isDirectory).map(item -> {
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(item.getName());
                dir.setOriginal(item);
                return dir;
            }).collect(Collectors.toList()));
            list.setFileList(matchResult.getList().stream().filter(FTPFile::isFile).map(item -> {
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(item.getName());
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                info.setSize(item.getSize());
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setLastModified((Date)DateUtil.date((Calendar)item.getTimestamp()));
                info.setOriginal(item);
                return info;
            }).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(pre.getMaxFiles());
            list.setIsTruncated(matchResult.getIsTruncated());
            list.setMarker(pre.getMarker());
            list.setNextMarker(matchResult.getNextMarker());
            ListFilesResult listFilesResult = list;
            return listFilesResult;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        Ftp client = this.getClient();
        try {
            FTPFile file;
            String path = this.getAbsolutePath(this.basePath + pre.getPath());
            try {
                client.cd(path);
                file = client.getClient().listFiles(pre.getFilename())[0];
            }
            catch (Exception e) {
                RemoteFileInfo remoteFileInfo = null;
                this.returnClient(client);
                return remoteFileInfo;
            }
            if (file == null) {
                RemoteFileInfo e = null;
                return e;
            }
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(file.getName());
            info.setUrl(this.domain + fileKey);
            info.setSize(file.getSize());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setLastModified((Date)DateUtil.date((Calendar)file.getTimestamp()));
            info.setOriginal(file);
            RemoteFileInfo remoteFileInfo = info;
            return remoteFileInfo;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        Ftp client = this.getClient();
        try {
            if (fileInfo.getThFilename() != null) {
                client.delFile(this.getAbsolutePath(this.getThFileKey(fileInfo)));
            }
            client.delFile(this.getAbsolutePath(this.getFileKey(fileInfo)));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        Ftp client = this.getClient();
        try {
            client.cd(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath()));
            boolean bl = client.existFile(fileInfo.getFilename());
            return bl;
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Ftp client = this.getClient();
        try {
            client.cd(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath()));
            FTPClient ftpClient = client.getClient();
            ftpClient.setFileType(2);
            try (InputStream in = ftpClient.retrieveFileStream(fileInfo.getFilename());){
                if (in == null) {
                    throw ExceptionFactory.download(fileInfo, this.platform, null);
                }
                consumer.accept(in);
                ftpClient.completePendingCommand();
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        Ftp client = this.getClient();
        try {
            client.cd(this.getAbsolutePath(fileInfo.getBasePath() + fileInfo.getPath()));
            FTPClient ftpClient = client.getClient();
            ftpClient.setFileType(2);
            try (InputStream in = ftpClient.retrieveFileStream(fileInfo.getThFilename());){
                if (in == null) {
                    throw ExceptionFactory.downloadTh(fileInfo, this.platform, null);
                }
                consumer.accept(in);
                ftpClient.completePendingCommand();
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public boolean isSupportSameMove() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
        Check.sameMoveNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveNotSupportMetadata(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        String srcPath = this.getAbsolutePath(srcFileInfo.getBasePath() + srcFileInfo.getPath());
        String destPath = this.getAbsolutePath(destFileInfo.getBasePath() + destFileInfo.getPath());
        String relativizePath = Paths.get(srcPath, new String[0]).relativize(Paths.get(destPath, new String[0])).toString().replace("\\", "/") + "/";
        Ftp client = this.getClient();
        try {
            FTPFile srcFile;
            FTPClient ftpClient = client.getClient();
            client.cd(srcPath);
            try {
                srcFile = ftpClient.listFiles(srcFileInfo.getFilename())[0];
            }
            catch (Exception e) {
                throw ExceptionFactory.sameMoveNotFound(srcFileInfo, destFileInfo, this.platform, e);
            }
            String destThFileRelativizeKey = null;
            if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
                destFileInfo.setThUrl(this.domain + this.getThFileKey(destFileInfo));
                destThFileRelativizeKey = relativizePath + destFileInfo.getThFilename();
                try {
                    client.mkDirs(destPath);
                    ftpClient.rename(srcFileInfo.getThFilename(), destThFileRelativizeKey);
                }
                catch (Exception e) {
                    throw ExceptionFactory.sameMoveTh(srcFileInfo, destFileInfo, this.platform, e);
                }
            }
            String destFileKey = this.getFileKey(destFileInfo);
            destFileInfo.setUrl(this.domain + destFileKey);
            String destFileRelativizeKey = relativizePath + destFileInfo.getFilename();
            try {
                ProgressListener.quickStart(pre.getProgressListener(), srcFile.getSize());
                ftpClient.rename(srcFileInfo.getFilename(), destFileRelativizeKey);
                ProgressListener.quickFinish(pre.getProgressListener(), srcFile.getSize());
            }
            catch (Exception e) {
                if (destThFileRelativizeKey != null) {
                    try {
                        ftpClient.rename(destThFileRelativizeKey, srcFileInfo.getThFilename());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    if (client.existFile(srcFileInfo.getFilename())) {
                        client.delFile(destFileRelativizeKey);
                    } else {
                        ftpClient.rename(destFileRelativizeKey, srcFileInfo.getFilename());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ExceptionFactory.sameMove(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        finally {
            this.returnClient(client);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public FileStorageClientFactory<Ftp> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public void setClientFactory(FileStorageClientFactory<Ftp> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public FtpFileStorage() {
    }
}

