/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import io.minio.MinioClient;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class MinioFileStorageClientFactory
implements FileStorageClientFactory<MinioClient> {
    private String platform;
    private String accessKey;
    private String secretKey;
    private String endPoint;
    private volatile MinioClient client;

    public MinioFileStorageClientFactory(FileStorageProperties.MinioConfig config) {
        this.platform = config.getPlatform();
        this.accessKey = config.getAccessKey();
        this.secretKey = config.getSecretKey();
        this.endPoint = config.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MinioClient getClient() {
        if (this.client == null) {
            MinioFileStorageClientFactory minioFileStorageClientFactory = this;
            synchronized (minioFileStorageClientFactory) {
                if (this.client == null) {
                    this.client = new MinioClient.Builder().credentials(this.accessKey, this.secretKey).endpoint(this.endPoint).build();
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        this.client = null;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setClient(MinioClient client) {
        this.client = client;
    }

    public MinioFileStorageClientFactory() {
    }
}

