/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ReflectUtil;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.UploadOptions;
import com.qiniu.util.Auth;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.util.Tools;

public class QiniuKodoFileStorageClientFactory
implements FileStorageClientFactory<QiniuKodoClient> {
    private String platform;
    private String accessKey;
    private String secretKey;
    private volatile QiniuKodoClient client;

    public QiniuKodoFileStorageClientFactory(FileStorageProperties.QiniuKodoConfig config) {
        this.platform = config.getPlatform();
        this.accessKey = config.getAccessKey();
        this.secretKey = config.getSecretKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QiniuKodoClient getClient() {
        if (this.client == null) {
            QiniuKodoFileStorageClientFactory qiniuKodoFileStorageClientFactory = this;
            synchronized (qiniuKodoFileStorageClientFactory) {
                if (this.client == null) {
                    this.client = new QiniuKodoClient(this.accessKey, this.secretKey);
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        this.client = null;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setClient(QiniuKodoClient client) {
        this.client = client;
    }

    public QiniuKodoFileStorageClientFactory() {
    }

    public static class QiniuKodoClient {
        private String accessKey;
        private String secretKey;
        private volatile Auth auth;
        private volatile Client client;
        private volatile Configuration configuration;
        private volatile BucketManager bucketManager;
        private volatile UploadManager uploadManager;

        public QiniuKodoClient(String accessKey, String secretKey) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Auth getAuth() {
            if (this.auth == null) {
                QiniuKodoClient qiniuKodoClient = this;
                synchronized (qiniuKodoClient) {
                    if (this.auth == null) {
                        this.auth = Auth.create((String)this.accessKey, (String)this.secretKey);
                    }
                }
            }
            return this.auth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Client getClient() {
            if (this.client == null) {
                QiniuKodoClient qiniuKodoClient = this;
                synchronized (qiniuKodoClient) {
                    if (this.client == null) {
                        this.client = new Client(this.getConfiguration());
                    }
                }
            }
            return this.client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Configuration getConfiguration() {
            if (this.configuration == null) {
                QiniuKodoClient qiniuKodoClient = this;
                synchronized (qiniuKodoClient) {
                    if (this.configuration == null) {
                        this.configuration = new Configuration(Region.autoRegion());
                        this.configuration.resumableUploadAPIVersion = Configuration.ResumableUploadAPIVersion.V2;
                    }
                }
            }
            return this.configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BucketManager getBucketManager() {
            if (this.bucketManager == null) {
                QiniuKodoClient qiniuKodoClient = this;
                synchronized (qiniuKodoClient) {
                    if (this.bucketManager == null) {
                        this.bucketManager = new BucketManager(this.getAuth(), this.getConfiguration(), this.getClient());
                    }
                }
            }
            return this.bucketManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UploadManager getUploadManager() {
            if (this.uploadManager == null) {
                QiniuKodoClient qiniuKodoClient = this;
                synchronized (qiniuKodoClient) {
                    if (this.uploadManager == null) {
                        this.uploadManager = new UploadManager(this.getConfiguration());
                    }
                }
            }
            return this.uploadManager;
        }

        public <T> UploadActionResult<T> retryUploadAction(UploadAction<T> action, String token) throws InvocationTargetException, InstantiationException, IllegalAccessException {
            Class uploadTokenClass = ClassUtil.loadClass((String)"com.qiniu.storage.UploadToken");
            Class resumeUploadSourceStreamClass = ClassUtil.loadClass((String)"com.qiniu.storage.ResumeUploadSourceStream");
            Class resumeUploadPerformerV2Class = ClassUtil.loadClass((String)"com.qiniu.storage.ResumeUploadPerformerV2");
            Object uploadToken = ReflectUtil.newInstance((Class)uploadTokenClass, (Object[])new Object[]{token});
            Object v2 = ReflectUtil.getConstructor((Class)resumeUploadPerformerV2Class, (Class[])new Class[]{Client.class, String.class, uploadTokenClass, resumeUploadSourceStreamClass, Recorder.class, UploadOptions.class, Configuration.class}).newInstance(this.getClient(), null, uploadToken, null, null, new UploadOptions.Builder().build(), this.getConfiguration());
            Class uploadActionClass = ClassUtil.loadClass((String)"com.qiniu.storage.ResumeUploadPerformer.UploadAction");
            Object[] resultWrapper = new Object[1];
            Object uploadAction = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{uploadActionClass}, (proxy, method, args) -> {
                if ("uploadAction".equals(method.getName()) && args.length == 1 && args[0] instanceof String) {
                    UploadActionResult result;
                    resultWrapper[0] = result = action.uploadAction((String)args[0]);
                    return result.getResponse();
                }
                return method.invoke(proxy, args);
            });
            ReflectUtil.invoke(v2, (String)"retryUploadAction", (Object[])new Object[]{uploadAction});
            return (UploadActionResult)Tools.cast(resultWrapper[0]);
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setAuth(Auth auth) {
            this.auth = auth;
        }

        public void setClient(Client client) {
            this.client = client;
        }

        public void setConfiguration(Configuration configuration) {
            this.configuration = configuration;
        }

        public void setBucketManager(BucketManager bucketManager) {
            this.bucketManager = bucketManager;
        }

        public void setUploadManager(UploadManager uploadManager) {
            this.uploadManager = uploadManager;
        }

        public static class UploadActionResult<T> {
            private Response response;
            private T data;

            public Response getResponse() {
                return this.response;
            }

            public T getData() {
                return this.data;
            }

            public void setResponse(Response response) {
                this.response = response;
            }

            public void setData(T data) {
                this.data = data;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UploadActionResult)) {
                    return false;
                }
                UploadActionResult other = (UploadActionResult)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Response this$response = this.getResponse();
                Response other$response = other.getResponse();
                if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
                    return false;
                }
                T this$data = this.getData();
                T other$data = other.getData();
                return !(this$data == null ? other$data != null : !this$data.equals(other$data));
            }

            protected boolean canEqual(Object other) {
                return other instanceof UploadActionResult;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Response $response = this.getResponse();
                result = result * 59 + ($response == null ? 43 : $response.hashCode());
                T $data = this.getData();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                return result;
            }

            public String toString() {
                return "QiniuKodoFileStorageClientFactory.QiniuKodoClient.UploadActionResult(response=" + this.response + ", data=" + this.data + ")";
            }

            public UploadActionResult() {
            }

            public UploadActionResult(Response response, T data) {
                this.response = response;
                this.data = data;
            }
        }

        public static interface UploadAction<T> {
            public UploadActionResult<T> uploadAction(String var1) throws QiniuException;
        }
    }
}

