/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

public class TencentCosFileStorage
implements FileStorage {
    private String platform;
    private String bucketName;
    private String domain;
    private String basePath;
    private String defaultAcl;
    private int multipartThreshold;
    private int multipartPartSize;
    private FileStorageClientFactory<COSClient> clientFactory;

    public TencentCosFileStorage(FileStorageProperties.TencentCosConfig config, FileStorageClientFactory<COSClient> clientFactory) {
        this.platform = config.getPlatform();
        this.bucketName = config.getBucketName();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.defaultAcl = config.getDefaultAcl();
        this.multipartThreshold = config.getMultipartThreshold();
        this.multipartPartSize = config.getMultipartPartSize();
        this.clientFactory = clientFactory;
    }

    public COSClient getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block21: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            CannedAccessControlList fileAcl = this.getAcl(fileInfo.getFileAcl());
            ObjectMetadata metadata = this.getObjectMetadata(fileInfo);
            ProgressListener listener = pre.getProgressListener();
            COSClient client = this.getClient();
            boolean useMultipartUpload = fileInfo.getSize() == null || fileInfo.getSize() >= (long)this.multipartThreshold;
            String uploadId = null;
            InputStreamPlus in = pre.getInputStreamPlus(false);
            try {
                byte[] thumbnailBytes;
                if (useMultipartUpload) {
                    byte[] bytes;
                    InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucketName, newFileKey, metadata);
                    initiateMultipartUploadRequest.setCannedACL(fileAcl);
                    uploadId = client.initiateMultipartUpload(initiateMultipartUploadRequest).getUploadId();
                    ArrayList<PartETag> partList = new ArrayList<PartETag>();
                    int i = 0;
                    AtomicLong progressSize = new AtomicLong();
                    if (listener != null) {
                        listener.start();
                    }
                    while ((bytes = IoUtil.readBytes((InputStream)in, (int)this.multipartPartSize)) != null && bytes.length != 0) {
                        UploadPartRequest part = new UploadPartRequest();
                        part.setBucketName(this.bucketName);
                        part.setKey(newFileKey);
                        part.setUploadId(uploadId);
                        part.setInputStream((InputStream)new ByteArrayInputStream(bytes));
                        part.setPartSize((long)bytes.length);
                        part.setPartNumber(++i);
                        if (listener != null) {
                            part.setGeneralProgressListener(e -> {
                                if (e.getEventType() == ProgressEventType.REQUEST_BYTE_TRANSFER_EVENT) {
                                    listener.progress(progressSize.addAndGet(e.getBytes()), fileInfo.getSize());
                                }
                            });
                        }
                        partList.add(client.uploadPart(part).getPartETag());
                    }
                    client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, newFileKey, uploadId, partList));
                    if (listener != null) {
                        listener.finish();
                    }
                } else {
                    PutObjectRequest request = new PutObjectRequest(this.bucketName, newFileKey, (InputStream)in, metadata);
                    request.setCannedAcl(fileAcl);
                    if (listener != null) {
                        AtomicLong progressSize = new AtomicLong();
                        request.setGeneralProgressListener(e -> {
                            if (e.getEventType() == ProgressEventType.TRANSFER_STARTED_EVENT) {
                                listener.start();
                            } else if (e.getEventType() == ProgressEventType.REQUEST_BYTE_TRANSFER_EVENT) {
                                listener.progress(progressSize.addAndGet(e.getBytes()), fileInfo.getSize());
                            } else if (e.getEventType() == ProgressEventType.TRANSFER_COMPLETED_EVENT) {
                                listener.finish();
                            }
                        });
                    }
                    client.putObject(request);
                }
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    ObjectMetadata thMetadata = this.getThObjectMetadata(fileInfo);
                    PutObjectRequest request = new PutObjectRequest(this.bucketName, newThFileKey, (InputStream)new ByteArrayInputStream(thumbnailBytes), thMetadata);
                    request.setCannedAcl(this.getAcl(fileInfo.getThFileAcl()));
                    client.putObject(request);
                }
                bl = true;
                if (in == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    try {
                        if (useMultipartUpload) {
                            client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, newFileKey, uploadId));
                        } else {
                            client.deleteObject(this.bucketName, newFileKey);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e2);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll();
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        CannedAccessControlList fileAcl = this.getAcl(fileInfo.getFileAcl());
        ObjectMetadata metadata = this.getObjectMetadata(fileInfo);
        COSClient client = this.getClient();
        try {
            InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucketName, newFileKey, metadata);
            request.setCannedACL(fileAcl);
            String uploadId = client.initiateMultipartUpload(request).getUploadId();
            fileInfo.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block9: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            COSClient client = this.getClient();
            FileWrapper partFileWrapper = pre.getPartFileWrapper();
            Long partSize = partFileWrapper.getSize();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                if (partSize == null) {
                    partSize = partFileWrapper.getInputStreamMaskResetReturn(Tools::getSize);
                }
                UploadPartRequest part = new UploadPartRequest();
                part.setBucketName(this.bucketName);
                part.setKey(newFileKey);
                part.setUploadId(fileInfo.getUploadId());
                part.setInputStream((InputStream)in);
                part.setPartSize(partSize.longValue());
                part.setPartNumber(pre.getPartNumber());
                UploadPartResult result = client.uploadPart(part);
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(result.getETag());
                filePartInfo2.setPartNumber(result.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        COSClient client = this.getClient();
        try {
            List partList = pre.getPartInfoList().stream().map(part -> new PartETag(part.getPartNumber().intValue(), part.getETag())).collect(Collectors.toList());
            ProgressListener.quickStart(pre.getProgressListener(), fileInfo.getSize());
            client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, newFileKey, fileInfo.getUploadId(), partList));
            ProgressListener.quickFinish(pre.getProgressListener(), fileInfo.getSize());
        }
        catch (Exception e) {
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        COSClient client = this.getClient();
        try {
            client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, newFileKey, fileInfo.getUploadId()));
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        COSClient client = this.getClient();
        try {
            ListPartsRequest request = new ListPartsRequest(this.bucketName, newFileKey, fileInfo.getUploadId());
            request.setMaxParts(pre.getMaxParts().intValue());
            request.setPartNumberMarker(pre.getPartNumberMarker());
            PartListing result = client.listParts(request);
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setList(result.getParts().stream().map(p -> {
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setETag(p.getETag());
                filePartInfo.setPartNumber(p.getPartNumber());
                filePartInfo.setPartSize(p.getSize());
                filePartInfo.setLastModified(p.getLastModified());
                return filePartInfo;
            }).collect(Collectors.toList()));
            list.setMaxParts(result.getMaxParts());
            list.setIsTruncated(result.isTruncated());
            list.setPartNumberMarker(result.getPartNumberMarker());
            list.setNextPartNumberMarker(result.getNextPartNumberMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll();
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        COSClient client = this.getClient();
        try {
            ListObjectsRequest request = new ListObjectsRequest();
            request.setBucketName(this.bucketName);
            request.setMaxKeys(pre.getMaxFiles());
            request.setMarker(pre.getMarker());
            request.setDelimiter("/");
            request.setPrefix(this.basePath + pre.getPath() + pre.getFilenamePrefix());
            ObjectListing result = client.listObjects(request);
            ListFilesResult list = new ListFilesResult();
            list.setDirList(result.getCommonPrefixes().stream().map(item -> {
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(FileNameUtil.getName((String)item));
                dir.setOriginal(item);
                return dir;
            }).collect(Collectors.toList()));
            list.setFileList(result.getObjectSummaries().stream().map(item -> {
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(FileNameUtil.getName((String)item.getKey()));
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                info.setSize(item.getSize());
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setETag(item.getETag());
                info.setLastModified(item.getLastModified());
                info.setOriginal(item);
                return info;
            }).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(result.getMaxKeys());
            list.setIsTruncated(result.isTruncated());
            list.setMarker(result.getMarker());
            list.setNextMarker(result.getNextMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        COSClient client = this.getClient();
        try {
            COSObject file;
            try {
                file = client.getObject(this.bucketName, fileKey);
            }
            catch (Exception e) {
                return null;
            }
            if (file == null) {
                return null;
            }
            ObjectMetadata metadata = file.getObjectMetadata();
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(FileNameUtil.getName((String)file.getKey()));
            info.setUrl(this.domain + fileKey);
            info.setSize(metadata.getContentLength());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setETag(metadata.getETag());
            info.setContentDisposition(metadata.getContentDisposition());
            info.setContentType(metadata.getContentType());
            info.setContentMd5(metadata.getContentMD5());
            info.setLastModified(metadata.getLastModified());
            if (metadata.getRawMetadata() != null) {
                info.setMetadata(new HashMap<String, Object>(metadata.getRawMetadata()));
            }
            if (metadata.getUserMetadata() != null) {
                info.setUserMetadata(new HashMap<String, Object>(metadata.getUserMetadata()));
            }
            info.setOriginal(file);
            return info;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
    }

    public CannedAccessControlList getAcl(Object acl) {
        if (acl instanceof CannedAccessControlList) {
            return (CannedAccessControlList)acl;
        }
        if (acl instanceof String || acl == null) {
            String sAcl = (String)acl;
            if (StrUtil.isEmpty((CharSequence)sAcl)) {
                sAcl = this.defaultAcl;
            }
            for (CannedAccessControlList item : CannedAccessControlList.values()) {
                if (!item.toString().equals(sAcl)) continue;
                return item;
            }
            return null;
        }
        throw ExceptionFactory.unrecognizedAcl(acl, this.platform);
    }

    public ObjectMetadata getObjectMetadata(FileInfo fileInfo) {
        ObjectMetadata metadata = new ObjectMetadata();
        if (fileInfo.getSize() != null) {
            metadata.setContentLength(fileInfo.getSize().longValue());
        }
        if (fileInfo.getContentType() != null) {
            metadata.setContentType(fileInfo.getContentType());
        }
        metadata.setUserMetadata(fileInfo.getUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getMetadata())) {
            fileInfo.getMetadata().forEach((arg_0, arg_1) -> ((ObjectMetadata)metadata).setHeader(arg_0, arg_1));
        }
        return metadata;
    }

    public ObjectMetadata getThObjectMetadata(FileInfo fileInfo) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(fileInfo.getThSize().longValue());
        metadata.setContentType(fileInfo.getThContentType());
        metadata.setUserMetadata(fileInfo.getThUserMetadata());
        if (CollUtil.isNotEmpty(fileInfo.getThMetadata())) {
            fileInfo.getThMetadata().forEach((arg_0, arg_1) -> ((ObjectMetadata)metadata).setHeader(arg_0, arg_1));
        }
        return metadata;
    }

    @Override
    public boolean isSupportPresignedUrl() {
        return true;
    }

    @Override
    public GeneratePresignedUrlResult generatePresignedUrl(GeneratePresignedUrlPretreatment pre) {
        try {
            String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucketName, fileKey);
            request.setExpiration(pre.getExpiration());
            request.setMethod(Tools.getEnum(HttpMethodName.class, pre.getMethod()));
            HashMap<String, String> headers = new HashMap<String, String>(pre.getHeaders());
            headers.putAll(pre.getUserMetadata().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).startsWith("x-cos-meta-") ? (String)e.getKey() : "x-cos-meta-" + (String)e.getKey(), Map.Entry::getValue)));
            headers.forEach((arg_0, arg_1) -> ((GeneratePresignedUrlRequest)request).putCustomRequestHeader(arg_0, arg_1));
            pre.getQueryParams().forEach((arg_0, arg_1) -> ((GeneratePresignedUrlRequest)request).addRequestParameter(arg_0, arg_1));
            pre.getResponseHeaders().forEach((k, v) -> request.addRequestParameter("response-" + k.toLowerCase(), v));
            URL url = this.getClient().generatePresignedUrl(request);
            GeneratePresignedUrlResult result = new GeneratePresignedUrlResult(this.platform, this.basePath, pre);
            result.setUrl(url.toString());
            result.setHeaders(request.getCustomRequestHeaders());
            return result;
        }
        catch (Exception e2) {
            throw ExceptionFactory.generatePresignedUrl(pre, e2);
        }
    }

    @Override
    public boolean isSupportAcl() {
        return true;
    }

    @Override
    public boolean setFileAcl(FileInfo fileInfo, Object acl) {
        CannedAccessControlList oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        try {
            this.getClient().setObjectAcl(this.bucketName, this.getFileKey(fileInfo), oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean setThFileAcl(FileInfo fileInfo, Object acl) {
        CannedAccessControlList oAcl = this.getAcl(acl);
        if (oAcl == null) {
            return false;
        }
        String key = this.getThFileKey(fileInfo);
        if (key == null) {
            return false;
        }
        try {
            this.getClient().setObjectAcl(this.bucketName, key, oAcl);
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.setThFileAcl(fileInfo, oAcl, this.platform, e);
        }
    }

    @Override
    public boolean isSupportMetadata() {
        return true;
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        COSClient client = this.getClient();
        try {
            if (fileInfo.getThFilename() != null) {
                client.deleteObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
            }
            client.deleteObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.getClient().doesObjectExist(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        COSObject object = this.getClient().getObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
        try (COSObjectInputStream in = object.getObjectContent();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        COSObject object = this.getClient().getObject(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
        try (COSObjectInputStream in = object.getObjectContent();){
            consumer.accept((InputStream)in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        ObjectMetadata srcFile;
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        COSClient client = this.getClient();
        String srcFileKey = this.getFileKey(srcFileInfo);
        try {
            srcFile = client.getObjectMetadata(this.bucketName, srcFileKey);
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileKey = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                CopyObjectRequest request = new CopyObjectRequest(this.bucketName, this.getThFileKey(srcFileInfo), this.bucketName, destThFileKey);
                request.setCannedAccessControlList(this.getAcl(destFileInfo.getFileAcl()));
                client.copyObject(request);
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        long fileSize = srcFile.getContentLength();
        boolean useMultipartCopy = fileSize >= 0x40000000L;
        String uploadId = null;
        try {
            if (useMultipartCopy) {
                CannedAccessControlList fileAcl = this.getAcl(destFileInfo.getFileAcl());
                ObjectMetadata metadata = this.getObjectMetadata(destFileInfo);
                InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.bucketName, destFileKey, metadata);
                initRequest.setCannedACL(fileAcl);
                uploadId = client.initiateMultipartUpload(initRequest).getUploadId();
                ProgressListener.quickStart(pre.getProgressListener(), fileSize);
                ArrayList<PartETag> partList = new ArrayList<PartETag>();
                long progressSize = 0L;
                int i = 0;
                while (progressSize < fileSize) {
                    long partSize = Math.min(0x10000000L, fileSize - progressSize);
                    CopyPartRequest part = new CopyPartRequest();
                    part.setSourceBucketName(this.bucketName);
                    part.setSourceKey(srcFileKey);
                    part.setDestinationBucketName(this.bucketName);
                    part.setDestinationKey(destFileKey);
                    part.setUploadId(uploadId);
                    part.setFirstByte(Long.valueOf(progressSize));
                    part.setLastByte(Long.valueOf(progressSize + partSize - 1L));
                    part.setPartNumber(++i);
                    partList.add(client.copyPart(part).getPartETag());
                    ProgressListener.quickProgress(pre.getProgressListener(), progressSize += partSize, fileSize);
                }
                client.completeMultipartUpload(new CompleteMultipartUploadRequest(this.bucketName, destFileKey, uploadId, partList));
                ProgressListener.quickFinish(pre.getProgressListener());
            } else {
                ProgressListener.quickStart(pre.getProgressListener(), fileSize);
                CopyObjectRequest request = new CopyObjectRequest(this.bucketName, srcFileKey, this.bucketName, destFileKey);
                request.setCannedAccessControlList(this.getAcl(destFileInfo.getFileAcl()));
                client.copyObject(request);
                ProgressListener.quickFinish(pre.getProgressListener(), fileSize);
            }
        }
        catch (Exception e) {
            if (destThFileKey != null) {
                try {
                    client.deleteObject(this.bucketName, destThFileKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (useMultipartCopy) {
                    client.abortMultipartUpload(new AbortMultipartUploadRequest(this.bucketName, destFileKey, uploadId));
                } else {
                    client.deleteObject(this.bucketName, destFileKey);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getDefaultAcl() {
        return this.defaultAcl;
    }

    public int getMultipartThreshold() {
        return this.multipartThreshold;
    }

    public int getMultipartPartSize() {
        return this.multipartPartSize;
    }

    public FileStorageClientFactory<COSClient> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setDefaultAcl(String defaultAcl) {
        this.defaultAcl = defaultAcl;
    }

    public void setMultipartThreshold(int multipartThreshold) {
        this.multipartThreshold = multipartThreshold;
    }

    public void setMultipartPartSize(int multipartPartSize) {
        this.multipartPartSize = multipartPartSize;
    }

    public void setClientFactory(FileStorageClientFactory<COSClient> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public TencentCosFileStorage() {
    }
}

