/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import com.upyun.RestManager;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class UpyunUssFileStorageClientFactory
implements FileStorageClientFactory<RestManager> {
    private String platform;
    private String username;
    private String password;
    private String bucketName;
    private volatile RestManager client;

    public UpyunUssFileStorageClientFactory(FileStorageProperties.UpyunUssConfig config) {
        this.platform = config.getPlatform();
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.bucketName = config.getBucketName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestManager getClient() {
        if (this.client == null) {
            UpyunUssFileStorageClientFactory upyunUssFileStorageClientFactory = this;
            synchronized (upyunUssFileStorageClientFactory) {
                if (this.client == null) {
                    this.client = new RestManager(this.bucketName, this.username, this.password);
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        this.client = null;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setClient(RestManager client) {
        this.client = client;
    }

    public UpyunUssFileStorageClientFactory() {
    }
}

