/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.get.GetFilePretreatment;
import org.dromara.x.file.storage.core.get.ListFilesPretreatment;
import org.dromara.x.file.storage.core.get.ListFilesResult;
import org.dromara.x.file.storage.core.get.ListFilesSupportInfo;
import org.dromara.x.file.storage.core.get.RemoteDirInfo;
import org.dromara.x.file.storage.core.get.RemoteFileInfo;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;
import org.dromara.x.file.storage.core.util.Tools;

public class WebDavFileStorage
implements FileStorage {
    private String platform;
    private String server;
    private String domain;
    private String basePath;
    private String storagePath;
    private FileStorageClientFactory<Sardine> clientFactory;

    public WebDavFileStorage(FileStorageProperties.WebDavConfig config, FileStorageClientFactory<Sardine> clientFactory) {
        this.platform = config.getPlatform();
        this.server = config.getServer();
        this.domain = config.getDomain();
        this.basePath = config.getBasePath();
        this.storagePath = config.getStoragePath();
        this.clientFactory = clientFactory;
    }

    public Sardine getClient() {
        return this.clientFactory.getClient();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    public String getUrl(String path) {
        return Tools.join(this.server, this.storagePath + path);
    }

    public boolean existsDirectory(Sardine client, String path) throws IOException {
        if (this.server.equals(path)) {
            return true;
        }
        try {
            return client.list(path, 0).size() > 0;
        }
        catch (SardineException e) {
            if (e.getStatusCode() == 404 || e.getStatusCode() == 409) {
                return false;
            }
            throw e;
        }
    }

    public void createDirectory(Sardine client, String path) throws IOException {
        if (!this.existsDirectory(client, path)) {
            this.createDirectory(client, Tools.join(Tools.getParent(path), "/"));
            client.createDirectory(path);
        }
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        boolean bl;
        block12: {
            fileInfo.setBasePath(this.basePath);
            String newFileKey = this.getFileKey(fileInfo);
            fileInfo.setUrl(this.domain + newFileKey);
            Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
            Check.uploadNotSupportMetadata(this.platform, fileInfo, pre);
            Sardine client = this.getClient();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                byte[] thumbnailBytes;
                this.createDirectory(client, this.getUrl(fileInfo.getBasePath() + fileInfo.getPath()));
                client.put(this.getUrl(newFileKey), (InputStream)in, fileInfo.getContentType(), true, fileInfo.getSize() == null ? -1L : fileInfo.getSize());
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
                if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                    String newThFileKey = this.getThFileKey(fileInfo);
                    fileInfo.setThUrl(this.domain + newThFileKey);
                    client.put(this.getUrl(newThFileKey), thumbnailBytes);
                }
                bl = true;
                if (in == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    try {
                        client.delete(this.getUrl(newFileKey));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ExceptionFactory.upload(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return bl;
    }

    @Override
    public ListFilesSupportInfo isSupportListFiles() {
        return ListFilesSupportInfo.supportAll().setSupportMaxFiles(Integer.MAX_VALUE);
    }

    @Override
    public ListFilesResult listFiles(ListFilesPretreatment pre) {
        Sardine client = this.getClient();
        try {
            List result;
            block4: {
                result = Collections.emptyList();
                try {
                    result = client.list(this.getUrl(this.basePath + pre.getPath()), 1, false);
                    result.remove(0);
                }
                catch (SardineException e) {
                    if (e.getStatusCode() == 404 || e.getStatusCode() == 409) break block4;
                    throw e;
                }
            }
            FileStorage.ListFilesMatchResult<DavResource> matchResult = this.listFilesMatch(result, DavResource::getName, pre, false);
            ListFilesResult list = new ListFilesResult();
            list.setDirList(matchResult.getList().stream().filter(DavResource::isDirectory).map(item -> {
                RemoteDirInfo dir = new RemoteDirInfo();
                dir.setPlatform(pre.getPlatform());
                dir.setBasePath(this.basePath);
                dir.setPath(pre.getPath());
                dir.setName(item.getName());
                dir.setOriginal(item);
                return dir;
            }).collect(Collectors.toList()));
            list.setFileList(matchResult.getList().stream().filter(item -> !item.isDirectory()).map(item -> {
                RemoteFileInfo info = new RemoteFileInfo();
                info.setPlatform(pre.getPlatform());
                info.setBasePath(this.basePath);
                info.setPath(pre.getPath());
                info.setFilename(item.getName());
                info.setUrl(this.domain + this.getFileKey(new FileInfo(this.basePath, info.getPath(), info.getFilename())));
                info.setSize(item.getContentLength());
                info.setExt(FileNameUtil.extName((String)info.getFilename()));
                info.setETag(item.getEtag());
                info.setContentType(item.getContentType());
                info.setLastModified(item.getModified());
                info.setOriginal(item);
                return info;
            }).collect(Collectors.toList()));
            list.setPlatform(pre.getPlatform());
            list.setBasePath(this.basePath);
            list.setPath(pre.getPath());
            list.setFilenamePrefix(pre.getFilenamePrefix());
            list.setMaxFiles(pre.getMaxFiles());
            list.setIsTruncated(matchResult.getIsTruncated());
            list.setMarker(pre.getMarker());
            list.setNextMarker(matchResult.getNextMarker());
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listFiles(pre, this.basePath, e);
        }
    }

    @Override
    public RemoteFileInfo getFile(GetFilePretreatment pre) {
        String fileKey = this.getFileKey(new FileInfo(this.basePath, pre.getPath(), pre.getFilename()));
        Sardine client = this.getClient();
        try {
            DavResource file;
            try {
                String url = this.getUrl(fileKey);
                file = (DavResource)client.list(url, 0, false).get(0);
            }
            catch (Exception e) {
                return null;
            }
            RemoteFileInfo info = new RemoteFileInfo();
            info.setPlatform(pre.getPlatform());
            info.setBasePath(this.basePath);
            info.setPath(pre.getPath());
            info.setFilename(file.getName());
            info.setUrl(this.domain + fileKey);
            info.setSize(file.getContentLength());
            info.setExt(FileNameUtil.extName((String)info.getFilename()));
            info.setETag(file.getEtag());
            info.setContentType(file.getContentType());
            info.setLastModified(file.getModified());
            info.setOriginal(file);
            return info;
        }
        catch (Exception e) {
            throw ExceptionFactory.getFile(pre, this.basePath, e);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        Sardine client = this.getClient();
        try {
            block8: {
                block7: {
                    if (fileInfo.getThFilename() != null) {
                        try {
                            client.delete(this.getUrl(this.getThFileKey(fileInfo)));
                        }
                        catch (SardineException e) {
                            if (e.getStatusCode() == 404) break block7;
                            throw e;
                        }
                    }
                }
                try {
                    client.delete(this.getUrl(this.getFileKey(fileInfo)));
                }
                catch (SardineException e) {
                    if (e.getStatusCode() == 404) break block8;
                    throw e;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return this.getClient().exists(this.getUrl(this.getFileKey(fileInfo)));
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (InputStream in = this.getClient().get(this.getUrl(this.getFileKey(fileInfo)));){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        try (InputStream in = this.getClient().get(this.getUrl(this.getThFileKey(fileInfo)));){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        DavResource srcFile;
        Check.sameCopyNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyNotSupportMetadata(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        Sardine client = this.getClient();
        String srcFileUrl = this.getUrl(this.getFileKey(srcFileInfo));
        try {
            srcFile = (DavResource)client.list(srcFileUrl, 0, false).get(0);
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        try {
            this.createDirectory(client, this.getUrl(destFileInfo.getBasePath() + destFileInfo.getPath()));
        }
        catch (Exception e) {
            throw ExceptionFactory.sameCopyCreatePath(srcFileInfo, destFileInfo, this.platform, e);
        }
        String destThFileUrl = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            String destThFileKey = this.getThFileKey(destFileInfo);
            destThFileUrl = this.getUrl(destThFileKey);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                client.copy(this.getUrl(this.getThFileKey(srcFileInfo)), destThFileUrl);
            }
            catch (Exception e) {
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        String destFileUrl = this.getUrl(destFileKey);
        try {
            ProgressListener.quickStart(pre.getProgressListener(), srcFile.getContentLength());
            client.copy(srcFileUrl, destFileUrl);
            ProgressListener.quickFinish(pre.getProgressListener(), srcFile.getContentLength());
        }
        catch (Exception e) {
            try {
                if (destThFileUrl != null) {
                    client.delete(destThFileUrl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                client.delete(destFileUrl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameMove() {
        return true;
    }

    @Override
    public void sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
        DavResource srcFile;
        Check.sameMoveNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveNotSupportMetadata(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        Sardine client = this.getClient();
        String srcFileUrl = this.getUrl(this.getFileKey(srcFileInfo));
        try {
            srcFile = (DavResource)client.list(srcFileUrl, 0, false).get(0);
        }
        catch (Exception e) {
            throw ExceptionFactory.sameMoveNotFound(srcFileInfo, destFileInfo, this.platform, e);
        }
        try {
            this.createDirectory(client, this.getUrl(destFileInfo.getBasePath() + destFileInfo.getPath()));
        }
        catch (Exception e) {
            throw ExceptionFactory.sameMoveCreatePath(srcFileInfo, destFileInfo, this.platform, e);
        }
        String srcThFileUrl = null;
        String destThFileUrl = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            srcThFileUrl = this.getUrl(this.getThFileKey(srcFileInfo));
            String destThFileKey = this.getThFileKey(destFileInfo);
            destThFileUrl = this.getUrl(destThFileKey);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                client.move(srcThFileUrl, destThFileUrl);
            }
            catch (Exception e) {
                throw ExceptionFactory.sameMoveTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        String destFileUrl = this.getUrl(destFileKey);
        try {
            ProgressListener.quickStart(pre.getProgressListener(), srcFile.getContentLength());
            client.move(srcFileUrl, destFileUrl);
            ProgressListener.quickFinish(pre.getProgressListener(), srcFile.getContentLength());
        }
        catch (Exception e) {
            try {
                if (destThFileUrl != null) {
                    client.move(destThFileUrl, srcThFileUrl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (client.exists(srcFileUrl)) {
                    client.delete(destFileUrl);
                } else {
                    client.move(destFileUrl, srcFileUrl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameMove(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getServer() {
        return this.server;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public FileStorageClientFactory<Sardine> getClientFactory() {
        return this.clientFactory;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public void setClientFactory(FileStorageClientFactory<Sardine> clientFactory) {
        this.clientFactory = clientFactory;
    }

    public WebDavFileStorage() {
    }
}

