/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.presigned;

import java.util.HashMap;
import java.util.List;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.aspect.GeneratePresignedUrlAspectChain;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlPretreatment;
import org.dromara.x.file.storage.core.presigned.GeneratePresignedUrlResult;

public class GeneratePresignedUrlActuator {
    private final FileStorageService fileStorageService;
    private final GeneratePresignedUrlPretreatment pre;

    public GeneratePresignedUrlActuator(GeneratePresignedUrlPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public GeneratePresignedUrlResult execute() {
        return this.execute((FileStorage)this.fileStorageService.getFileStorageVerify(this.pre.getPlatform()), (List<FileStorageAspect>)this.fileStorageService.getAspectList());
    }

    public GeneratePresignedUrlResult execute(FileStorage fileStorage, List<FileStorageAspect> aspectList) {
        Check.generatePresignedUrl(this.pre);
        return new GeneratePresignedUrlAspectChain(aspectList, (_pre, _fileStorage) -> {
            GeneratePresignedUrlResult result = _fileStorage.generatePresignedUrl(_pre);
            if (result.getHeaders() == null) {
                result.setHeaders(new HashMap<String, String>());
            }
            return result;
        }).next(this.pre, fileStorage);
    }
}

