/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.upload;

import java.io.IOException;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.ProgressListenerSetter;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.hash.HashCalculator;
import org.dromara.x.file.storage.core.hash.HashCalculatorManager;
import org.dromara.x.file.storage.core.hash.HashCalculatorSetter;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.UploadPartActuator;

public class UploadPartPretreatment
implements ProgressListenerSetter<UploadPartPretreatment>,
HashCalculatorSetter<UploadPartPretreatment> {
    private FileStorageService fileStorageService;
    private FileInfo fileInfo;
    private FileWrapper partFileWrapper;
    private int partNumber;
    private ProgressListener progressListener;
    private HashCalculatorManager hashCalculatorManager = new HashCalculatorManager();
    private InputStreamPlus inputStreamPlus;

    public UploadPartPretreatment setFileStorageService(boolean flag, FileStorageService fileStorageService) {
        if (flag) {
            this.setFileStorageService(fileStorageService);
        }
        return this;
    }

    public UploadPartPretreatment setFileInfo(boolean flag, FileInfo fileInfo) {
        if (flag) {
            this.setFileInfo(fileInfo);
        }
        return this;
    }

    public UploadPartPretreatment setPartFileWrapper(boolean flag, FileWrapper partFileWrapper) {
        if (flag) {
            this.setPartFileWrapper(partFileWrapper);
        }
        return this;
    }

    public UploadPartPretreatment setPartNumber(boolean flag, int partNumber) {
        if (flag) {
            this.setPartNumber(partNumber);
        }
        return this;
    }

    @Override
    public UploadPartPretreatment setHashCalculator(HashCalculator hashCalculator) {
        this.hashCalculatorManager.setHashCalculator(hashCalculator);
        return this;
    }

    public UploadPartPretreatment setHashCalculatorManager(boolean flag, HashCalculatorManager hashCalculatorManager) {
        if (flag) {
            this.setHashCalculatorManager(hashCalculatorManager);
        }
        return this;
    }

    public InputStreamPlus getInputStreamPlus() throws IOException {
        return this.getInputStreamPlus(true);
    }

    public InputStreamPlus getInputStreamPlus(boolean hasListener) throws IOException {
        if (this.inputStreamPlus == null) {
            this.inputStreamPlus = new InputStreamPlus(this.partFileWrapper.getInputStream(), hasListener ? this.progressListener : null, this.partFileWrapper.getSize(), this.hashCalculatorManager);
        }
        return this.inputStreamPlus;
    }

    public FilePartInfo upload() {
        return new UploadPartActuator(this).execute();
    }

    public FileStorageService getFileStorageService() {
        return this.fileStorageService;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public FileWrapper getPartFileWrapper() {
        return this.partFileWrapper;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public HashCalculatorManager getHashCalculatorManager() {
        return this.hashCalculatorManager;
    }

    public UploadPartPretreatment setFileStorageService(FileStorageService fileStorageService) {
        this.fileStorageService = fileStorageService;
        return this;
    }

    public UploadPartPretreatment setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        return this;
    }

    public UploadPartPretreatment setPartFileWrapper(FileWrapper partFileWrapper) {
        this.partFileWrapper = partFileWrapper;
        return this;
    }

    public UploadPartPretreatment setPartNumber(int partNumber) {
        this.partNumber = partNumber;
        return this;
    }

    @Override
    public UploadPartPretreatment setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public UploadPartPretreatment setHashCalculatorManager(HashCalculatorManager hashCalculatorManager) {
        this.hashCalculatorManager = hashCalculatorManager;
        return this;
    }

    public UploadPartPretreatment setInputStreamPlus(InputStreamPlus inputStreamPlus) {
        this.inputStreamPlus = inputStreamPlus;
        return this;
    }
}

