/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.font;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.ofdrw.font.FontName;

public class Font {
    private String name;
    private String familyName;
    private Path fontFile;
    private double[] printableAsciiWidthMap = null;

    private Font() {
    }

    public static Font getDefault() {
        return FontName.SimSun.font();
    }

    public Font(String name, String familyName, Path fontFile) {
        this.name = name;
        this.familyName = familyName;
        if (fontFile == null || Files.notExists(fontFile, new LinkOption[0])) {
            throw new IllegalArgumentException("\u5b57\u4f53\u6587\u4ef6(fontFile)\u4e0d\u5b58\u5728");
        }
        this.fontFile = fontFile;
    }

    public Font(String name, String familyName) {
        this.name = name;
        this.familyName = familyName;
    }

    public Font(String name, Path fontFile) {
        this.name = name;
        if (fontFile == null || Files.notExists(fontFile, new LinkOption[0])) {
            throw new IllegalArgumentException("\u5b57\u4f53\u6587\u4ef6(fontFile)\u4e0d\u5b58\u5728");
        }
        this.fontFile = fontFile;
    }

    public Font(String name, String familyName, Path fontFile, double[] printableAsciiWidthMap) {
        this.name = name;
        this.familyName = familyName;
        this.fontFile = fontFile;
        this.printableAsciiWidthMap = printableAsciiWidthMap;
    }

    public boolean hasWidthMath() {
        return this.printableAsciiWidthMap != null && this.printableAsciiWidthMap.length > 0;
    }

    public double getCharWidthScale(char txt) {
        if (this.printableAsciiWidthMap != null) {
            if (txt >= ' ' && txt <= '~') {
                return this.printableAsciiWidthMap[txt - 32];
            }
            return 1.0;
        }
        return txt >= ' ' && txt <= '~' ? 0.5 : 1.0;
    }

    public Font setPrintableAsciiWidthMap(double[] map) {
        this.printableAsciiWidthMap = map;
        return this;
    }

    public String getCompleteFontName() {
        if (this.familyName == null) {
            return this.name;
        }
        return this.name + "-" + this.familyName;
    }

    public String getName() {
        return this.name;
    }

    public Font setName(String name) {
        this.name = name;
        return this;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public Font setFamilyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    public Path getFontFile() {
        return this.fontFile;
    }

    public String getFontFileName() {
        return this.fontFile.getFileName().toString();
    }

    public Font setFontFile(Path fontFile) {
        this.fontFile = fontFile;
        return this;
    }
}

