/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import org.snmp4j.smi.OID;

public final class SnmpConstants {
    public static final int DEFAULT_COMMAND_RESPONDER_PORT = 161;
    public static final int DEFAULT_NOTIFICATION_RECEIVER_PORT = 162;
    public static final int MIN_PDU_LENGTH = 484;
    public static final int version1 = 0;
    public static final int version2c = 1;
    public static final int version3 = 3;
    public static final int SNMP_ERROR_SUCCESS = 0;
    public static final int SNMP_ERROR_TOO_BIG = 1;
    public static final int SNMP_ERROR_NO_SUCH_NAME = 2;
    public static final int SNMP_ERROR_BAD_VALUE = 3;
    public static final int SNMP_ERROR_READ_ONLY = 4;
    public static final int SNMP_ERROR_GENERAL_ERROR = 5;
    public static final int SNMP_ERROR_NO_ACCESS = 6;
    public static final int SNMP_ERROR_WRONG_TYPE = 7;
    public static final int SNMP_ERROR_WRONG_LENGTH = 8;
    public static final int SNMP_ERROR_WRONG_ENCODING = 9;
    public static final int SNMP_ERROR_WRONG_VALUE = 10;
    public static final int SNMP_ERROR_NO_CREATION = 11;
    public static final int SNMP_ERROR_INCONSISTENT_VALUE = 12;
    public static final int SNMP_ERROR_RESOURCE_UNAVAILABLE = 13;
    public static final int SNMP_ERROR_COMMIT_FAILED = 14;
    public static final int SNMP_ERROR_UNDO_FAILED = 15;
    public static final int SNMP_ERROR_AUTHORIZATION_ERROR = 16;
    public static final int SNMP_ERROR_NOT_WRITEABLE = 17;
    public static final int SNMP_ERROR_INCONSISTENT_NAME = 18;
    public static final int SNMP_MP_OK = 0;
    public static final int SNMP_MP_ERROR = -1400;
    public static final int SNMP_MP_UNSUPPORTED_SECURITY_MODEL = -1402;
    public static final int SNMP_MP_NOT_IN_TIME_WINDOW = -1403;
    public static final int SNMP_MP_DOUBLED_MESSAGE = -1404;
    public static final int SNMP_MP_INVALID_MESSAGE = -1405;
    public static final int SNMP_MP_INVALID_ENGINEID = -1406;
    public static final int SNMP_MP_NOT_INITIALIZED = -1407;
    public static final int SNMP_MP_PARSE_ERROR = -1408;
    public static final int SNMP_MP_UNKNOWN_MSGID = -1409;
    public static final int SNMP_MP_MATCH_ERROR = -1410;
    public static final int SNMP_MP_COMMUNITY_ERROR = -1411;
    public static final int SNMP_MP_WRONG_USER_NAME = -1412;
    public static final int SNMP_MP_BUILD_ERROR = -1413;
    public static final int SNMP_MP_USM_ERROR = -1414;
    public static final int SNMP_MP_UNKNOWN_PDU_HANDLERS = -1415;
    public static final int SNMP_MP_UNAVAILABLE_CONTEXT = -1416;
    public static final int SNMP_MP_UNKNOWN_CONTEXT = -1417;
    public static final int SNMP_MP_REPORT_SENT = -1418;
    public static final int SNMPv1v2c_CSM_OK = 0;
    public static final int SNMPv1v2c_CSM_BAD_COMMUNITY_NAME = 1501;
    public static final int SNMPv1v2c_CSM_BAD_COMMUNITY_USE = 1502;
    public static final int SNMPv3_USM_OK = 0;
    public static final int SNMPv3_USM_ERROR = 1401;
    public static final int SNMPv3_USM_UNSUPPORTED_SECURITY_LEVEL = 1403;
    public static final int SNMPv3_USM_UNKNOWN_SECURITY_NAME = 1404;
    public static final int SNMPv3_USM_ENCRYPTION_ERROR = 1405;
    public static final int SNMPv3_USM_DECRYPTION_ERROR = 1406;
    public static final int SNMPv3_USM_AUTHENTICATION_ERROR = 1407;
    public static final int SNMPv3_USM_AUTHENTICATION_FAILURE = 1408;
    public static final int SNMPv3_USM_PARSE_ERROR = 1409;
    public static final int SNMPv3_USM_UNKNOWN_ENGINEID = 1410;
    public static final int SNMPv3_USM_NOT_IN_TIME_WINDOW = 1411;
    public static final int SNMPv3_USM_UNSUPPORTED_AUTHPROTOCOL = 1412;
    public static final int SNMPv3_USM_UNSUPPORTED_PRIVPROTOCOL = 1413;
    public static final int SNMPv3_USM_ADDRESS_ERROR = 1414;
    public static final OID usmStatsUnsupportedSecLevels = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1, 1, 0});
    public static final OID usmStatsNotInTimeWindows = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1, 2, 0});
    public static final OID usmStatsUnknownUserNames = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1, 3, 0});
    public static final OID usmStatsUnknownEngineIDs = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1, 4, 0});
    public static final OID usmStatsWrongDigests = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1, 5, 0});
    public static final OID usmStatsDecryptionErrors = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1, 6, 0});
    public static final OID snmpUnknownSecurityModels = new OID(new int[]{1, 3, 6, 1, 6, 3, 11, 2, 1, 1, 0});
    public static final OID snmpInvalidMsgs = new OID(new int[]{1, 3, 6, 1, 6, 3, 11, 2, 1, 2, 0});
    public static final OID snmpUnknownPDUHandlers = new OID(new int[]{1, 3, 6, 1, 6, 3, 11, 2, 1, 3, 0});
    public static final OID snmpInPkts = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 1, 0});
    public static final OID snmpInBadVersions = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 3, 0});
    public static final OID snmpInBadCommunityNames = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 4, 0});
    public static final OID snmpInBadCommunityUses = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 5, 0});
    public static final OID snmpInASNParseErrs = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 6, 0});
    public static final OID snmpSilentDrops = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 31, 0});
    public static final OID snmpProxyDrops = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 32, 0});
    public static final OID snmpTrapOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 4, 1, 0});
    public static final OID snmpTrapEnterprise = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 4, 3, 0});
    public static final OID snmpTraps = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5});
    public static final OID coldStart = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 1});
    public static final OID warmStart = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 2});
    public static final OID authenticationFailure = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 5});
    public static final OID linkDown = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 3});
    public static final OID linkUp = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 5, 4});
    public static final OID sysDescr = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 1, 0});
    public static final OID sysObjectID = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 2, 0});
    public static final OID sysUpTime = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 3, 0});
    public static final OID sysContact = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 4, 0});
    public static final OID sysName = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 5, 0});
    public static final OID sysLocation = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 6, 0});
    public static final OID sysServices = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 7, 0});
    public static final OID sysOREntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 9, 1});
    public static final OID snmpUnavailableContexts = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 4, 0});
    public static final OID snmpUnknownContexts = new OID(new int[]{1, 3, 6, 1, 6, 3, 12, 1, 5, 0});
    public static final OID snmpTrapAddress = new OID(new int[]{1, 3, 6, 1, 6, 3, 18, 1, 3, 0});
    public static final OID snmpTrapCommunity = new OID(new int[]{1, 3, 6, 1, 6, 3, 18, 1, 4, 0});
    public static final OID zeroDotZero = new OID(new int[]{0, 0});
    public static final OID snmpSetSerialNo = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 6, 1, 0});
    public static final String[] SNMP_ERROR_MESSAGES = new String[]{"Success", "PDU encoding too big", "No such name", "Bad value", "Variable is read-only", "General variable binding error", "No access", "Wrong type", "Request PDU has incorrect length", "Request PDU has wrong encoding", "Wrong value", "Unable to create object", "Inconsistent value", "Resource unavailable", "Commit failed", "Undo failed", "Authorization error", "Not writable", "Inconsistent naming used"};
    public static String[][] MP_ERROR_MESSAGES = new String[][]{{"-1400", "MP error"}, {"-1402", "Unsupported security model"}, {"-1403", "Message not in time window"}, {"-1404", "Doubled message"}, {"-1405", "Invalid message"}, {"-1406", "Invalid engine ID"}, {"-1407", "MP not initialized"}, {"-1408", "MP parse error"}, {"-1409", "Unknown message ID"}, {"-1410", "MP match error"}, {"-1411", "MP community error"}, {"-1412", "Wrong user name"}, {"-1413", "MP build error"}, {"-1414", "USM error"}, {"-1415", "Unknown PDU handles"}, {"-1416", "Unavailable context"}, {"-1417", "Unknown context"}, {"-1418", "Report sent"}};
    public static String[][] USM_ERROR_MESSAGES = new String[][]{{"0", "USM OK"}, {"1401", "USM error"}, {"1403", "Unsupported security level"}, {"1404", "Unknown security name"}, {"1405", "Encryption error"}, {"1406", "Decryption error"}, {"1407", "Authentication error"}, {"1408", "Authentication failure"}, {"1409", "USM parse error"}, {"1410", "Unknown engine ID"}, {"1411", "Not in time window"}, {"1412", "Unsupported authentication protocol"}, {"1413", "Unsupported privacy protocol"}, {"1414", "Address error"}};

    public static String mpErrorMessage(int status) {
        String s = "" + status;
        for (int i = 0; i < MP_ERROR_MESSAGES.length; ++i) {
            if (!s.equals(MP_ERROR_MESSAGES[i][0])) continue;
            return MP_ERROR_MESSAGES[i][1];
        }
        return s;
    }

    public static String usmErrorMessage(int status) {
        String s = "" + status;
        for (int i = 0; i < USM_ERROR_MESSAGES.length; ++i) {
            if (!s.equals(USM_ERROR_MESSAGES[i][0])) continue;
            return USM_ERROR_MESSAGES[i][1];
        }
        return s;
    }

    public static int getGenericTrapID(OID oid) {
        if (oid == null || oid.size() != snmpTraps.size() + 1) {
            return -1;
        }
        if (oid.leftMostCompare(snmpTraps.size(), snmpTraps) == 0) {
            return oid.get(oid.size() - 1) - 1;
        }
        return -1;
    }

    public static OID getTrapOID(OID enterprise, int genericID, int specificID) {
        OID oid;
        if (genericID != 6) {
            oid = new OID(snmpTraps);
            oid.append(genericID + 1);
        } else {
            oid = new OID(enterprise);
            oid.append(0);
            oid.append(specificID);
        }
        return oid;
    }
}

