/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.properties;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.validator.constraints.Range;

public abstract class RabbitCommonProperties {
    public static final String DEAD_LETTER_EXCHANGE = "DLX";
    private String exchangeType = "topic";
    private boolean declareExchange = true;
    private boolean exchangeDurable = true;
    private boolean exchangeAutoDelete = false;
    private boolean delayedExchange = false;
    private boolean queueNameGroupOnly = false;
    private boolean bindQueue = true;
    private String bindingRoutingKey;
    private String bindingRoutingKeyDelimiter;
    private Integer ttl;
    private Integer expires;
    private Integer maxLength;
    private Integer maxLengthBytes;
    private Integer maxPriority;
    private String deadLetterQueueName;
    private String deadLetterExchange;
    private String deadLetterExchangeType = "direct";
    private boolean declareDlx = true;
    private String deadLetterRoutingKey;
    private Integer dlqTtl;
    private Integer dlqExpires;
    private Integer dlqMaxLength;
    private Integer dlqMaxLengthBytes;
    private Integer dlqMaxPriority;
    private String dlqDeadLetterExchange;
    private String dlqDeadLetterRoutingKey;
    private boolean autoBindDlq;
    private String prefix = "";
    private boolean lazy;
    private boolean dlqLazy;
    private String overflowBehavior;
    private String dlqOverflowBehavior;
    private Map<String, String> queueBindingArguments = new HashMap<String, String>();
    private Map<String, String> dlqBindingArguments = new HashMap<String, String>();
    private QuorumConfig quorum = new QuorumConfig();
    private QuorumConfig dlqQuorum = new QuorumConfig();
    private boolean singleActiveConsumer;
    private boolean dlqSingleActiveConsumer;
    private String streamStreamMessageConverterBeanName;

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public boolean isDeclareExchange() {
        return this.declareExchange;
    }

    public void setDeclareExchange(boolean declareExchange) {
        this.declareExchange = declareExchange;
    }

    public boolean isExchangeDurable() {
        return this.exchangeDurable;
    }

    public void setExchangeDurable(boolean exchangeDurable) {
        this.exchangeDurable = exchangeDurable;
    }

    public boolean isExchangeAutoDelete() {
        return this.exchangeAutoDelete;
    }

    public void setExchangeAutoDelete(boolean exchangeAutoDelete) {
        this.exchangeAutoDelete = exchangeAutoDelete;
    }

    public boolean isDelayedExchange() {
        return this.delayedExchange;
    }

    public void setDelayedExchange(boolean delayedExchange) {
        this.delayedExchange = delayedExchange;
    }

    public boolean isQueueNameGroupOnly() {
        return this.queueNameGroupOnly;
    }

    public void setQueueNameGroupOnly(boolean queueNameGroupOnly) {
        this.queueNameGroupOnly = queueNameGroupOnly;
    }

    public boolean isBindQueue() {
        return this.bindQueue;
    }

    public void setBindQueue(boolean bindQueue) {
        this.bindQueue = bindQueue;
    }

    public String getBindingRoutingKey() {
        return this.bindingRoutingKey;
    }

    public void setBindingRoutingKey(String routingKey) {
        this.bindingRoutingKey = routingKey;
    }

    public String getBindingRoutingKeyDelimiter() {
        return this.bindingRoutingKeyDelimiter;
    }

    public void setBindingRoutingKeyDelimiter(String bindingRoutingKeyDelimiter) {
        this.bindingRoutingKeyDelimiter = bindingRoutingKeyDelimiter;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public Integer getExpires() {
        return this.expires;
    }

    public void setExpires(Integer expires) {
        this.expires = expires;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getMaxLengthBytes() {
        return this.maxLengthBytes;
    }

    public void setMaxLengthBytes(Integer maxLengthBytes) {
        this.maxLengthBytes = maxLengthBytes;
    }

    @Range(min=0L, max=255L)
    public @Range(min=0L, max=255L) Integer getMaxPriority() {
        return this.maxPriority;
    }

    public void setMaxPriority(Integer maxPriority) {
        this.maxPriority = maxPriority;
    }

    public String getDeadLetterQueueName() {
        return this.deadLetterQueueName;
    }

    public void setDeadLetterQueueName(String deadLetterQueueName) {
        this.deadLetterQueueName = deadLetterQueueName;
    }

    public String getDeadLetterExchange() {
        return this.deadLetterExchange;
    }

    public void setDeadLetterExchange(String deadLetterExchange) {
        this.deadLetterExchange = deadLetterExchange;
    }

    public String getDeadLetterExchangeType() {
        return this.deadLetterExchangeType;
    }

    public void setDeadLetterExchangeType(String deadLetterExchangeType) {
        this.deadLetterExchangeType = deadLetterExchangeType;
    }

    public boolean isDeclareDlx() {
        return this.declareDlx;
    }

    public void setDeclareDlx(boolean declareDlx) {
        this.declareDlx = declareDlx;
    }

    public String getDeadLetterRoutingKey() {
        return this.deadLetterRoutingKey;
    }

    public void setDeadLetterRoutingKey(String deadLetterRoutingKey) {
        this.deadLetterRoutingKey = deadLetterRoutingKey;
    }

    public Integer getDlqTtl() {
        return this.dlqTtl;
    }

    public void setDlqTtl(Integer dlqTtl) {
        this.dlqTtl = dlqTtl;
    }

    public Integer getDlqExpires() {
        return this.dlqExpires;
    }

    public void setDlqExpires(Integer dlqExpires) {
        this.dlqExpires = dlqExpires;
    }

    public Integer getDlqMaxLength() {
        return this.dlqMaxLength;
    }

    public void setDlqMaxLength(Integer dlqMaxLength) {
        this.dlqMaxLength = dlqMaxLength;
    }

    public Integer getDlqMaxLengthBytes() {
        return this.dlqMaxLengthBytes;
    }

    public void setDlqMaxLengthBytes(Integer dlqMaxLengthBytes) {
        this.dlqMaxLengthBytes = dlqMaxLengthBytes;
    }

    public Integer getDlqMaxPriority() {
        return this.dlqMaxPriority;
    }

    public void setDlqMaxPriority(Integer dlqMaxPriority) {
        this.dlqMaxPriority = dlqMaxPriority;
    }

    public String getDlqDeadLetterExchange() {
        return this.dlqDeadLetterExchange;
    }

    public void setDlqDeadLetterExchange(String dlqDeadLetterExchange) {
        this.dlqDeadLetterExchange = dlqDeadLetterExchange;
    }

    public String getDlqDeadLetterRoutingKey() {
        return this.dlqDeadLetterRoutingKey;
    }

    public void setDlqDeadLetterRoutingKey(String dlqDeadLetterRoutingKey) {
        this.dlqDeadLetterRoutingKey = dlqDeadLetterRoutingKey;
    }

    public boolean isAutoBindDlq() {
        return this.autoBindDlq;
    }

    public void setAutoBindDlq(boolean autoBindDlq) {
        this.autoBindDlq = autoBindDlq;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isDlqLazy() {
        return this.dlqLazy;
    }

    public void setDlqLazy(boolean dlqLazy) {
        this.dlqLazy = dlqLazy;
    }

    public String getOverflowBehavior() {
        return this.overflowBehavior;
    }

    public void setOverflowBehavior(String overflowBehavior) {
        this.overflowBehavior = overflowBehavior;
    }

    public String getDlqOverflowBehavior() {
        return this.dlqOverflowBehavior;
    }

    public void setDlqOverflowBehavior(String dlqOverflowBehavior) {
        this.dlqOverflowBehavior = dlqOverflowBehavior;
    }

    public Map<String, String> getQueueBindingArguments() {
        return this.queueBindingArguments;
    }

    public void setQueueBindingArguments(Map<String, String> queueBindingArguments) {
        this.queueBindingArguments = queueBindingArguments;
    }

    public Map<String, String> getDlqBindingArguments() {
        return this.dlqBindingArguments;
    }

    public void setDlqBindingArguments(Map<String, String> dlqBindingArguments) {
        this.dlqBindingArguments = dlqBindingArguments;
    }

    public QuorumConfig getQuorum() {
        return this.quorum;
    }

    public void setQuorum(QuorumConfig quorum) {
        this.quorum = quorum;
    }

    public QuorumConfig getDlqQuorum() {
        return this.dlqQuorum;
    }

    public void setDlqQuorum(QuorumConfig dlqQuorum) {
        this.dlqQuorum = dlqQuorum;
    }

    public boolean isSingleActiveConsumer() {
        return this.singleActiveConsumer;
    }

    public void setSingleActiveConsumer(boolean singleActiveConsumer) {
        this.singleActiveConsumer = singleActiveConsumer;
    }

    public boolean isDlqSingleActiveConsumer() {
        return this.dlqSingleActiveConsumer;
    }

    public void setDlqSingleActiveConsumer(boolean dlqSingleActiveConsumer) {
        this.dlqSingleActiveConsumer = dlqSingleActiveConsumer;
    }

    public String getStreamStreamMessageConverterBeanName() {
        return this.streamStreamMessageConverterBeanName;
    }

    public void setStreamStreamMessageConverterBeanName(String streamStreamMessageConverterBeanName) {
        this.streamStreamMessageConverterBeanName = streamStreamMessageConverterBeanName;
    }

    public static class QuorumConfig {
        private boolean enabled;
        private Integer initialGroupSize;
        private Integer deliveryLimit;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getInitialGroupSize() {
            return this.initialGroupSize;
        }

        public void setInitialGroupSize(Integer initialGroupSize) {
            this.initialGroupSize = initialGroupSize;
        }

        public Integer getDeliveryLimit() {
            return this.deliveryLimit;
        }

        public void setDeliveryLimit(Integer deliveryLimit) {
            this.deliveryLimit = deliveryLimit;
        }
    }
}

