/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.schild.jave.EncoderException;
import ws.schild.jave.InputFormatException;
import ws.schild.jave.info.AudioInfo;
import ws.schild.jave.info.MultimediaInfo;
import ws.schild.jave.info.VideoInfo;
import ws.schild.jave.info.VideoSize;
import ws.schild.jave.process.ProcessLocator;
import ws.schild.jave.process.ProcessWrapper;
import ws.schild.jave.process.ffmpeg.DefaultFFMPEGLocator;
import ws.schild.jave.utils.RBufferedReader;

public class MultimediaObject {
    private static final Logger LOG = LoggerFactory.getLogger(MultimediaObject.class);
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)x(\\d+)", 2);
    private static final Pattern FRAME_RATE_PATTERN = Pattern.compile("([\\d.]+)\\s+(?:fps|tbr)", 2);
    private static final Pattern BIT_RATE_PATTERN = Pattern.compile("(\\d+)\\s+kb/s", 2);
    private static final Pattern SAMPLING_RATE_PATTERN = Pattern.compile("(\\d+)\\s+Hz", 2);
    private static final Pattern CHANNELS_PATTERN = Pattern.compile("(mono|stereo|quad)", 2);
    private final ProcessLocator locator;
    private File inputFile;
    private URL inputURL;
    private boolean readURLOnce = false;

    public void setReadURLOnce(boolean readURLOnce) {
        this.readURLOnce = readURLOnce;
    }

    public MultimediaObject(File input) {
        this.locator = new DefaultFFMPEGLocator();
        this.inputFile = input;
    }

    public MultimediaObject(URL input) {
        this.locator = new DefaultFFMPEGLocator();
        this.inputURL = input;
    }

    public MultimediaObject(URL input, boolean readURLOnce) {
        this.locator = new DefaultFFMPEGLocator();
        this.inputURL = input;
        this.readURLOnce = readURLOnce;
    }

    public File getFile() {
        return this.inputFile;
    }

    public URL getURL() {
        return this.inputURL;
    }

    public void setFile(File file) {
        this.inputFile = file;
    }

    public void setUR(URL input) {
        this.inputURL = input;
    }

    public boolean isURL() {
        return this.inputURL != null;
    }

    public MultimediaObject(File input, ProcessLocator locator) {
        this.locator = locator;
        this.inputFile = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultimediaInfo getInfo() throws InputFormatException, EncoderException {
        if (this.isURL() || this.inputFile.canRead()) {
            ProcessWrapper ffmpeg = this.locator.createExecutor();
            ffmpeg.addArgument("-i");
            ffmpeg.addArgument(this.toString());
            try {
                ffmpeg.execute();
            }
            catch (IOException e) {
                throw new EncoderException(e);
            }
            try {
                RBufferedReader reader = new RBufferedReader(new InputStreamReader(ffmpeg.getErrorStream()));
                if (this.isURL()) {
                    MultimediaInfo multimediaInfo = this.parseMultimediaInfo(this.inputURL.toString(), reader);
                    return multimediaInfo;
                }
                MultimediaInfo multimediaInfo = this.parseMultimediaInfo(this.inputFile.getAbsolutePath(), reader);
                return multimediaInfo;
            }
            finally {
                ffmpeg.destroy();
            }
        }
        throw new EncoderException("Input file not found <" + this.inputFile.getAbsolutePath() + ">");
    }

    private MultimediaInfo parseMultimediaInfo(String source, RBufferedReader reader) throws InputFormatException, EncoderException {
        MultimediaInfo info;
        block31: {
            Pattern p1 = Pattern.compile("^\\s*Input #0, (\\w+).+$\\s*", 2);
            Pattern p21 = Pattern.compile("^\\s*Duration:.*$", 2);
            Pattern p22 = Pattern.compile("^\\s*Duration: (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d\\d).*$", 2);
            Pattern p3 = Pattern.compile("^\\s*Stream #\\S+: ((?:Audio)|(?:Video)|(?:Data)): (.*)\\s*$", 2);
            Pattern p4 = Pattern.compile("^\\s*Metadata:", 2);
            info = null;
            try {
                String line;
                int step = 0;
                block9: do {
                    line = reader.readLine();
                    LOG.debug("Output line: {}", (Object)line);
                    if (line == null) break block31;
                    switch (step) {
                        case 0: {
                            String token = source + ": ";
                            if (line.startsWith(token)) {
                                String message = line.substring(token.length());
                                throw new InputFormatException(message);
                            }
                            Matcher m = p1.matcher(line);
                            if (!m.matches()) break;
                            String format = m.group(1);
                            info = new MultimediaInfo();
                            info.setFormat(format);
                            ++step;
                            break;
                        }
                        case 1: {
                            Matcher m1 = p21.matcher(line);
                            Matcher m2 = p22.matcher(line);
                            if (!m1.matches()) break;
                            if (m2.matches()) {
                                long hours = Integer.parseInt(m2.group(1));
                                long minutes = Integer.parseInt(m2.group(2));
                                long seconds = Integer.parseInt(m2.group(3));
                                long dec = Integer.parseInt(m2.group(4));
                                long duration = dec * 10L + seconds * 1000L + minutes * 60L * 1000L + hours * 60L * 60L * 1000L;
                                info.setDuration(duration);
                                ++step;
                                break;
                            }
                            LOG.warn("Invalid duration found {}", (Object)line);
                            ++step;
                            break;
                        }
                        case 2: {
                            boolean parsed;
                            int i;
                            Matcher m = p3.matcher(line);
                            if (!m.matches()) break;
                            String type = m.group(1);
                            String specs = m.group(2);
                            if ("Video".equalsIgnoreCase(type)) {
                                VideoInfo video = new VideoInfo();
                                StringTokenizer st = new StringTokenizer(specs, ",");
                                i = 0;
                                while (st.hasMoreTokens()) {
                                    String token = st.nextToken().trim();
                                    if (i == 0) {
                                        video.setDecoder(token);
                                    } else {
                                        parsed = false;
                                        Matcher m2 = SIZE_PATTERN.matcher(token);
                                        if (!parsed && m2.find()) {
                                            int width = Integer.parseInt(m2.group(1));
                                            int height = Integer.parseInt(m2.group(2));
                                            video.setSize(new VideoSize(width, height));
                                            parsed = true;
                                        }
                                        m2 = FRAME_RATE_PATTERN.matcher(token);
                                        if (!parsed && m2.find()) {
                                            try {
                                                float frameRate = Float.parseFloat(m2.group(1));
                                                video.setFrameRate(frameRate);
                                            }
                                            catch (NumberFormatException e) {
                                                LOG.info("Invalid frame rate value: " + m2.group(1), (Throwable)e);
                                            }
                                            parsed = true;
                                        }
                                        m2 = BIT_RATE_PATTERN.matcher(token);
                                        if (!parsed && m2.find()) {
                                            int bitRate = Integer.parseInt(m2.group(1));
                                            video.setBitRate(bitRate * 1000);
                                            parsed = true;
                                        }
                                    }
                                    ++i;
                                }
                                info.setVideo(video);
                                break;
                            }
                            if (!"Audio".equalsIgnoreCase(type)) continue block9;
                            AudioInfo audio = new AudioInfo();
                            StringTokenizer st = new StringTokenizer(specs, ",");
                            i = 0;
                            while (st.hasMoreTokens()) {
                                String token = st.nextToken().trim();
                                if (i == 0) {
                                    audio.setDecoder(token);
                                } else {
                                    parsed = false;
                                    Matcher m2 = SAMPLING_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int samplingRate = Integer.parseInt(m2.group(1));
                                        audio.setSamplingRate(samplingRate);
                                        parsed = true;
                                    }
                                    m2 = CHANNELS_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        String ms = m2.group(1);
                                        if ("mono".equalsIgnoreCase(ms)) {
                                            audio.setChannels(1);
                                        } else if ("stereo".equalsIgnoreCase(ms)) {
                                            audio.setChannels(2);
                                        } else if ("quad".equalsIgnoreCase(ms)) {
                                            audio.setChannels(4);
                                        }
                                        parsed = true;
                                    }
                                    m2 = BIT_RATE_PATTERN.matcher(token);
                                    if (!parsed && m2.find()) {
                                        int bitRate = Integer.parseInt(m2.group(1));
                                        audio.setBitRate(bitRate * 1000);
                                        parsed = true;
                                    }
                                }
                                ++i;
                            }
                            info.setAudio(audio);
                            break;
                        }
                    }
                } while (!line.startsWith("frame="));
                reader.reinsertLine(line);
            }
            catch (IOException e) {
                throw new EncoderException(e);
            }
        }
        if (info == null) {
            throw new InputFormatException();
        }
        return info;
    }

    public boolean isReadURLOnce() {
        return this.readURLOnce;
    }

    public String toString() {
        if (this.isURL()) {
            return this.getURL().toString();
        }
        return this.getFile().getAbsolutePath();
    }
}

