/*
 * Decompiled with CFR 0.152.
 */
package ws.schild.jave.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ws.schild.jave.filters.FilterChain;
import ws.schild.jave.filters.VideoFilter;

public class FilterGraph
implements VideoFilter {
    private Optional<String> swsFlags = Optional.empty();
    private List<FilterChain> chains = new ArrayList<FilterChain>();

    public FilterGraph() {
    }

    public FilterGraph(FilterChain ... chains) {
        this();
        this.chains = new ArrayList<FilterChain>(Arrays.asList(chains));
    }

    public FilterGraph(String swsFlags, FilterChain ... chains) {
        this(chains);
        this.swsFlags = Optional.of(swsFlags);
    }

    public FilterGraph addChain(FilterChain chain) {
        this.chains.add(chain);
        return this;
    }

    public FilterGraph setSwsFlags(String swsFlags) {
        this.swsFlags = Optional.of(swsFlags);
        return this;
    }

    @Override
    public String getExpression() {
        return this.swsFlags.map(s -> "sws_flags=" + s + ";").orElse("") + this.chains.stream().map(VideoFilter::getExpression).collect(Collectors.joining(";"));
    }
}

