/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.cache;

import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.cache.CacheObject;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCacheManager
implements CacheManager {
    private final ConcurrentMap<String, AbstractCacheObject<?>> caches = new ConcurrentHashMap();

    @Override
    public <K> @Nullable CacheObject<K> getCache(String name) {
        return (CacheObject)this.caches.get(name);
    }

    @Override
    public <K> @NonNull CacheObject<K> createCache(String name, Long expireTime, TimeUnit timeUnit) {
        AbstractCacheObject<K> cacheObject = this.doCreateCache(name, expireTime, timeUnit);
        AbstractCacheObject<K> old = this.caches.put(name, cacheObject);
        if (Objects.nonNull(old)) {
            this.invalidate(old);
        }
        return cacheObject;
    }

    @Override
    public void removeCache(String name) {
        this.caches.computeIfPresent(name, (k, v) -> {
            this.invalidate((AbstractCacheObject<?>)v);
            return null;
        });
    }

    @Override
    public void clearAll() {
        ArrayList allCaches = new ArrayList(this.caches.values());
        this.caches.clear();
        allCaches.forEach(this::invalidate);
    }

    protected abstract <K> @NonNull AbstractCacheObject<K> doCreateCache(String var1, Long var2, TimeUnit var3);

    protected void invalidate(AbstractCacheObject<?> cacheObject) {
        cacheObject.setInvalid(true);
        cacheObject.clear();
    }

    protected static abstract class AbstractCacheObject<K>
    implements CacheObject<K> {
        private volatile boolean invalid = false;
        private final String name;

        @Override
        public boolean isInvalid() {
            return this.invalid;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public AbstractCacheObject(String name) {
            this.name = name;
        }

        public void setInvalid(boolean invalid) {
            this.invalid = invalid;
        }
    }
}

