/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.cache;

import cn.crane4j.core.cache.CacheDefinition;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.cache.CacheObject;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDelegate;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableContainer<K>
implements ContainerDelegate<K> {
    private static final Logger log = LoggerFactory.getLogger(CacheableContainer.class);
    private final Container<K> container;
    private final CacheDefinition cacheDefinition;
    private final CacheManager cacheManager;
    private volatile CacheObject<K> currentCache;

    @Override
    public Map<K, ?> get(Collection<K> keys) {
        CacheObject<K> current = this.getCurrentCache();
        Map caches = current.getAll(keys);
        if (caches.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("get none cached keys [{}] from container [{}]", (Object)keys, (Object)this.container.getNamespace());
            }
            Map<K, ?> values = this.container.get(keys);
            current.putAll(values);
            return values;
        }
        if ((keys = (Collection)keys.stream().filter(k -> !caches.containsKey(k)).collect(Collectors.toSet())).isEmpty()) {
            return caches;
        }
        if (log.isDebugEnabled()) {
            log.debug("get none cached keys [{}] from container [{}]", (Object)keys, (Object)this.container.getNamespace());
        }
        Map<K, ?> values = this.container.get(keys);
        current.putAll(values);
        caches.putAll(values);
        return caches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObject<K> getCurrentCache() {
        if (this.currentCache == null || this.currentCache.isInvalid()) {
            CacheableContainer cacheableContainer = this;
            synchronized (cacheableContainer) {
                if (this.currentCache == null || this.currentCache.isInvalid()) {
                    if (log.isDebugEnabled()) {
                        log.debug("recreate cache object for container [{}], because it is invalid or null", (Object)this.container.getNamespace());
                    }
                    this.currentCache = this.cacheManager.createCache(this.cacheDefinition.getName(), this.cacheDefinition.getExpireTime(), this.cacheDefinition.getTimeUnit());
                }
            }
        }
        return this.currentCache;
    }

    @Override
    public Container<K> getContainer() {
        return this.container;
    }

    public CacheDefinition getCacheDefinition() {
        return this.cacheDefinition;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public CacheableContainer(Container<K> container, CacheDefinition cacheDefinition, CacheManager cacheManager) {
        this.container = container;
        this.cacheDefinition = cacheDefinition;
        this.cacheManager = cacheManager;
    }
}

