/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.condition;

import cn.crane4j.core.condition.AbstractConditionParser;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ConfigurationUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractPropertyConditionParser<A extends Annotation>
extends AbstractConditionParser<A> {
    private final PropertyOperator propertyOperator;

    protected AbstractPropertyConditionParser(AnnotationFinder annotationFinder, Class<A> annotationType, PropertyOperator propertyOperator) {
        super(annotationFinder, annotationType);
        this.propertyOperator = propertyOperator;
    }

    @Override
    protected @Nullable AbstractConditionParser.AbstractCondition createCondition(AnnotatedElement element, A annotation) {
        String property = this.getPropertyName(element, annotation);
        property = ConfigurationUtil.getElementIdentifier(element, property);
        Asserts.isNotEmpty(property, "The property to be checked is not specified in the @{} on {}", this.annotationType.getSimpleName());
        return new PropertyValueCondition(property);
    }

    protected abstract String getPropertyName(AnnotatedElement var1, A var2);

    protected abstract boolean checkPropertyValue(Object var1);

    private class PropertyValueCondition
    extends AbstractConditionParser.AbstractCondition {
        private final String property;

        @Override
        public boolean test(Object target, KeyTriggerOperation operation) {
            Object value = AbstractPropertyConditionParser.this.propertyOperator.readProperty(target.getClass(), target, this.property);
            return AbstractPropertyConditionParser.this.checkPropertyValue(value);
        }

        public PropertyValueCondition(String property) {
            this.property = property;
        }
    }
}

