/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDefinition;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.LimitedContainer;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.core.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContainerManager
implements ContainerManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultContainerManager.class);
    protected final ConcurrentMap<Object, Object> containerMap = new ConcurrentHashMap<Object, Object>(64);
    protected final List<ContainerLifecycleProcessor> containerLifecycleProcessorList = new ArrayList<ContainerLifecycleProcessor>();
    protected final Map<String, ContainerProvider> containerProviderMap = new LinkedHashMap<String, ContainerProvider>();
    private boolean allowContainerOverriding = false;

    @Override
    public boolean registerContainerLifecycleProcessor(ContainerLifecycleProcessor lifecycle) {
        if (this.containerLifecycleProcessorList.contains(lifecycle)) {
            return false;
        }
        return this.containerLifecycleProcessorList.add(lifecycle);
    }

    @Override
    public Collection<ContainerLifecycleProcessor> getContainerLifecycleProcessors() {
        return this.containerLifecycleProcessorList;
    }

    @Override
    public void registerContainerProvider(String name, ContainerProvider containerProvider) {
        this.containerProviderMap.put(name, containerProvider);
    }

    @Override
    public <T extends ContainerProvider> @Nullable T getContainerProvider(String name) {
        return (T)this.containerProviderMap.get(name);
    }

    @Override
    public @Nullable ContainerDefinition registerContainer(ContainerDefinition definition) {
        Asserts.isNotNull(definition, "definition must not null", new Object[0]);
        String namespace = definition.getNamespace();
        if (StringUtils.isEmpty(namespace)) {
            log.warn("container namespace is empty, it will be ignored");
        }
        if (StringUtils.isNotEmpty(namespace) && this.containerMap.containsKey(namespace)) {
            Asserts.isTrue(this.allowContainerOverriding, "The container [{}] has been registered, and the container overriding is not allowed.", namespace);
            log.warn("The container [{}] already exists, it will be overridden", (Object)namespace);
        }
        Object key = this.getCacheKey(namespace);
        this.containerMap.compute(key, (k, t) -> {
            ContainerDefinition newDefinition = ConfigurationUtil.triggerWhenRegistered(definition, key.toString(), t, this.containerLifecycleProcessorList, log);
            if (Objects.isNull(newDefinition)) {
                return t;
            }
            if (Objects.nonNull(t)) {
                ConfigurationUtil.triggerWhenDestroyed(t, this.containerLifecycleProcessorList);
            }
            return definition;
        });
        return definition;
    }

    @Override
    public <K> @Nullable Container<K> getContainer(String namespace) {
        if (Objects.equals(namespace, "")) {
            return Container.empty();
        }
        Object key = this.getCacheKey(namespace);
        return this.doGetContainer(key);
    }

    @Override
    public Collection<Container<Object>> getAllLimitedContainers() {
        return this.containerMap.entrySet().stream().filter(e -> e.getValue() instanceof ContainerDefinition ? ((ContainerDefinition)e.getValue()).isLimited() : e.getValue() instanceof LimitedContainer).map(e -> this.doGetContainer(e.getKey())).collect(Collectors.toList());
    }

    private <K> @Nullable Container<K> doGetContainer(Object key) {
        Object container = this.containerMap.get(key);
        if (Objects.nonNull(container) && container instanceof Container) {
            return (Container)container;
        }
        return (Container)this.containerMap.compute(key, (k, t) -> {
            ContainerDefinition definition;
            boolean isDirectRegistered = Objects.nonNull(t);
            if (isDirectRegistered && t instanceof Container) {
                return t;
            }
            ContainerDefinition containerDefinition = definition = isDirectRegistered ? (ContainerDefinition)t : this.createDefinition(k);
            if (Objects.isNull(definition)) {
                return null;
            }
            return this.createContainer(k.toString(), definition);
        });
    }

    @Override
    public boolean containsContainer(String namespace) {
        Object key = this.getCacheKey(namespace);
        if (key instanceof String) {
            return this.containerMap.containsKey(key);
        }
        CacheKey ck = (CacheKey)key;
        return Optional.ofNullable(this.containerProviderMap.get(ck.getProviderName())).map(containerProvider -> containerProvider.containsContainer(ck.getProviderName())).orElse(false);
    }

    @Override
    public void clear() {
        log.info("clear all cache for container manager");
        this.containerMap.values().forEach(t -> ConfigurationUtil.triggerWhenDestroyed(t, this.containerLifecycleProcessorList));
        this.containerMap.clear();
        this.containerProviderMap.clear();
        this.containerLifecycleProcessorList.clear();
    }

    protected @Nullable Container<Object> createContainer(String namespace, ContainerDefinition definition) {
        Container<Object> container = definition.createContainer();
        return ConfigurationUtil.triggerWhenCreated(namespace, definition, container, this.containerLifecycleProcessorList, log);
    }

    protected @Nullable ContainerDefinition createDefinition(Object cacheKey) {
        if (!(cacheKey instanceof CacheKey)) {
            return null;
        }
        CacheKey key = (CacheKey)cacheKey;
        Object containerProvider = this.getContainerProvider(key.getProviderName());
        if (Objects.isNull(containerProvider)) {
            return null;
        }
        ContainerDefinition.SimpleContainerDefinition definition = new ContainerDefinition.SimpleContainerDefinition(key.getNamespace(), key.getProviderName(), () -> containerProvider.getContainer(key.getNamespace()));
        return ConfigurationUtil.triggerWhenRegistered(definition, key.toString(), null, this.containerLifecycleProcessorList, log);
    }

    protected Object getCacheKey(String namespace) {
        int index = namespace.indexOf("&&");
        if (index < 0) {
            return namespace;
        }
        String providerName = namespace.substring(0, index);
        String containerNamespace = namespace.substring(index + 2);
        return new CacheKey(containerNamespace, providerName);
    }

    public void setAllowContainerOverriding(boolean allowContainerOverriding) {
        this.allowContainerOverriding = allowContainerOverriding;
    }

    protected static class CacheKey {
        private final String namespace;
        private final String providerName;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$providerName = this.getProviderName();
            String other$providerName = other.getProviderName();
            return !(this$providerName == null ? other$providerName != null : !this$providerName.equals(other$providerName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $providerName = this.getProviderName();
            result = result * 59 + ($providerName == null ? 43 : $providerName.hashCode());
            return result;
        }

        public CacheKey(String namespace, String providerName) {
            this.namespace = namespace;
            this.providerName = providerName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getProviderName() {
            return this.providerName;
        }
    }
}

