/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler.key;

import cn.crane4j.core.executor.handler.key.KeyResolver;
import cn.crane4j.core.parser.PropertyMapping;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.support.reflect.PropDesc;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.ClassUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ReflectiveBeanKeyResolver
implements KeyResolver {
    private final PropertyOperator propertyOperator;
    private final PropertyMapping[] propertyMappings;

    private @NonNull Object newInstance(Class<?> beanType) {
        return Map.class == beanType ? new LinkedHashMap(this.propertyMappings.length) : ClassUtils.newInstance(beanType, new Object[0]);
    }

    @Override
    public Object resolve(Object target, AssembleOperation operation) {
        Class<?> beanType = operation.getKeyType();
        Object bean = this.newInstance(beanType);
        Class<?> targetType = target.getClass();
        PropDesc targetPropDesc = this.propertyOperator.getPropertyDescriptor(targetType);
        PropDesc sourcePropDesc = this.propertyOperator.getPropertyDescriptor(beanType);
        for (PropertyMapping mapping : this.propertyMappings) {
            Object propertyValue = targetPropDesc.readProperty(target, mapping.getSource());
            sourcePropDesc.writeProperty(bean, mapping.getReference(), propertyValue);
        }
        return bean;
    }

    public ReflectiveBeanKeyResolver(PropertyOperator propertyOperator, PropertyMapping[] propertyMappings) {
        this.propertyOperator = propertyOperator;
        this.propertyMappings = propertyMappings;
    }
}

