/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler.key;

import cn.crane4j.core.executor.handler.key.KeyResolver;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReflectiveSeparablePropertyKeyResolver
implements KeyResolver {
    private final PropertyOperator propertyOperator;
    private final ConverterManager converterManager;
    private final String separator;

    @Override
    public Object resolve(Object target, AssembleOperation operation) {
        Object propertyValue = this.propertyOperator.readProperty(target.getClass(), target, operation.getKey());
        Collection<?> values = this.splitKey(propertyValue, this.separator);
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        Class<?> keyType = operation.getKeyType();
        if (Objects.isNull(keyType) || ClassUtils.isObjectOrVoid(keyType)) {
            return values;
        }
        return values.stream().map(v -> this.converterManager.convert(v, keyType)).collect(Collectors.toList());
    }

    protected @NonNull Collection<?> splitKey(@Nullable Object propertyValue, String keySplitter) {
        if (Objects.isNull(propertyValue)) {
            return Collections.emptyList();
        }
        if (propertyValue instanceof CharSequence) {
            return StringUtils.split((String)propertyValue, keySplitter);
        }
        if (propertyValue instanceof Collection) {
            return (Collection)propertyValue;
        }
        if (propertyValue.getClass().isArray()) {
            return Arrays.asList((Object[])propertyValue);
        }
        return Collections.singletonList(propertyValue);
    }

    public ReflectiveSeparablePropertyKeyResolver(PropertyOperator propertyOperator, ConverterManager converterManager, String separator) {
        this.propertyOperator = propertyOperator;
        this.converterManager = converterManager;
        this.separator = separator;
    }
}

