/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser;

import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.parser.operation.DisassembleOperation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface BeanOperations {
    public static BeanOperations empty() {
        return EmptyBeanOperations.INSTANCE;
    }

    public AnnotatedElement getSource();

    public Collection<AssembleOperation> getAssembleOperations();

    public void addAssembleOperations(AssembleOperation var1);

    public Collection<DisassembleOperation> getDisassembleOperations();

    public void addDisassembleOperations(DisassembleOperation var1);

    public boolean isActive();

    public void setActive(boolean var1);

    default public boolean isEmpty() {
        return this.getAssembleOperations().isEmpty() && this.getDisassembleOperations().isEmpty();
    }

    public static class EmptyBeanOperations
    implements BeanOperations {
        public static final EmptyBeanOperations INSTANCE = new EmptyBeanOperations();
        private final boolean active = true;
        private final boolean empty = true;
        private final AnnotatedElement source = null;
        private final List<AssembleOperation> assembleOperations = Collections.emptyList();
        private final List<DisassembleOperation> disassembleOperations = Collections.emptyList();

        @Override
        public void addAssembleOperations(AssembleOperation operation) {
            throw new UnsupportedOperationException("empty bean operation unsupported add assemble operations");
        }

        @Override
        public void addDisassembleOperations(DisassembleOperation operation) {
            throw new UnsupportedOperationException("empty bean operation unsupported add disassemble operations");
        }

        @Override
        public void setActive(boolean active) {
        }

        @Override
        public boolean isActive() {
            this.getClass();
            return true;
        }

        @Override
        public boolean isEmpty() {
            this.getClass();
            return true;
        }

        @Override
        public AnnotatedElement getSource() {
            return this.source;
        }

        public List<AssembleOperation> getAssembleOperations() {
            return this.assembleOperations;
        }

        public List<DisassembleOperation> getDisassembleOperations() {
            return this.disassembleOperations;
        }
    }
}

