/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser;

import cn.crane4j.annotation.condition.ConditionType;
import cn.crane4j.core.condition.Condition;
import cn.crane4j.core.condition.ConditionParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.TypeHierarchyBeanOperationParser;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.Sorted;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.MultiMap;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConditionalTypeHierarchyBeanOperationParser
extends TypeHierarchyBeanOperationParser {
    private final List<ConditionParser> conditionParsers = new ArrayList<ConditionParser>();

    public void registerConditionParser(ConditionParser conditionParser) {
        Asserts.isNotNull(conditionParser, "conditionParser must not null", new Object[0]);
        this.conditionParsers.remove(conditionParser);
        this.conditionParsers.add(conditionParser);
    }

    @Override
    protected BeanOperations doResolveToOperations(AnnotatedElement source) {
        BeanOperations operations = super.doResolveToOperations(source);
        MultiMap sourceWithOperations = MultiMap.arrayListMultimap();
        Stream.of(operations.getDisassembleOperations(), operations.getAssembleOperations()).flatMap(Collection::stream).filter(op -> op.getSource() instanceof AnnotatedElement).forEach(op -> sourceWithOperations.put((AnnotatedElement)op.getSource(), op));
        sourceWithOperations.asMap().forEach(this::process);
        return operations;
    }

    private void process(AnnotatedElement element, Collection<KeyTriggerOperation> operations) {
        for (KeyTriggerOperation operation : operations) {
            this.conditionParsers.stream().map(parser -> parser.parse(element, operation)).filter(CollectionUtils::isNotEmpty).forEach(conditions -> this.bindConditionToOperation((Collection<Condition>)conditions, operation));
        }
    }

    protected void bindConditionToOperation(Collection<Condition> conditions, KeyTriggerOperation operation) {
        Condition condition = conditions.size() > 1 ? conditions.stream().sorted(Comparator.comparing(Sorted::getSort)).reduce(null, this::merge) : CollectionUtils.getFirstNotNull(conditions);
        operation.setCondition(condition);
    }

    private Condition merge(@Nullable Condition prev, Condition next) {
        if (prev == null) {
            return next;
        }
        return prev.getType() == ConditionType.AND ? prev.and(next) : prev.or(next);
    }

    public List<ConditionParser> getConditionParsers() {
        return this.conditionParsers;
    }
}

