/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support;

import cn.crane4j.core.support.Sorted;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class Crane4jGlobalSorter
implements Comparator<Object> {
    public static final Crane4jGlobalSorter INSTANCE = new Crane4jGlobalSorter();
    public List<Function<Object, Integer>> keyExtractors = new ArrayList<Function<Object, Integer>>();

    public static <T> Comparator<T> comparator() {
        return INSTANCE;
    }

    public synchronized void addCompareValueExtractor(Function<Object, Integer> compareValueExtractor) {
        Objects.requireNonNull(compareValueExtractor, "compareValueExtractor must not null");
        this.keyExtractors.remove(compareValueExtractor);
        this.keyExtractors.add(compareValueExtractor);
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.getAggregatedComparator(Integer.MAX_VALUE).compare(o1, o2);
    }

    public int getSortValue(Object target, int defVal) {
        return this.getAggregatedKeyExtractor(defVal).apply(target);
    }

    private Comparator<Object> getAggregatedComparator(int defVal) {
        return Comparator.comparingInt(t -> this.getSortValue(t, defVal));
    }

    private Function<Object, Integer> getAggregatedKeyExtractor(int defVal) {
        return t -> this.keyExtractors.stream().map(extractor -> (Integer)extractor.apply(t)).filter(Objects::nonNull).findFirst().orElse(defVal);
    }

    static {
        INSTANCE.addCompareValueExtractor(t -> t instanceof Sorted ? Integer.valueOf(((Sorted)t).getSort()) : null);
    }
}

