/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support;

import cn.crane4j.core.cache.CacheDefinition;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.cache.CacheableContainer;
import cn.crane4j.core.condition.ConditionParser;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.Containers;
import cn.crane4j.core.container.ImmutableMapContainer;
import cn.crane4j.core.container.LambdaContainer;
import cn.crane4j.core.container.LimitedContainer;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import cn.crane4j.core.executor.AsyncBeanOperationExecutor;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.OrderedBeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.ConditionalTypeHierarchyBeanOperationParser;
import cn.crane4j.core.parser.TypeHierarchyBeanOperationParser;
import cn.crane4j.core.parser.handler.AssembleMethodAnnotationHandler;
import cn.crane4j.core.parser.handler.OperationAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.DataProvider;
import cn.crane4j.core.support.OperateTemplate;
import cn.crane4j.core.support.SimpleCrane4jGlobalConfiguration;
import cn.crane4j.core.support.aop.AutoOperateProxy;
import cn.crane4j.core.support.container.ContainerMethodAnnotationProcessor;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.support.operator.OperatorProxyFactory;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ConfigurationUtil;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Crane4jTemplate {
    private final Crane4jGlobalConfiguration configuration;
    private final OperateTemplate operateTemplate;
    private final AnnotationFinder annotationFinder;
    private final PropertyOperator propertyOperator;
    private final AutoOperateProxy autoOperateProxy;
    private final OperatorProxyFactory operatorProxyFactory;
    private final ContainerMethodAnnotationProcessor containerMethodAnnotationProcessor;
    private final OpsForProxy opsForProxy = new OpsForProxy();
    private final OpsForContainer opsForContainer = new OpsForContainer();
    private final OpsForComponent opsForComponent = new OpsForComponent();

    public static Crane4jTemplate withDefaultConfiguration() {
        return Crane4jTemplate.withDefaultConfiguration(builder -> {});
    }

    public static Crane4jTemplate withDefaultConfiguration(@NonNull Consumer<SimpleCrane4jGlobalConfiguration.Builder> builderConsumer) {
        SimpleCrane4jGlobalConfiguration.Builder confBuilder = SimpleCrane4jGlobalConfiguration.builder();
        builderConsumer.accept(confBuilder);
        SimpleCrane4jGlobalConfiguration conf = confBuilder.build();
        return Crane4jTemplate.builder().configuration(conf).annotationFinder(conf.getAnnotationFinder()).propertyOperator(conf.getPropertyOperator()).autoOperateProxy(ConfigurationUtil.createAutoOperateProxy(conf)).operateTemplate(ConfigurationUtil.createOperateTemplate(conf)).operatorProxyFactory(ConfigurationUtil.createOperatorProxyFactory(conf)).containerMethodAnnotationProcessor(ConfigurationUtil.createContainerMethodAnnotationProcessor(conf)).build();
    }

    public BeanOperations getBeanOperations(@NonNull AnnotatedElement element) {
        BeanOperationParser parser = this.configuration.getBeanOperationsParser(BeanOperationParser.class);
        return parser.parse(element);
    }

    public void execute(Collection<?> targets, BeanOperationExecutor executor, Predicate<? super KeyTriggerOperation> filter) {
        this.operateTemplate.execute(targets, executor, filter);
    }

    public void execute(Collection<?> targets, BeanOperationExecutor executor) {
        this.execute(targets, executor, ops -> true);
    }

    public void execute(Collection<?> targets, Class<? extends BeanOperationExecutor> executorType) {
        BeanOperationExecutor executor = this.configuration.getBeanOperationExecutor(executorType);
        this.execute(targets, executor, ops -> true);
    }

    public void execute(Collection<?> targets) {
        this.operateTemplate.execute(targets);
    }

    public void execute(Collection<?> targets, BeanOperations beanOperations) {
        this.operateTemplate.execute(targets, beanOperations);
    }

    public void executeAsync(Collection<?> targets, Predicate<? super KeyTriggerOperation> filter) {
        BeanOperationExecutor executor = this.configuration.getBeanOperationExecutor(AsyncBeanOperationExecutor.class);
        this.operateTemplate.execute(targets, executor, filter);
    }

    public void executeAsync(Collection<?> targets) {
        this.executeAsync(targets, ops -> true);
    }

    public void executeOrdered(Collection<?> targets, Predicate<? super KeyTriggerOperation> filter) {
        BeanOperationExecutor executor = this.configuration.getBeanOperationExecutor(OrderedBeanOperationExecutor.class);
        this.operateTemplate.execute(targets, executor, filter);
    }

    public void executeOrdered(Collection<?> targets) {
        this.executeOrdered(targets, ops -> true);
    }

    Crane4jTemplate(Crane4jGlobalConfiguration configuration, OperateTemplate operateTemplate, AnnotationFinder annotationFinder, PropertyOperator propertyOperator, AutoOperateProxy autoOperateProxy, OperatorProxyFactory operatorProxyFactory, ContainerMethodAnnotationProcessor containerMethodAnnotationProcessor) {
        this.configuration = configuration;
        this.operateTemplate = operateTemplate;
        this.annotationFinder = annotationFinder;
        this.propertyOperator = propertyOperator;
        this.autoOperateProxy = autoOperateProxy;
        this.operatorProxyFactory = operatorProxyFactory;
        this.containerMethodAnnotationProcessor = containerMethodAnnotationProcessor;
    }

    public static Crane4jTemplateBuilder builder() {
        return new Crane4jTemplateBuilder();
    }

    public Crane4jGlobalConfiguration configuration() {
        return this.configuration;
    }

    public OperateTemplate operateTemplate() {
        return this.operateTemplate;
    }

    public OpsForProxy opsForProxy() {
        return this.opsForProxy;
    }

    public OpsForContainer opsForContainer() {
        return this.opsForContainer;
    }

    public OpsForComponent opsForComponent() {
        return this.opsForComponent;
    }

    public static class Crane4jTemplateBuilder {
        private Crane4jGlobalConfiguration configuration;
        private OperateTemplate operateTemplate;
        private AnnotationFinder annotationFinder;
        private PropertyOperator propertyOperator;
        private AutoOperateProxy autoOperateProxy;
        private OperatorProxyFactory operatorProxyFactory;
        private ContainerMethodAnnotationProcessor containerMethodAnnotationProcessor;

        Crane4jTemplateBuilder() {
        }

        public Crane4jTemplateBuilder configuration(Crane4jGlobalConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Crane4jTemplateBuilder operateTemplate(OperateTemplate operateTemplate) {
            this.operateTemplate = operateTemplate;
            return this;
        }

        public Crane4jTemplateBuilder annotationFinder(AnnotationFinder annotationFinder) {
            this.annotationFinder = annotationFinder;
            return this;
        }

        public Crane4jTemplateBuilder propertyOperator(PropertyOperator propertyOperator) {
            this.propertyOperator = propertyOperator;
            return this;
        }

        public Crane4jTemplateBuilder autoOperateProxy(AutoOperateProxy autoOperateProxy) {
            this.autoOperateProxy = autoOperateProxy;
            return this;
        }

        public Crane4jTemplateBuilder operatorProxyFactory(OperatorProxyFactory operatorProxyFactory) {
            this.operatorProxyFactory = operatorProxyFactory;
            return this;
        }

        public Crane4jTemplateBuilder containerMethodAnnotationProcessor(ContainerMethodAnnotationProcessor containerMethodAnnotationProcessor) {
            this.containerMethodAnnotationProcessor = containerMethodAnnotationProcessor;
            return this;
        }

        public Crane4jTemplate build() {
            return new Crane4jTemplate(this.configuration, this.operateTemplate, this.annotationFinder, this.propertyOperator, this.autoOperateProxy, this.operatorProxyFactory, this.containerMethodAnnotationProcessor);
        }

        public String toString() {
            return "Crane4jTemplate.Crane4jTemplateBuilder(configuration=" + this.configuration + ", operateTemplate=" + this.operateTemplate + ", annotationFinder=" + this.annotationFinder + ", propertyOperator=" + this.propertyOperator + ", autoOperateProxy=" + this.autoOperateProxy + ", operatorProxyFactory=" + this.operatorProxyFactory + ", containerMethodAnnotationProcessor=" + this.containerMethodAnnotationProcessor + ")";
        }
    }

    public class OpsForProxy {
        public Crane4jTemplate opsForExecute() {
            return Crane4jTemplate.this;
        }

        public OpsForComponent opsForComponent() {
            return Crane4jTemplate.this.opsForComponent;
        }

        public OpsForContainer opsForContainer() {
            return Crane4jTemplate.this.opsForContainer;
        }

        public <T> @NonNull T createAutoOperateProxy(@NonNull T target) {
            return Crane4jTemplate.this.autoOperateProxy.wrapIfNecessary(target);
        }

        public <T> T createOperatorProxy(@NonNull Class<T> operator) {
            return Crane4jTemplate.this.operatorProxyFactory.get(operator);
        }

        public OpsForProxy registerOperatorProxyMethodFactory(@NonNull OperatorProxyMethodFactory proxyMethodFactory) {
            Crane4jTemplate.this.operatorProxyFactory.addProxyMethodFactory(proxyMethodFactory);
            return this;
        }
    }

    public class OpsForComponent {
        public Crane4jTemplate opsForExecute() {
            return Crane4jTemplate.this;
        }

        public OpsForProxy opsForProxy() {
            return Crane4jTemplate.this.opsForProxy;
        }

        public OpsForContainer opsForContainer() {
            return Crane4jTemplate.this.opsForContainer;
        }

        public OpsForComponent registerMethodContainerFactory(@NonNull MethodContainerFactory methodContainerFactory) {
            Crane4jTemplate.this.containerMethodAnnotationProcessor.registerMethodContainerFactory(methodContainerFactory);
            this.configureOperationAnnotationHandler(AssembleMethodAnnotationHandler.class, (service, handler) -> handler.registerMethodContainerFactory(methodContainerFactory));
            return this;
        }

        public OpsForComponent registerPropertyMappingStrategy(@NonNull PropertyMappingStrategy propertyMappingStrategy) {
            Crane4jTemplate.this.configuration.addPropertyMappingStrategy(propertyMappingStrategy);
            return this;
        }

        public OpsForComponent registerContainerLifecycleProcessor(@NonNull ContainerLifecycleProcessor lifecycle) {
            Crane4jTemplate.this.configuration.registerContainerLifecycleProcessor(lifecycle);
            return this;
        }

        public OpsForComponent registerOperationAnnotationHandler(OperationAnnotationHandler operationAnnotationHandler) {
            Optional.of(Crane4jTemplate.this.configuration.getBeanOperationsParser(TypeHierarchyBeanOperationParser.class)).map(TypeHierarchyBeanOperationParser.class::cast).ifPresent(parser -> parser.addOperationAnnotationHandler(operationAnnotationHandler));
            return this;
        }

        public OpsForComponent registerConditionParser(ConditionParser conditionParser) {
            Optional.of(Crane4jTemplate.this.configuration.getBeanOperationsParser(ConditionalTypeHierarchyBeanOperationParser.class)).map(ConditionalTypeHierarchyBeanOperationParser.class::cast).ifPresent(parser -> parser.registerConditionParser(conditionParser));
            return this;
        }

        public OpsForComponent registerCacheManager(CacheManager cacheManager) {
            Crane4jTemplate.this.configuration.registerCacheManager(cacheManager);
            return this;
        }

        public CacheManager getCacheManager(String name) {
            return Crane4jTemplate.this.configuration.getCacheManager(name);
        }

        public <M extends CacheManager> OpsForComponent configureCacheManager(String name, Class<M> managerType, BiConsumer<Crane4jTemplate, M> consumer) {
            Optional.of(Crane4jTemplate.this.configuration.getCacheManager(name)).filter(managerType::isInstance).map(managerType::cast).ifPresent(manager -> consumer.accept(Crane4jTemplate.this, manager));
            return this;
        }

        public <H extends OperationAnnotationHandler> OpsForComponent configureOperationAnnotationHandler(Class<H> handlerType, BiConsumer<Crane4jTemplate, H> consumer) {
            Optional.of(Crane4jTemplate.this.configuration.getBeanOperationsParser(TypeHierarchyBeanOperationParser.class)).map(TypeHierarchyBeanOperationParser.class::cast).map(TypeHierarchyBeanOperationParser::getOperationAnnotationHandlers).map(handlers -> handlers.stream().filter(handlerType::isInstance).map(handlerType::cast)).ifPresent(handlers -> handlers.forEach(h -> consumer.accept(Crane4jTemplate.this, h)));
            return this;
        }
    }

    public class OpsForContainer {
        public Crane4jTemplate opsForExecute() {
            return Crane4jTemplate.this;
        }

        public OpsForComponent opsForComponent() {
            return Crane4jTemplate.this.opsForComponent;
        }

        public OpsForProxy opsForProxy() {
            return Crane4jTemplate.this.opsForProxy;
        }

        public <K> Container<K> wrapContainerWithCache(Container<K> container, String cacheManagerName, long expireTimeMilli) {
            CacheDefinition.Impl cacheDefinition = new CacheDefinition.Impl(container.getNamespace(), cacheManagerName, expireTimeMilli, TimeUnit.MILLISECONDS);
            CacheManager cacheManager = Crane4jTemplate.this.configuration.getCacheManager(cacheDefinition.getCacheManager());
            return new CacheableContainer<K>(container, cacheDefinition, cacheManager);
        }

        public Collection<Container<Object>> getMethodContainersFromTarget(@NonNull Object target) {
            return Crane4jTemplate.this.containerMethodAnnotationProcessor.process(target, target.getClass());
        }

        public @NonNull OpsForContainer registerConstantContainer(Class<?> constantType) {
            Container<Object> container = Containers.forConstantClass(constantType, Crane4jTemplate.this.annotationFinder);
            Crane4jTemplate.this.configuration.registerContainer((Container)container);
            return this;
        }

        public <E extends Enum<E>> @NonNull OpsForContainer registerEnumContainer(Class<E> enumType) {
            Container container = Containers.forEnum(enumType, Crane4jTemplate.this.annotationFinder, Crane4jTemplate.this.propertyOperator);
            Crane4jTemplate.this.configuration.registerContainer(container);
            return this;
        }

        public <E extends Enum<E>, K, V> @NonNull OpsForContainer registerEnumContainer(@NonNull String namespace, Class<E> enumType, Function<E, K> keyMapper, Function<E, V> valueMapper) {
            Map<K, V> enumData = Stream.of(enumType.getEnumConstants()).collect(Collectors.toMap(keyMapper, valueMapper));
            this.registerMapContainer(namespace, enumData);
            return this;
        }

        public <E extends Enum<E>, K> @NonNull OpsForContainer registerEnumContainer(@NonNull String namespace, Class<E> enumType, Function<E, K> keyMapper) {
            this.registerEnumContainer(namespace, enumType, keyMapper, Function.identity());
            return this;
        }

        public <K> @NonNull OpsForContainer registerMapContainer(@NonNull String namespace, @NonNull Map<K, ?> map) {
            ImmutableMapContainer<K> container = Containers.forMap(namespace, map);
            Crane4jTemplate.this.configuration.registerContainer(container);
            return this;
        }

        public <T, K, V> @NonNull OpsForContainer registerMapContainer(@NonNull String namespace, @NonNull Collection<T> datasource, Function<T, K> keyMapper, Function<T, V> valueMapper) {
            Map<K, V> map = datasource.stream().collect(Collectors.toMap(keyMapper, valueMapper));
            return this.registerMapContainer(namespace, map);
        }

        public <K> @NonNull OpsForContainer registerLambdaContainer(@NonNull String namespace, DataProvider<K, ?> dataProvider) {
            LambdaContainer<K> container = Containers.forLambda(namespace, dataProvider);
            Crane4jTemplate.this.configuration.registerContainer(container);
            return this;
        }

        public @NonNull OpsForContainer registerMethodContainers(@NonNull Object target) {
            Collection<Container<Object>> containers = this.getMethodContainersFromTarget(target);
            containers.forEach(Crane4jTemplate.this.configuration::registerContainer);
            return this;
        }

        public @NonNull OpsForContainer registerContainer(Container<?> container) {
            Crane4jTemplate.this.configuration.registerContainer((Container)container);
            return this;
        }

        public @Nullable Container<Object> getContainer(String namespace) {
            return Crane4jTemplate.this.configuration.getContainer(namespace);
        }

        public OpsForContainer registerContainerProvider(String providerName, @NonNull ContainerProvider containerProvider) {
            Crane4jTemplate.this.configuration.registerContainerProvider(providerName, containerProvider);
            return this;
        }

        public <P extends ContainerProvider> OpsForContainer configureContainerProvider(String providerName, Class<P> provider, BiConsumer<Crane4jTemplate, ContainerProvider> consumer) {
            Optional.ofNullable(Crane4jTemplate.this.configuration.getContainerProvider(providerName)).filter(provider::isInstance).map(provider::cast).ifPresent(p -> consumer.accept(Crane4jTemplate.this, (ContainerProvider)p));
            return this;
        }

        public @Nullable ContainerProvider getContainerProvider(String providerName) {
            return Crane4jTemplate.this.configuration.getContainerProvider(providerName);
        }

        public <K> OpsForContainer refreshContainerData(String namespace, @NonNull Map<K, ?> data) {
            Container container = Crane4jTemplate.this.configuration.getContainer(namespace);
            if (Objects.isNull(container)) {
                this.registerMapContainer(namespace, data);
                return this;
            }
            Asserts.isTrue(container instanceof LimitedContainer, "Container [{}] does not support refreshing data, is it a [{}]?", namespace, LimitedContainer.class);
            ((LimitedContainer)container).refresh(data);
            return this;
        }
    }
}

