/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container;

import cn.crane4j.annotation.ContainerCache;
import cn.crane4j.annotation.ContainerMethod;
import cn.crane4j.core.cache.CacheDefinition;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.cache.CacheableContainer;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.container.DefaultMethodContainerFactory;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableMethodContainerFactory
extends DefaultMethodContainerFactory {
    private static final Logger log = LoggerFactory.getLogger(CacheableMethodContainerFactory.class);
    private final Crane4jGlobalConfiguration configuration;

    public CacheableMethodContainerFactory(MethodInvokerContainerCreator methodInvokerContainerCreator, AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration) {
        super(methodInvokerContainerCreator, annotationFinder);
        this.configuration = configuration;
    }

    @Override
    public List<Container<Object>> get(@Nullable Object source, Method method, Collection<ContainerMethod> annotations) {
        log.debug("create cacheable method container from [{}]", (Object)method);
        ContainerCache annotation = this.annotationFinder.findAnnotation(method, ContainerCache.class);
        if (Objects.isNull(annotation)) {
            return super.get(source, method, annotations);
        }
        String managerName = StringUtils.emptyToDefault(annotation.cacheManager(), "MapCacheManager");
        CacheManager cacheManager = this.configuration.getCacheManager(managerName);
        return super.get(source, method, annotations).stream().map(container -> {
            CacheDefinition.Impl cacheDefinition = new CacheDefinition.Impl(container.getNamespace(), managerName, annotation.expirationTime(), annotation.timeUnit());
            return new CacheableContainer(container, cacheDefinition, cacheManager);
        }).collect(Collectors.toList());
    }
}

