/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container;

import cn.crane4j.annotation.ContainerMethod;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.container.AbstractContainerMethodSupport;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.MultiMap;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerMethodAnnotationProcessor
extends AbstractContainerMethodSupport {
    private static final Logger log = LoggerFactory.getLogger(ContainerMethodAnnotationProcessor.class);
    protected final AnnotationFinder annotationFinder;
    protected final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    public ContainerMethodAnnotationProcessor(Collection<MethodContainerFactory> methodContainerFactories, AnnotationFinder annotationFinder) {
        super(methodContainerFactories);
        this.annotationFinder = annotationFinder;
    }

    public final Collection<Container<Object>> process(Object target, Class<?> type) {
        if (this.nonAnnotatedClasses.contains(type)) {
            return Collections.emptyList();
        }
        MultiMap<Method, ContainerMethod> annotatedMethods = MultiMap.linkedHashMultimap();
        Method[] allMethods = this.collectMethodLevelAnnotatedMethods(type, annotatedMethods);
        this.collectClassLevelAnnotatedMethods(type, allMethods, annotatedMethods);
        if (annotatedMethods.isEmpty()) {
            this.nonAnnotatedClasses.add(type);
            return Collections.emptyList();
        }
        return this.processAnnotatedMethod(target, annotatedMethods);
    }

    protected void collectClassLevelAnnotatedMethods(Class<?> type, Method[] methods, MultiMap<Method, ContainerMethod> annotatedMethods) {
        Collection<ContainerMethod> classLevelAnnotation = this.resolveAnnotationsForClass(type);
        for (ContainerMethod annotation : classLevelAnnotation) {
            Method resolvedMethod = this.findMatchedMethodForAnnotation(Arrays.asList(methods), annotation);
            if (!Objects.nonNull(resolvedMethod)) continue;
            annotatedMethods.put(resolvedMethod, annotation);
        }
    }

    protected Method[] collectMethodLevelAnnotatedMethods(Class<?> type, MultiMap<Method, ContainerMethod> annotatedMethods) {
        Method[] methods;
        for (Method method : methods = ReflectUtils.getMethods(type)) {
            Collection<ContainerMethod> annotations = this.resolveAnnotationsForMethod(method);
            if (annotations.isEmpty()) continue;
            annotatedMethods.putAll(method, annotations);
        }
        return methods;
    }

    protected Collection<Container<Object>> processAnnotatedMethod(Object target, MultiMap<Method, ContainerMethod> annotatedMethods) {
        return annotatedMethods.asMap().entrySet().stream().map(e -> this.createMethodContainer(target, (Method)e.getKey(), (Collection)e.getValue())).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected Collection<ContainerMethod> resolveAnnotationsForClass(Class<?> type) {
        return this.annotationFinder.findAllAnnotations(type, ContainerMethod.class);
    }

    protected Collection<ContainerMethod> resolveAnnotationsForMethod(Method method) {
        return this.annotationFinder.getAllAnnotations(method, ContainerMethod.class);
    }
}

