/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.operator;

import cn.crane4j.annotation.ContainerParam;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.ContainerAdapterRegister;
import cn.crane4j.core.support.Grouped;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.ParameterConvertibleMethodInvoker;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicContainerOperatorProxyMethodFactory
implements OperatorProxyMethodFactory {
    private static final Logger log = LoggerFactory.getLogger(DynamicContainerOperatorProxyMethodFactory.class);
    private final ConverterManager converterManager;
    private final ParameterNameFinder parameterNameFinder;
    private final AnnotationFinder annotationFinder;
    private final ContainerAdapterRegister containerAdapterRegister;

    public DynamicContainerOperatorProxyMethodFactory(ConverterManager converterManager, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder, ContainerAdapterRegister containerAdapterRegister) {
        this.converterManager = converterManager;
        this.parameterNameFinder = parameterNameFinder;
        this.annotationFinder = annotationFinder;
        this.containerAdapterRegister = containerAdapterRegister;
    }

    @Override
    public int getSort() {
        return 1;
    }

    @Override
    public @Nullable MethodInvoker get(BeanOperations beanOperations, Method method, BeanOperationExecutor beanOperationExecutor) {
        Map<String, Parameter> parameterNameMap = ReflectUtils.resolveParameterNames(this.parameterNameFinder, method);
        if (parameterNameMap.size() == 1) {
            return null;
        }
        ContainerParameterAdapter[] adaptors = this.resolveContainerParameterAdaptors(method, parameterNameMap);
        if (Arrays.stream(adaptors).allMatch(Objects::isNull)) {
            return null;
        }
        log.info("create dynamic container proxy method for method: {}", (Object)method);
        DynamicContainerMethodInvoker invoker = new DynamicContainerMethodInvoker(beanOperations, beanOperationExecutor, adaptors);
        return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, method.getParameterTypes());
    }

    private @NonNull ContainerParameterAdapter[] resolveContainerParameterAdaptors(Method method, Map<String, Parameter> parameterNameMap) {
        ContainerParameterAdapter[] adaptors = new ContainerParameterAdapter[parameterNameMap.size()];
        AtomicInteger index = new AtomicInteger(0);
        parameterNameMap.forEach((n, p) -> {
            int curr = index.getAndIncrement();
            if (curr == 0) {
                return;
            }
            String namespace = Optional.ofNullable(this.annotationFinder.getAnnotation((AnnotatedElement)p, ContainerParam.class)).map(ContainerParam::value).orElse((String)n);
            adaptors[curr] = this.findAdaptor(namespace, (String)n, (Parameter)p, method);
        });
        return adaptors;
    }

    private @Nullable ContainerParameterAdapter findAdaptor(String namespace, String parameterName, Parameter parameter, Method method) {
        Class<?> parameterType = parameter.getType();
        ContainerAdapterRegister.Adapter adapter = this.containerAdapterRegister.getAdapter(parameterType);
        if (Objects.isNull(adapter)) {
            log.warn("cannot find adaptor provider for type [{}] of param [{}] in method [{}]", new Object[]{parameterType, parameterName, method});
            return null;
        }
        return new ContainerParameterAdapter(namespace, adapter);
    }

    protected static class ContainerParameterAdapter {
        private final String namespace;
        private final ContainerAdapterRegister.Adapter adapter;

        public Container<Object> wrap(Object target) {
            return this.adapter.wrapIfPossible(this.namespace, target);
        }

        public ContainerParameterAdapter(String namespace, ContainerAdapterRegister.Adapter adapter) {
            this.namespace = namespace;
            this.adapter = adapter;
        }
    }

    protected static class DynamicContainerMethodInvoker
    implements MethodInvoker {
        private final BeanOperations operations;
        private final BeanOperationExecutor beanOperationExecutor;
        private final ContainerParameterAdapter[] adaptors;

        @Override
        public Object invoke(Object target, Object ... args) {
            Object bean = args[0];
            Collection<?> targets = CollectionUtils.adaptObjectToCollection(bean);
            if (targets.isEmpty()) {
                return bean;
            }
            if (args.length == 1) {
                this.beanOperationExecutor.execute(targets, this.operations);
                return bean;
            }
            Map<String, Container<Object>> temporaryContainers = IntStream.rangeClosed(0, args.length - 1).filter(i -> Objects.nonNull(args[i]) && Objects.nonNull(this.adaptors[i])).mapToObj(i -> this.adaptors[i].wrap(args[i])).filter(Objects::nonNull).collect(Collectors.toMap(Container::getNamespace, Function.identity()));
            this.beanOperationExecutor.execute(targets, this.operations, new BeanOperationExecutor.Options.DynamicContainerOption(Grouped.alwaysMatch(), temporaryContainers));
            return bean;
        }

        public DynamicContainerMethodInvoker(BeanOperations operations, BeanOperationExecutor beanOperationExecutor, ContainerParameterAdapter[] adaptors) {
            this.operations = operations;
            this.beanOperationExecutor = beanOperationExecutor;
            this.adaptors = adaptors;
        }
    }
}

