/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.extension.spring;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.container.ContainerMethodAnnotationProcessor;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.util.Asserts;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.ScopedObject;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;

@Order
public class BeanMethodContainerRegistrar
extends ContainerMethodAnnotationProcessor
implements InitializingBean,
SmartInitializingSingleton,
ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(BeanMethodContainerRegistrar.class);
    private ApplicationContext applicationContext;
    private final Crane4jGlobalConfiguration configuration;

    public BeanMethodContainerRegistrar(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration) {
        super(Collections.emptyList(), annotationFinder);
        this.configuration = configuration;
    }

    public void destroy() {
        this.nonAnnotatedClasses.clear();
    }

    public void register(Object target, Class<?> targetType) {
        this.register(target, targetType, null);
    }

    public void register(Object target, Class<?> targetType, @Nullable UnaryOperator<Container<Object>> customizer) {
        Asserts.isNotNull((Object)this.applicationContext, (String)"applicationContext must not be null", (Object[])new Object[0]);
        Collection containers = this.process(target, targetType);
        if (containers.isEmpty()) {
            return;
        }
        log.debug("process [{}] annotated methods for bean [{}]", (Object)containers.size(), target);
        customizer = Objects.isNull(customizer) ? UnaryOperator.identity() : customizer;
        containers.stream().map(customizer).forEach(arg_0 -> ((Crane4jGlobalConfiguration)this.configuration).registerContainer(arg_0));
    }

    public void afterPropertiesSet() {
        Asserts.isNotNull((Object)this.applicationContext, (String)"applicationContext must not be null", (Object[])new Object[0]);
        Asserts.isTrue((boolean)(this.applicationContext.getAutowireCapableBeanFactory() instanceof ConfigurableListableBeanFactory), (String)"applicationContext must have a ConfigurableListableBeanFactory", (Object[])new Object[0]);
        Map containerFactories = this.applicationContext.getBeansOfType(MethodContainerFactory.class);
        containerFactories.forEach((n, f) -> {
            log.info("register method container factory [{}] with name [{}]", (Object)f.getClass().getName(), n);
            this.registerMethodContainerFactory((MethodContainerFactory)f);
        });
    }

    public void afterSingletonsInstantiated() {
        String[] beanNames;
        ConfigurableListableBeanFactory beanFactory = (ConfigurableListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        for (String beanName : beanNames = beanFactory.getBeanNamesForType(Object.class)) {
            Class<?> beanType = this.determineTargetType(beanFactory, beanName);
            if (Objects.isNull(beanType)) continue;
            Object bean = beanFactory.getBean(beanName);
            Collection containers = this.process(bean, beanType);
            log.debug("process [{}] annotated methods for bean [{}]", (Object)containers.size(), (Object)beanName);
            containers.forEach(arg_0 -> ((Crane4jGlobalConfiguration)this.configuration).registerContainer(arg_0));
        }
        this.nonAnnotatedClasses.clear();
    }

    private @Nullable Class<?> determineTargetType(ConfigurableListableBeanFactory beanFactory, String beanName) {
        try {
            Class type = AutoProxyUtils.determineTargetClass((ConfigurableListableBeanFactory)beanFactory, (String)beanName);
            if (ScopedObject.class.isAssignableFrom(type)) {
                Class clazz = AutoProxyUtils.determineTargetClass((ConfigurableListableBeanFactory)beanFactory, (String)ScopedProxyUtils.getTargetBeanName((String)beanName));
            }
            return type;
        }
        catch (Throwable ex) {
            log.debug("Could not resolve target class for bean with name '" + beanName + "'", ex);
            return null;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

