/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ftp;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import cn.hutool.extra.ftp.FtpMode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class Ftp
extends AbstractFtp {
    public static final int DEFAULT_PORT = 21;
    private FTPClient client;
    private FtpMode mode;
    private boolean backToPwd;

    public Ftp(String host) {
        this(host, 21);
    }

    public Ftp(String host, int port) {
        this(host, port, "anonymous", "");
    }

    public Ftp(String host, int port, String user, String password) {
        this(host, port, user, password, CharsetUtil.CHARSET_UTF_8);
    }

    public Ftp(String host, int port, String user, String password, Charset charset) {
        this(host, port, user, password, charset, null);
    }

    public Ftp(String host, int port, String user, String password, Charset charset, FtpMode mode) {
        this(new FtpConfig(host, port, user, password, charset), mode);
    }

    public Ftp(FtpConfig config, FtpMode mode) {
        super(config);
        this.mode = mode;
        this.init();
    }

    public Ftp init() {
        return this.init(this.ftpConfig, this.mode);
    }

    public Ftp init(String host, int port, String user, String password) {
        return this.init(host, port, user, password, null);
    }

    public Ftp init(String host, int port, String user, String password, FtpMode mode) {
        return this.init(new FtpConfig(host, port, user, password, this.ftpConfig.getCharset()), mode);
    }

    public Ftp init(FtpConfig config, FtpMode mode) {
        FTPClient client = new FTPClient();
        client.setControlEncoding(config.getCharset().toString());
        client.setConnectTimeout((int)config.getConnectionTimeout());
        try {
            client.connect(config.getHost(), config.getPort());
            client.setSoTimeout((int)config.getSoTimeout());
            client.login(config.getUser(), config.getPassword());
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        int replyCode = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            try {
                client.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FtpException("Login failed for user [{}], reply code is: [{}]", config.getUser(), replyCode);
        }
        this.client = client;
        if (mode != null) {
            this.setMode(mode);
        }
        return this;
    }

    public Ftp setMode(FtpMode mode) {
        this.mode = mode;
        switch (mode) {
            case Active: {
                this.client.enterLocalActiveMode();
                break;
            }
            case Passive: {
                this.client.enterLocalPassiveMode();
            }
        }
        return this;
    }

    public Ftp setBackToPwd(boolean backToPwd) {
        this.backToPwd = backToPwd;
        return this;
    }

    @Override
    public Ftp reconnectIfTimeout() {
        String pwd = null;
        try {
            pwd = this.pwd();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
        if (pwd == null) {
            return this.init();
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        if (StrUtil.isBlank((CharSequence)directory)) {
            return false;
        }
        try {
            return this.client.changeWorkingDirectory(directory);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public String pwd() {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public List<String> ls(String path) {
        FTPFile[] ftpFiles = this.lsFiles(path);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (FTPFile ftpFile : ftpFiles) {
            fileNames.add(ftpFile.getName());
        }
        return fileNames;
    }

    public List<FTPFile> lsFiles(String path, Filter<FTPFile> filter) {
        Object[] ftpFiles = this.lsFiles(path);
        if (ArrayUtil.isEmpty((Object[])ftpFiles)) {
            return ListUtil.empty();
        }
        ArrayList<FTPFile> result = new ArrayList<FTPFile>(ftpFiles.length - 2);
        for (Object ftpFile : ftpFiles) {
            String fileName = ftpFile.getName();
            if (StrUtil.equals((CharSequence)".", (CharSequence)fileName) || StrUtil.equals((CharSequence)"..", (CharSequence)fileName) || null != filter && !filter.accept(ftpFile)) continue;
            result.add((FTPFile)ftpFile);
        }
        return result;
    }

    public FTPFile[] lsFiles(String path) {
        FTPFile[] ftpFiles;
        String pwd = null;
        if (StrUtil.isNotBlank((CharSequence)path)) {
            pwd = this.pwd();
            this.cd(path);
        }
        try {
            ftpFiles = this.client.listFiles();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            this.cd(pwd);
        }
        return ftpFiles;
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            return this.client.makeDirectory(dir);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean existFile(String path) {
        Object[] ftpFileArr;
        try {
            ftpFileArr = this.client.listFiles(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return ArrayUtil.isNotEmpty((Object[])ftpFileArr);
    }

    @Override
    public boolean delFile(String path) {
        boolean isSuccess;
        String pwd = this.pwd();
        String fileName = FileUtil.getName((String)path);
        String dir = StrUtil.removeSuffix((CharSequence)path, (CharSequence)fileName);
        this.cd(dir);
        try {
            isSuccess = this.client.deleteFile(fileName);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            this.cd(pwd);
        }
        return isSuccess;
    }

    @Override
    public boolean delDir(String dirPath) {
        FTPFile[] dirs;
        try {
            dirs = this.client.listFiles(dirPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        for (FTPFile ftpFile : dirs) {
            String name = ftpFile.getName();
            String childPath = StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{dirPath, name});
            if (ftpFile.isDirectory()) {
                if (".".equals(name) || "..".equals(name)) continue;
                this.delDir(childPath);
                continue;
            }
            this.delFile(childPath);
        }
        try {
            return this.client.removeDirectory(dirPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        Assert.notNull((Object)file, (String)"file to upload is null !", (Object[])new Object[0]);
        return this.upload(destPath, file.getName(), file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean upload(String path, String fileName, File file) {
        try (BufferedInputStream in = FileUtil.getInputStream((File)file);){
            boolean bl = this.upload(path, fileName, in);
            return bl;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean upload(String path, String fileName, InputStream fileStream) {
        boolean isOk;
        try {
            this.client.setFileType(2);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        if (StrUtil.isNotBlank((CharSequence)path)) {
            this.mkDirs(path);
            isOk = this.cd(path);
            if (!isOk) {
                return false;
            }
        }
        try {
            isOk = this.client.storeFile(fileName, fileStream);
            return isOk;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    @Override
    public void download(String path, File outFile) {
        String fileName = FileUtil.getName((String)path);
        String dir = StrUtil.removeSuffix((CharSequence)path, (CharSequence)fileName);
        this.download(dir, fileName, outFile);
    }

    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) {
        for (FTPFile ftpFile : this.lsFiles(sourcePath, null)) {
            String fileName = ftpFile.getName();
            String srcFile = StrUtil.format((CharSequence)"{}/{}", (Object[])new Object[]{sourcePath, fileName});
            File destFile = FileUtil.file((File)destDir, (String)fileName);
            if (!ftpFile.isDirectory()) {
                if (FileUtil.exist((File)destFile) && ftpFile.getTimestamp().getTimeInMillis() <= destFile.lastModified()) continue;
                this.download(srcFile, destFile);
                continue;
            }
            FileUtil.mkdir((File)destFile);
            this.recursiveDownloadFolder(srcFile, destFile);
        }
    }

    public void download(String path, String fileName, File outFile) {
        if (outFile.isDirectory()) {
            outFile = new File(outFile, fileName);
        }
        if (!outFile.exists()) {
            FileUtil.touch((File)outFile);
        }
        try (BufferedOutputStream out = FileUtil.getOutputStream((File)outFile);){
            this.download(path, fileName, out);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public void download(String path, String fileName, OutputStream out) {
        String pwd = null;
        if (this.backToPwd) {
            pwd = this.pwd();
        }
        this.cd(path);
        try {
            this.client.setFileType(2);
            this.client.retrieveFile(fileName, out);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        finally {
            if (this.backToPwd) {
                this.cd(pwd);
            }
        }
    }

    public FTPClient getClient() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        if (null != this.client) {
            this.client.logout();
            if (this.client.isConnected()) {
                this.client.disconnect();
            }
            this.client = null;
        }
    }
}

