/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.client;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.common.annotation.Mapping;
import com.aizuda.snailjob.client.common.annotation.SnailEndPoint;
import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.common.rpc.client.RequestMethod;
import com.aizuda.snailjob.client.job.core.IJobExecutor;
import com.aizuda.snailjob.client.job.core.cache.JobExecutorInfoCache;
import com.aizuda.snailjob.client.job.core.cache.ThreadPoolCache;
import com.aizuda.snailjob.client.job.core.dto.JobExecutorInfo;
import com.aizuda.snailjob.client.job.core.executor.AbstractJobExecutor;
import com.aizuda.snailjob.client.job.core.executor.AbstractMapExecutor;
import com.aizuda.snailjob.client.job.core.executor.AbstractMapReduceExecutor;
import com.aizuda.snailjob.client.job.core.executor.AnnotationJobExecutor;
import com.aizuda.snailjob.client.job.core.executor.AnnotationMapJobExecutor;
import com.aizuda.snailjob.client.job.core.executor.AnnotationMapReduceJobExecutor;
import com.aizuda.snailjob.client.job.core.log.JobLogMeta;
import com.aizuda.snailjob.client.model.StopJobDTO;
import com.aizuda.snailjob.client.model.request.DispatchJobRequest;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.ExecutorTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.model.JobArgsHolder;
import com.aizuda.snailjob.common.core.model.JobContext;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.google.common.collect.Maps;
import jakarta.validation.Valid;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.validation.annotation.Validated;

@SnailEndPoint
@Validated
public class JobEndPoint {
    @Mapping(path="/job/dispatch/v1", method=RequestMethod.POST)
    public Result<Boolean> dispatchJob(@Valid DispatchJobRequest dispatchJob) {
        try {
            JobContext jobContext = JobEndPoint.buildJobContext(dispatchJob);
            this.initLogContext(jobContext);
            if (Objects.nonNull(dispatchJob.getRetryCount()) && dispatchJob.getRetryCount() > 0) {
                SnailJobLog.REMOTE.info("Task execution/scheduling failed, executing retry. Retry count:[{}]", new Object[]{dispatchJob.getRetryCount()});
            }
            if (ExecutorTypeEnum.JAVA.getType() != dispatchJob.getExecutorType().intValue()) {
                SnailJobLog.REMOTE.error("Non-Java type executors are not supported. executorType:[{}]", new Object[]{dispatchJob.getExecutorType()});
                Result result = new Result("Non-Java type executors are not supported", (Object)Boolean.FALSE);
                return result;
            }
            JobExecutorInfo jobExecutorInfo = JobExecutorInfoCache.get(jobContext.getExecutorInfo());
            if (Objects.isNull(jobExecutorInfo)) {
                SnailJobLog.REMOTE.error("Executor configuration is incorrect. executorInfo:[{}]", new Object[]{dispatchJob.getExecutorInfo()});
                Result result = new Result("Executor configuration is incorrect", (Object)Boolean.FALSE);
                return result;
            }
            Object executor = jobExecutorInfo.getExecutor();
            IJobExecutor jobExecutor = IJobExecutor.class.isAssignableFrom(executor.getClass()) ? (JobTaskTypeEnum.MAP.getType() == jobContext.getTaskType().intValue() ? (AbstractMapExecutor)executor : (JobTaskTypeEnum.MAP_REDUCE.getType() == jobContext.getTaskType().intValue() ? (AbstractMapReduceExecutor)executor : (AbstractJobExecutor)executor)) : (JobTaskTypeEnum.MAP.getType() == jobContext.getTaskType().intValue() ? (IJobExecutor)SnailSpringContext.getBeanByType(AnnotationMapJobExecutor.class) : (JobTaskTypeEnum.MAP_REDUCE.getType() == jobContext.getTaskType().intValue() ? (IJobExecutor)SnailSpringContext.getBeanByType(AnnotationMapReduceJobExecutor.class) : (IJobExecutor)SnailSpringContext.getBeanByType(AnnotationJobExecutor.class)));
            SnailJobLog.REMOTE.info(" Task scheduler:[{}] Task ID:[{}] Task batch:[{}] Workflow batch:[{}] Task scheduled successfully.", new Object[]{Objects.isNull(dispatchJob.getWorkflowTaskBatchId()) ? "job" : "workflow", dispatchJob.getJobId(), dispatchJob.getTaskBatchId(), dispatchJob.getWorkflowTaskBatchId()});
            jobExecutor.jobExecute(jobContext);
        }
        catch (Exception e) {
            SnailJobLog.REMOTE.error("Client encountered an unexpected exception. taskBatchId:[{}]", new Object[]{dispatchJob.getTaskBatchId()});
            throw e;
        }
        finally {
            SnailJobLogManager.removeLogMeta();
        }
        return new Result((Object)Boolean.TRUE);
    }

    private void initLogContext(JobContext jobContext) {
        JobLogMeta logMeta = new JobLogMeta();
        logMeta.setNamespaceId(jobContext.getNamespaceId());
        logMeta.setTaskId(jobContext.getTaskId());
        logMeta.setGroupName(jobContext.getGroupName());
        logMeta.setJobId(jobContext.getJobId());
        logMeta.setTaskBatchId(jobContext.getTaskBatchId());
        SnailJobLogManager.initLogInfo((LogMeta)logMeta, (LogTypeEnum)LogTypeEnum.JOB);
    }

    private static JobContext buildJobContext(DispatchJobRequest dispatchJob) {
        JobContext jobContext = new JobContext();
        jobContext.setJobId(dispatchJob.getJobId());
        jobContext.setShardingTotal(dispatchJob.getShardingTotal());
        jobContext.setShardingIndex(dispatchJob.getShardingIndex());
        jobContext.setNamespaceId(dispatchJob.getNamespaceId());
        jobContext.setTaskId(dispatchJob.getTaskId());
        jobContext.setTaskBatchId(dispatchJob.getTaskBatchId());
        jobContext.setGroupName(dispatchJob.getGroupName());
        jobContext.setExecutorInfo(dispatchJob.getExecutorInfo());
        jobContext.setParallelNum(dispatchJob.getParallelNum());
        jobContext.setTaskType(dispatchJob.getTaskType());
        jobContext.setExecutorTimeout(dispatchJob.getExecutorTimeout());
        jobContext.setWorkflowNodeId(dispatchJob.getWorkflowNodeId());
        jobContext.setWorkflowTaskBatchId(dispatchJob.getWorkflowTaskBatchId());
        jobContext.setRetryStatus(dispatchJob.getRetryStatus());
        jobContext.setRetryScene(dispatchJob.getRetryScene());
        jobContext.setTaskName(dispatchJob.getTaskName());
        jobContext.setMrStage(dispatchJob.getMrStage());
        if (StrUtil.isNotBlank((CharSequence)dispatchJob.getArgsStr())) {
            try {
                jobContext.setJobArgsHolder((JobArgsHolder)JsonUtil.parseObject((String)dispatchJob.getArgsStr(), JobArgsHolder.class));
            }
            catch (Exception e) {
                SnailJobLog.REMOTE.warn("argsStr parse error", new Object[]{e});
                JobArgsHolder jobArgsHolder = new JobArgsHolder();
                jobArgsHolder.setJobParams((Object)dispatchJob.getArgsStr());
                jobContext.setJobArgsHolder(jobArgsHolder);
            }
        } else {
            jobContext.setJobArgsHolder(new JobArgsHolder());
        }
        String wfContext = dispatchJob.getWfContext();
        if (StrUtil.isNotBlank((CharSequence)wfContext)) {
            try {
                jobContext.setWfContext(JsonUtil.parseConcurrentHashMap((String)wfContext));
            }
            catch (Exception e) {
                SnailJobLog.REMOTE.warn("workflow context parse error", new Object[]{e});
            }
        } else {
            jobContext.setWfContext((Map)Maps.newConcurrentMap());
        }
        return jobContext;
    }

    @Mapping(path="/job/stop/v1", method=RequestMethod.POST)
    public Result<Boolean> stopJob(@Valid StopJobDTO interruptJob) {
        ThreadPoolExecutor threadPool = ThreadPoolCache.getThreadPool(interruptJob.getTaskBatchId());
        if (Objects.isNull(threadPool) || threadPool.isShutdown() || threadPool.isTerminated()) {
            return new Result((Object)Boolean.TRUE);
        }
        ThreadPoolCache.stopThreadPool(interruptJob.getTaskBatchId());
        return new Result((Object)(threadPool.isShutdown() || threadPool.isTerminated() ? 1 : 0));
    }
}

