/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor.builtin;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.model.ExecuteResult;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.exception.SnailJobInnerExecutorException;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;

public abstract class AbstractHttpExecutor
implements InitializingBean {
    private static final int DEFAULT_TIMEOUT = 60;
    private static SnailJobProperties snailJobProperties;
    private static final String DEFAULT_REQUEST_METHOD = "GET";
    private static final String POST_REQUEST_METHOD = "POST";
    private static final String PUT_REQUEST_METHOD = "PUT";
    private static final String DELETE_REQUEST_METHOD = "DELETE";
    private static final String HTTP = "http";
    private static final String HTTP_PREFIX = "http://";
    private static final int HTTP_SUCCESS_CODE = 200;
    private static final Pattern pattern;
    private static final int RESPONSE_SUCCESS_CODE = 200;
    private static final String RESPONSE_CODE_FIELD = "code";
    private static final String JSON_RESPONSE_TYPE = "json";
    private static final String TEXT_RESPONSE_TYPE = "text";

    public ExecuteResult process(HttpParams httpParams) {
        if (httpParams == null) {
            String message = "HttpParams is null. Verify jobParam configuration.";
            this.logWarn(message, new Object[0]);
            return ExecuteResult.failure((Object)message);
        }
        this.validateAndSetUrl(httpParams);
        this.setDefaultMethodAndBody(httpParams);
        this.setDefaultMediaType(httpParams);
        this.setDefaultTimeout(httpParams);
        this.logInfo("Request URL: {}\nUsing request method: {}\nRequest timeout: {} seconds", httpParams.getUrl(), httpParams.getMethod(), httpParams.getTimeout());
        HttpRequest httpRequest = this.buildhutoolRequest(httpParams);
        return this.executeRequestAndHandleResponse(httpRequest);
    }

    private ExecuteResult executeRequestAndHandleResponse(HttpRequest httpRequest) {
        ExecuteResult executeResult;
        block8: {
            HttpResponse response = httpRequest.execute();
            try {
                executeResult = this.validateResponse(response, httpRequest, snailJobProperties.getHttpResponse());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SnailJobInnerExecutorException("[snail-job] HTTP internal executor failed", (Throwable)e);
                }
            }
            response.close();
        }
        return executeResult;
    }

    private void validateAndSetUrl(HttpParams httpParams) {
        if (StringUtils.isEmpty((Object)httpParams.getUrl())) {
            throw new SnailJobInnerExecutorException("URL cannot be empty.");
        }
        httpParams.setUrl((String)(httpParams.getUrl().startsWith(HTTP) ? httpParams.getUrl() : HTTP_PREFIX + httpParams.getUrl()));
    }

    private ExecuteResult validateResponse(HttpResponse response, HttpRequest httpRequest, SnailJobProperties.HttpResponse httpResponse) {
        int errCode = response.getStatus();
        String body = response.body();
        if (errCode != 200) {
            SnailJobLog.LOCAL.error("{} request to URL: {} failed with code: {}, response body: {}", new Object[]{httpRequest.getMethod(), httpRequest.getUrl(), errCode, body});
            return ExecuteResult.failure((Object)"HTTP request failed");
        }
        if (Objects.nonNull(httpResponse)) {
            int code = Optional.ofNullable(httpResponse.getCode()).orElse(200);
            String field = Optional.ofNullable(httpResponse.getField()).filter(StringUtils::hasLength).orElse(RESPONSE_CODE_FIELD);
            String responseType = Optional.ofNullable(httpResponse.getField()).filter(StringUtils::hasLength).orElse(JSON_RESPONSE_TYPE);
            if (JSON_RESPONSE_TYPE.equalsIgnoreCase(responseType)) {
                return this.validateJsonResponse(body, code, field, httpRequest);
            }
            if (TEXT_RESPONSE_TYPE.equalsIgnoreCase(responseType)) {
                return this.validateTextResponse(body, code, httpRequest);
            }
            return ExecuteResult.failure((Object)"the responseType is not json or text");
        }
        return ExecuteResult.success((Object)body);
    }

    private ExecuteResult validateJsonResponse(String body, int code, String field, HttpRequest httpRequest) {
        if (!JsonUtil.isValidJson((String)body) || JsonUtil.isEmptyJson((String)body)) {
            SnailJobLog.LOCAL.error("the responseType is json\uff0cbut the response body fails to validate json or json is empty", new Object[0]);
            return ExecuteResult.failure((Object)"the responseType is json\uff0cbut the response body fails to validate json or json is empty");
        }
        Map objectObjectMap = JsonUtil.parseHashMap((String)body);
        if (!objectObjectMap.containsKey(field)) {
            SnailJobLog.LOCAL.error("the responseType is json\uff0cbut there is no status code field\uff1a{}", new Object[]{field});
            return ExecuteResult.failure((Object)("the responseType is json\uff0cbut there is no status code field\uff1a" + field));
        }
        if (!Objects.equals(code, objectObjectMap.get(field))) {
            SnailJobLog.LOCAL.error("{} request to URL: {} failed with code: {}, response body: {}", new Object[]{httpRequest.getMethod(), httpRequest.getUrl(), code, body});
            return ExecuteResult.failure((Object)"the response status code is not equal to the specified status code");
        }
        return ExecuteResult.success((Object)body);
    }

    private ExecuteResult validateTextResponse(String body, int code, HttpRequest httpRequest) {
        if (!StringUtils.hasLength((String)body)) {
            SnailJobLog.LOCAL.error("the responseType is text\uff0cbut the response body is empty", new Object[0]);
            return ExecuteResult.failure((Object)"the responseType is text\uff0cbut the response body is empty");
        }
        if (!Objects.equals("" + code, body)) {
            SnailJobLog.LOCAL.error("{} request to URL: {} failed with code: {}, response body: {}", new Object[]{httpRequest.getMethod(), httpRequest.getUrl(), code, body});
            return ExecuteResult.failure((Object)"the response status code is not equal to the specified status code");
        }
        return ExecuteResult.success((Object)body);
    }

    private void setDefaultMethodAndBody(HttpParams httpParams) {
        if (StringUtils.isEmpty((Object)httpParams.getMethod())) {
            httpParams.setMethod(DEFAULT_REQUEST_METHOD);
        } else {
            httpParams.setMethod(httpParams.getMethod().toUpperCase());
        }
        if (!DEFAULT_REQUEST_METHOD.equals(httpParams.getMethod()) && StringUtils.isEmpty((Object)httpParams.getBody())) {
            httpParams.setBody(JsonUtil.toJSONString());
            this.logWarn("Using default request body: {}", httpParams.getBody());
        }
    }

    private void setDefaultMediaType(HttpParams httpParams) {
        if (!DEFAULT_REQUEST_METHOD.equals(httpParams.getMethod()) && JsonUtil.isValidJson((String)httpParams.getBody()) && StringUtils.isEmpty((Object)httpParams.getMediaType())) {
            httpParams.setMediaType("application/json");
            this.logWarn("Using 'application/json' as media type", new Object[0]);
        }
    }

    private void setDefaultTimeout(HttpParams httpParams) {
        httpParams.setTimeout(Objects.isNull(httpParams.getTimeout()) ? 60000 : httpParams.getTimeout() * 1000);
    }

    private HttpRequest buildhutoolRequest(HttpParams httpParams) {
        HttpRequest request = switch (httpParams.getMethod()) {
            case PUT_REQUEST_METHOD -> HttpRequest.put((String)httpParams.url);
            case DELETE_REQUEST_METHOD -> HttpRequest.delete((String)httpParams.url);
            case POST_REQUEST_METHOD -> HttpRequest.post((String)httpParams.url);
            default -> HttpRequest.get((String)httpParams.url);
        };
        if (Objects.nonNull(httpParams.getHeaders())) {
            httpParams.getHeaders().forEach((arg_0, arg_1) -> ((HttpRequest)request).header(arg_0, arg_1));
        }
        if (Objects.nonNull(httpParams.getWfContext())) {
            httpParams.getWfContext().forEach((key, value) -> {
                String headerValue;
                String string = headerValue = value instanceof String ? (String)value : JsonUtil.toJsonString((Object)value);
                if (pattern.matcher(headerValue).find()) {
                    headerValue = Base64.getEncoder().encodeToString(headerValue.getBytes());
                }
                request.header(key, headerValue);
            });
        }
        if (Objects.nonNull(httpParams.getBody()) && (httpParams.getMethod().equals(POST_REQUEST_METHOD) || httpParams.getMethod().equals(PUT_REQUEST_METHOD) || httpParams.getMethod().equals(DELETE_REQUEST_METHOD))) {
            request.body(httpParams.getBody(), httpParams.getMediaType());
        }
        request.timeout(httpParams.getTimeout().intValue());
        return request;
    }

    private void logInfo(String msg, Object ... params) {
        SnailJobLog.REMOTE.info("[snail-job] " + msg, params);
    }

    private void logWarn(String msg, Object ... params) {
        SnailJobLog.REMOTE.warn("[snail-job] " + msg, params);
    }

    public void afterPropertiesSet() throws Exception {
        snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
    }

    static {
        pattern = Pattern.compile("[\\u4e00-\\u9fa5]");
    }

    public static class HttpParams {
        private String method;
        private String url;
        private String mediaType;
        private String body;
        private Map<String, String> headers;
        private Integer timeout;
        private Map<String, Object> wfContext;

        @Generated
        public HttpParams() {
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getMediaType() {
            return this.mediaType;
        }

        @Generated
        public String getBody() {
            return this.body;
        }

        @Generated
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Generated
        public Integer getTimeout() {
            return this.timeout;
        }

        @Generated
        public Map<String, Object> getWfContext() {
            return this.wfContext;
        }

        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Generated
        public void setBody(String body) {
            this.body = body;
        }

        @Generated
        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        @Generated
        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Generated
        public void setWfContext(Map<String, Object> wfContext) {
            this.wfContext = wfContext;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpParams)) {
                return false;
            }
            HttpParams other = (HttpParams)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$timeout = this.getTimeout();
            Integer other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$mediaType = this.getMediaType();
            String other$mediaType = other.getMediaType();
            if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Map<String, String> this$headers = this.getHeaders();
            Map<String, String> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            Map<String, Object> this$wfContext = this.getWfContext();
            Map<String, Object> other$wfContext = other.getWfContext();
            return !(this$wfContext == null ? other$wfContext != null : !((Object)this$wfContext).equals(other$wfContext));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HttpParams;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $mediaType = this.getMediaType();
            result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            Map<String, String> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            Map<String, Object> $wfContext = this.getWfContext();
            result = result * 59 + ($wfContext == null ? 43 : ((Object)$wfContext).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AbstractHttpExecutor.HttpParams(method=" + this.getMethod() + ", url=" + this.getUrl() + ", mediaType=" + this.getMediaType() + ", body=" + this.getBody() + ", headers=" + String.valueOf(this.getHeaders()) + ", timeout=" + this.getTimeout() + ", wfContext=" + String.valueOf(this.getWfContext()) + ")";
        }
    }
}

