/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel;

import com.alibaba.cloud.circuitbreaker.sentinel.ReactiveSentinelCircuitBreakerFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux"})
@ConditionalOnProperty(name={"spring.cloud.circuitbreaker.sentinel.enabled"}, havingValue="true", matchIfMissing=true)
public class ReactiveSentinelCircuitBreakerAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<ReactiveSentinelCircuitBreakerFactory>> customizers = new ArrayList<Customizer<ReactiveSentinelCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={ReactiveCircuitBreakerFactory.class})
    public ReactiveCircuitBreakerFactory reactiveSentinelCircuitBreakerFactory() {
        ReactiveSentinelCircuitBreakerFactory factory = new ReactiveSentinelCircuitBreakerFactory();
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }
}

