/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.exception.advice;

import com.anji.plus.gaea.bean.ResponseBean;
import com.anji.plus.gaea.exception.BusinessException;
import com.anji.plus.gaea.exception.ErrorFieldResolver;
import com.anji.plus.gaea.i18.MessageSourceHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.NoSuchMessageException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionHandlerAdvice {
    private Logger logger = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);
    @Autowired
    private MessageSourceHolder messageSourceHolder;
    @Autowired
    private ErrorFieldResolver resolver;

    @ExceptionHandler(value={BusinessException.class})
    public ResponseBean handleBusinessException(BusinessException ex) {
        String msg = ex.getMsg() == null ? this.messageSourceHolder.getMessage(ex.getCode(), ex.getArgs()) : ex.getMsg();
        return ResponseBean.builder().code(ex.getCode()).message(msg).args(ex.getArgs()).build();
    }

    @NotEmpty
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseBean methodArgumentNotValidException(MethodArgumentNotValidException ex) {
        FieldError fieldError = ex.getBindingResult().getFieldError();
        String message = fieldError.getDefaultMessage();
        String validationName = fieldError.getCode();
        String fieldName = fieldError.getField();
        fieldName = this.resolver.getFieldName(fieldName, ex.getParameter());
        ArrayList<String> messageArgs = new ArrayList<String>();
        messageArgs.add(fieldName);
        String hasArgusValidationNames = "DecimalMax DecimalMin Max Min Size Digits Pattern";
        Object[] arguments = fieldError.getArguments();
        if (hasArgusValidationNames.indexOf(validationName) > -1 && arguments != null) {
            List list = Arrays.stream(arguments).filter(argusment -> argusment instanceof Integer || argusment instanceof String || argusment instanceof Long).collect(Collectors.toList());
            messageArgs.addAll(list);
        }
        try {
            Object[] args = messageArgs.toArray();
            message = this.messageSourceHolder.getMessage(validationName, args);
        }
        catch (NoSuchMessageException exception) {
            try {
                message = fieldName + this.messageSourceHolder.getMessage(message, null);
            }
            catch (Exception e) {
                message = fieldName + message;
            }
        }
        return ResponseBean.builder().code("500").message(message).build();
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseBean exception(Exception exception) {
        this.logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)exception);
        ResponseBean.Builder builder = ResponseBean.builder();
        builder.code("500");
        builder.message(this.messageSourceHolder.getMessage("500", null));
        builder.args(new String[]{exception.getMessage()});
        return builder.build();
    }
}

