/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.holder;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.anji.plus.gaea.holder.UserContext;
import java.util.Locale;
import org.springframework.util.Assert;

public class UserContentHolder {
    private static final ThreadLocal<UserContext> userContextThreadLocal = new TransmittableThreadLocal();

    public static void clearContext() {
        userContextThreadLocal.remove();
    }

    public static UserContext getContext() {
        UserContext ctx = userContextThreadLocal.get();
        if (ctx == null) {
            ctx = UserContentHolder.createEmptyContext();
            userContextThreadLocal.set(ctx);
        }
        return ctx;
    }

    public static void setContext(UserContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted");
        userContextThreadLocal.set(context);
    }

    public static String getUsername() {
        return UserContentHolder.getContext().getUsername();
    }

    public static String getNickname() {
        return UserContentHolder.getContext().getNickname();
    }

    public static Integer getUserType() {
        return UserContentHolder.getContext().getType();
    }

    public static String getOrgCode() {
        return UserContentHolder.getContext().getOrgCode();
    }

    public static String getTenantCode() {
        return UserContentHolder.getContext().getTenantCode();
    }

    public static String getUuid() {
        return UserContentHolder.getContext().getUuid();
    }

    public static UserContext createEmptyContext() {
        return new UserContext();
    }

    public static Object getParam(String key) {
        return UserContentHolder.getContext().getParams().get(key);
    }

    public static void putParam(String key, Object value) {
        UserContentHolder.getContext().getParams().put(key, value);
    }

    public static Locale getLocale() {
        return UserContentHolder.getContext().getLocale();
    }

    public static String getTimeZone() {
        return UserContentHolder.getContext().getTimeZone();
    }
}

