/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.oss.ossbuilder.builders;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.anji.plus.gaea.oss.config.OSSProperties;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSException;
import com.anji.plus.gaea.oss.exceptions.GaeaOSSExceptionBuilder;
import com.anji.plus.gaea.oss.ossbuilder.GaeaOSSTemplate;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class AmazonS3Client
implements GaeaOSSTemplate {
    private static Logger logger = LoggerFactory.getLogger(AmazonS3Client.class);
    private AmazonS3 amazonS3;
    private String bucketName;
    private String fileTypeWhileList;

    @Override
    public String getFileTypeWhileList() {
        return this.fileTypeWhileList;
    }

    public AmazonS3Client(OSSProperties ossProperties) {
        this.fileTypeWhileList = ossProperties.getFileTypeWhileList();
        String url = ossProperties.getAmazonS3().getUrl();
        String accessKey = ossProperties.getAmazonS3().getAccessKey();
        String secretKey = ossProperties.getAmazonS3().getSecretKey();
        this.bucketName = ossProperties.getAmazonS3().getBucketName();
        try {
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, secretKey);
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setProtocol(Protocol.HTTP);
            clientConfig.setSignerOverride("S3SignerType");
            AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).withClientConfiguration(clientConfig)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(url, "cn-north-1"));
            this.amazonS3 = (AmazonS3)builder.build();
            boolean found = this.amazonS3.doesBucketExistV2(this.bucketName);
            if (!found) {
                this.amazonS3.createBucket(this.bucketName);
            }
            logger.info("\u521d\u59cb\u5316\u6587\u4ef6\u5b58\u50a8\uff0c\u6fc0\u6d3bAmazonS3\u5b58\u50a8\u6876:{}", (Object)this.bucketName);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u6587\u4ef6\u5b58\u50a8\uff0c\u6fc0\u6d3bAmazonS3\u5b58\u50a8\u6876:{}\u5931\u8d25:{}", (Object)this.bucketName, (Object)e);
        }
    }

    @Override
    public String uploadFileByInputStream(MultipartFile file, String fileObjectName) throws GaeaOSSException {
        this.checkFileSuffixName(file);
        InputStream fileInputStream = null;
        try {
            fileInputStream = file.getInputStream();
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentType("plain/text");
            metadata.addUserMetadata("title", "someTitle");
            this.amazonS3.putObject(this.bucketName, fileObjectName, fileInputStream, metadata);
        }
        catch (Exception e) {
            logger.error("save file to AmazonS3 store error:", (Throwable)e);
            throw GaeaOSSExceptionBuilder.build("save file to AmazonS3 store error", e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception e) {
                logger.error("close InputStream error:", (Throwable)e);
            }
        }
        return fileObjectName;
    }

    @Override
    public byte[] downloadFile(String fileObjectName) throws GaeaOSSException {
        byte[] fileBytes = null;
        InputStream inputStream = null;
        try {
            S3Object object = this.amazonS3.getObject(new GetObjectRequest(this.bucketName, fileObjectName));
            inputStream = object.getObjectContent();
            if (inputStream == null) {
                logger.error("file {} not exist in AmazonS3 store ", (Object)fileObjectName);
                throw GaeaOSSExceptionBuilder.build("file not exist in AmazonS3 store, objectName=" + fileObjectName);
            }
            fileBytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            logger.error("read file from minio store error:", (Throwable)e);
            throw GaeaOSSExceptionBuilder.build("read file from AmazonS3 store error, objectName=" + fileObjectName);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return fileBytes;
    }

    @Override
    public void deleteFile(String fileObjectName) {
        try {
            this.amazonS3.deleteObject(this.bucketName, fileObjectName);
        }
        catch (Exception e) {
            logger.warn("delete file in AmazonS3 store fail, bucket={}, file={}", (Object)this.bucketName, (Object)fileObjectName);
        }
    }

    @Override
    public void deleteFiles(List<String> fileObjectNames) {
        try {
            if (CollectionUtils.isEmpty(fileObjectNames)) {
                return;
            }
            List keys = fileObjectNames.stream().map(fileObject -> new DeleteObjectsRequest.KeyVersion(fileObject)).collect(Collectors.toList());
            DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.bucketName).withKeys(keys);
            this.amazonS3.deleteObjects(deleteObjectsRequest);
        }
        catch (Exception e) {
            logger.warn("delete file in AmazonS3 store fail, bucket={}, file={}", (Object)this.bucketName, (Object)fileObjectNames.toString());
        }
    }
}

